/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.application.help;

import com.highqsoft.fwk.application.help.FwkHelp;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.JHelpContentViewer;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpUI;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class FwkHelpUI
extends HelpUI
implements FwkInterface,
PropertyChangeListener {
    public static final String version = "$Revision: 1.4 $";
    protected FwkHelp help;
    protected JToolBar toolbar;
    protected JSplitPane splitPane;
    protected JTabbedPane tabbedPane;
    protected Vector navs = new Vector();
    private Vector history = new Vector();
    private int historyIndex = -1;
    private int dividerLocation = 0;
    private final double dividerLocationRatio = 0.3;
    private FwkCommandInterface prevCommand;
    private FwkCommandInterface nextCommand;
    private IdChangeListener changeListener = new IdChangeListener();

    public String getVersion() {
        return version;
    }

    public FwkHelpUI() {
    }

    public FwkHelpUI(JHelp b) {
        this();
    }

    public void release() {
    }

    public static ComponentUI createUI(JComponent x) {
        return new FwkHelpUI((JHelp)x);
    }

    public void installUI(JComponent c) {
        this.help = (FwkHelp)((Object)c);
        this.help.setLayout(new BorderLayout());
        this.help.addPropertyChangeListener(this);
        this.prevCommand = this.help.getCommand("PREV");
        this.nextCommand = this.help.getCommand("NEXT");
        HelpModel hm = this.getModel();
        if (hm != null) {
            hm.addHelpModelListener((HelpModelListener)this.changeListener);
        }
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setVisible(false);
        this.splitPane = new JSplitPane(1, false, this.tabbedPane, (Component)this.help.getContentViewer());
        this.splitPane.setOneTouchExpandable(true);
        this.help.add("Center", this.splitPane);
        this.rebuild();
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(700, 500);
    }

    public void addNavigator(JHelpNavigator nav) {
        this.navs.addElement(nav);
        Icon icon = nav.getIcon();
        if (icon != null) {
            this.tabbedPane.addTab("", icon, (Component)nav, nav.getNavigatorLabel());
        } else {
            String name = nav.getName();
            if (name == null) {
                name = "<unknown>";
            }
            this.tabbedPane.addTab(name, icon, (Component)nav);
        }
        this.tabbedPane.setVisible(this.help.isNavigatorDisplayed());
        this.help.invalidate();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if ((double)FwkHelpUI.this.dividerLocation == 0.0) {
                    Dimension dem = FwkHelpUI.this.splitPane.getSize();
                    if (dem.width != 0) {
                        FwkHelpUI.this.splitPane.setDividerLocation((int)((double)(dem.width - FwkHelpUI.this.splitPane.getDividerSize()) * 0.3));
                    }
                    FwkHelpUI.this.dividerLocation = FwkHelpUI.this.splitPane.getDividerLocation();
                }
            }
        });
    }

    public void removeNavigator(JHelpNavigator nav) {
        this.navs.removeElement(nav);
        this.tabbedPane.remove((Component)nav);
        this.help.invalidate();
    }

    public JHelpNavigator getCurrentNavigator() {
        return (JHelpNavigator)this.tabbedPane.getSelectedComponent();
    }

    public void setCurrentNavigator(JHelpNavigator nav) {
        if (nav == (JHelpNavigator)this.tabbedPane.getSelectedComponent()) {
            return;
        }
        int size = this.navs.size();
        for (int i = 0; i < size; ++i) {
            JHelpNavigator test = (JHelpNavigator)this.navs.elementAt(i);
            if (test != nav) continue;
            this.tabbedPane.setSelectedIndex(i);
            return;
        }
        throw new IllegalArgumentException("JHelpNavigator must be added first");
    }

    protected HelpModel getModel() {
        if (this.help == null) {
            return null;
        }
        return this.help.getModel();
    }

    private void rebuild() {
        HelpModel hm = this.getModel();
        if (hm == null) {
            return;
        }
        this.discardHistory();
        HelpSet hs = hm.getHelpSet();
        JHelpContentViewer contentViewer = this.help.getContentViewer();
        try {
            Map.ID id = hs.getHomeID();
            contentViewer.setCurrentID(id);
            Map map = hs.getCombinedMap();
            map.getURLFromID(id);
        }
        catch (MalformedURLException e2) {
            return;
        }
        catch (Exception ex) {
            return;
        }
    }

    private void computeHistoryButtons() {
        if (this.prevCommand != null) {
            this.prevCommand.setSensitivity(this.historyIndex > 0);
        }
        if (this.nextCommand != null) {
            this.nextCommand.setSensitivity(this.historyIndex < this.history.size() - 1);
        }
    }

    private void discardHistory() {
        this.history.setSize(0);
        this.historyIndex = -1;
        if (this.prevCommand != null) {
            this.prevCommand.setSensitivity(false);
        }
        if (this.nextCommand != null) {
            this.nextCommand.setSensitivity(false);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.help) {
            String changeName = event.getPropertyName();
            if (changeName.equals("helpModel")) {
                this.rebuild();
            } else if (changeName.equals("font")) {
                Font newFont = (Font)event.getNewValue();
                this.help.getContentViewer().setFont(newFont);
                this.help.getContentViewer().invalidate();
                Enumeration entries = this.help.getHelpNavigators();
                while (entries.hasMoreElements()) {
                    JHelpNavigator nav = (JHelpNavigator)entries.nextElement();
                    nav.setFont(newFont);
                }
            } else if (changeName.equals("navigatorDisplayed")) {
                this.tabbedPane.setVisible((Boolean)event.getNewValue());
            }
        }
    }

    public void goBack() {
        if (this.historyIndex > 0) {
            this.gotoHistoryEntry(this.historyIndex - 1);
        }
    }

    public void goForward() {
        if (this.historyIndex < this.history.size() - 1) {
            this.gotoHistoryEntry(this.historyIndex + 1);
        }
    }

    private void gotoHistoryEntry(int index) {
        HelpModel hm = this.getModel();
        if (hm == null) {
            return;
        }
        if (index < 0 || index >= this.history.size()) {
            this.discardHistory();
            return;
        }
        HelpModelEvent e = (HelpModelEvent)this.history.elementAt(index);
        this.historyIndex = index - 1;
        Map.ID id = e.getID();
        URL url = e.getURL();
        if (id != null) {
            try {
                hm.setCurrentID(id);
                return;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (url != null) {
            try {
                hm.setCurrentURL(url);
                return;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.discardHistory();
    }

    public String toString() {
        return this.getClass().getName() + "[" + version + "]";
    }

    private class IdChangeListener
    implements HelpModelListener {
        private IdChangeListener() {
        }

        public void idChanged(HelpModelEvent e) {
            if (FwkHelpUI.this.historyIndex == FwkHelpUI.this.history.size() - 1) {
                FwkHelpUI.this.history.addElement(e);
                FwkHelpUI.this.historyIndex += 1;
                FwkHelpUI.this.computeHistoryButtons();
                return;
            }
            if (FwkHelpUI.this.historyIndex >= -1 && FwkHelpUI.this.historyIndex < FwkHelpUI.this.history.size() - 1) {
                FwkHelpUI.this.historyIndex += 1;
                HelpModelEvent h = (HelpModelEvent)FwkHelpUI.this.history.elementAt(FwkHelpUI.this.historyIndex);
                if (h == null) {
                    FwkHelpUI.this.discardHistory();
                    return;
                }
                if (h.getID() != null && e.getID() != null && h.getID().equals((Object)e.getID())) {
                    FwkHelpUI.this.computeHistoryButtons();
                    return;
                }
                FwkHelpUI.this.history.setSize(FwkHelpUI.this.historyIndex);
                FwkHelpUI.this.history.addElement(e);
                FwkHelpUI.this.computeHistoryButtons();
            }
        }
    }
}

