/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.command;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class FwkAboutCommand
extends FwkCommand {
    public static final String version = "$Revision: 1.7 $";
    protected JDialog dialog;

    public String getVersion() {
        return version;
    }

    public FwkAboutCommand(FwkControllerInterface controller) {
        super(controller);
        this.setCommandName("About");
        this.setTextKey("Text.Description");
        this.setIconKey("Icon.OpenBook_red");
        this.setToolBarEnabled(false);
    }

    public boolean execute(EventObject ev) {
        Container parent = FwkGUIFactory.getDialogParent(ev);
        FwkDescriptionInterface description = null;
        FwkControllerInterface controller = this.getController();
        if (controller != null) {
            try {
                description = controller;
            }
            catch (Throwable des) {
                // empty catch block
            }
            if (parent == null) {
                try {
                    parent = (Container)((Object)controller);
                }
                catch (Throwable cp) {
                    // empty catch block
                }
            }
        }
        if (description != null) {
            this.showOptionDialog(parent, description, FwkPropertyBus.getProperty("About.Text.GUI_Title"));
        } else {
            System.err.println("FwkAboutCommand Controller description of component not found.");
        }
        return true;
    }

    protected void showOptionDialog(Component parentComponent, FwkDescriptionInterface description, String title) {
        Frame frame = JOptionPane.getFrameForComponent(parentComponent);
        this.dialog = new JDialog(frame, title, true);
        JPanel panel = new JPanel(new BorderLayout());
        this.dialog.getContentPane().add(panel);
        JTextPane textPane = this.createTextPane(description);
        textPane.setBackground(panel.getBackground());
        panel.add("Center", textPane);
        JButton ok = new JButton(FwkPropertyBus.getProperty("Text.Ok"));
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FwkAboutCommand.this.dialog.dispose();
                FwkAboutCommand.this.dialog = null;
            }
        });
        panel.add("South", ok);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parentComponent);
        this.dialog.setVisible(true);
    }

    protected JLabel getLabel(String text, int style, int size, boolean border) {
        JLabel label = new JLabel(text);
        Font f = label.getFont();
        Font font = new Font(f.getName(), style, size);
        label.setFont(font);
        Color col = label.getBackground();
        label.setHorizontalAlignment(0);
        if (border) {
            label.setBorder(BorderFactory.createBevelBorder(1, col.darker(), col.brighter()));
        }
        return label;
    }

    private JTextPane createTextPane(FwkDescriptionInterface description) {
        JTextPane textPane = new JTextPane();
        StyledDocument doc = textPane.getStyledDocument();
        this.addStylesToDocument(doc, description);
        try {
            doc.insertString(doc.getLength(), "  ", doc.getStyle("icon"));
            doc.insertString(doc.getLength(), "   " + description.getTitle() + "\n\n", doc.getStyle("bold"));
            String[] arr = description.getDescription().split("\n");
            for (int i = 0; i < arr.length; ++i) {
                doc.insertString(doc.getLength(), arr[i] + "\n", doc.getStyle("regular"));
            }
            doc.insertString(doc.getLength(), "\nName: ", doc.getStyle("bold"));
            doc.insertString(doc.getLength(), description.getName() + "\n", doc.getStyle("regular"));
            doc.insertString(doc.getLength(), "Company: ", doc.getStyle("bold"));
            doc.insertString(doc.getLength(), description.getCompany() + "\n", doc.getStyle("regular"));
            doc.insertString(doc.getLength(), "Internet: ", doc.getStyle("bold"));
            doc.insertString(doc.getLength(), description.getCompanyInternetAddress() + "\n", doc.getStyle("regular"));
            doc.insertString(doc.getLength(), "email: ", doc.getStyle("bold"));
            doc.insertString(doc.getLength(), description.getSupportEMail() + "\n", doc.getStyle("regular"));
            doc.insertString(doc.getLength(), "Copyrights: ", doc.getStyle("bold"));
            doc.insertString(doc.getLength(), description.getCopyright() + "\n", doc.getStyle("regular"));
            doc.insertString(doc.getLength(), "Creation Date: ", doc.getStyle("bold"));
            doc.insertString(doc.getLength(), description.getCreationDate() + "\n", doc.getStyle("regular"));
            doc.insertString(doc.getLength(), "Author: ", doc.getStyle("bold"));
            doc.insertString(doc.getLength(), description.getAuthor() + "\n", doc.getStyle("regular"));
            doc.insertString(doc.getLength(), "Java Version: ", doc.getStyle("bold"));
            doc.insertString(doc.getLength(), FwkContainer.getSystemProperty("java.version", "???") + "\n", doc.getStyle("regular"));
            try {
                Class<?> clazz = description.getClass();
                String resource = clazz.getName().replace('.', '/') + ".info";
                InputStreamReader ir = new InputStreamReader(clazz.getClassLoader().getResourceAsStream(resource));
                BufferedReader reader = new BufferedReader(ir);
                String line = null;
                int pos = doc.getLength();
                while ((line = reader.readLine()) != null) {
                    doc.insertString(doc.getLength(), line + "\n", doc.getStyle("addinfo"));
                }
                doc.insertString(pos, "\n\nAdditional Information:\n", doc.getStyle("bold"));
            }
            catch (Throwable t) {}
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
        textPane.setEditable(false);
        return textPane;
    }

    protected void addStylesToDocument(StyledDocument doc, FwkDescriptionInterface description) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", def);
        StyleConstants.setFontFamily(def, "SansSerif");
        StyleConstants.setFontSize(def, 16);
        Style s = doc.addStyle("italic", regular);
        StyleConstants.setItalic(s, true);
        s = doc.addStyle("bold", regular);
        StyleConstants.setBold(s, true);
        s = doc.addStyle("small", regular);
        StyleConstants.setFontSize(s, 10);
        s = doc.addStyle("large", regular);
        StyleConstants.setFontSize(s, 16);
        s = doc.addStyle("addinfo", def);
        StyleConstants.setFontFamily(s, "Monospaced");
        StyleConstants.setFontSize(s, 14);
        s = doc.addStyle("icon", regular);
        StyleConstants.setAlignment(s, 1);
        ImageIcon icon = new ImageIcon(description.getIcon().getImage());
        if (icon != null) {
            StyleConstants.setIcon(s, icon);
        }
    }
}

