/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.command;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkThread;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkTransferableInterface;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.EventObject;

public class FwkCopyToClipboardCommand
extends FwkCommand {
    public static final String version = "$Revision: 1.3 $";

    public String getVersion() {
        return version;
    }

    public FwkCopyToClipboardCommand(FwkControllerInterface controller) {
        super(controller);
        this.setTextKey("Text.Copy");
        this.setCommandName("Copy");
        this.setIconKey("Icon.Copy");
    }

    public boolean execute(EventObject ev) {
        CopyToClipboard ctc = new CopyToClipboard(this.getController());
        ctc.start();
        return true;
    }

    static class CopyToClipboard
    extends FwkThread
    implements ClipboardOwner {
        Object obj;
        StringSelection selection;

        public CopyToClipboard(Object obj) {
            this.obj = obj;
        }

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
            this.stop();
            this.selection = null;
            this.obj = null;
        }

        public void run() {
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (clipboard != null) {
                    if (this.obj != null) {
                        if (this.obj instanceof FwkTransferableInterface) {
                            FwkContainer.getClipboard().setContents((FwkTransferableInterface)this.obj, (FwkTransferableInterface)this.obj);
                        }
                        if (this.obj instanceof Transferable) {
                            try {
                                this.selection = new StringSelection((String)((Transferable)this.obj).getTransferData(DataFlavor.stringFlavor));
                                clipboard.setContents(this.selection, this);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        } else {
                            this.selection = new StringSelection(this.obj.toString());
                            clipboard.setContents(this.selection, this);
                        }
                    } else {
                        this.selection = new StringSelection("null");
                        clipboard.setContents(this.selection, this);
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

