/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.command;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkFileFilter;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.dialog.FwkFileChooserDialogPane;
import com.highqsoft.fwk.dialog.FwkFileChooserDialogPaneValue;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDOMHandlerInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import java.awt.Container;
import java.awt.Cursor;
import java.util.EventObject;
import javax.swing.JComponent;

public class FwkDumpToXMLCommand
extends FwkCommand {
    public static final String version = "$Revision: 1.4 $";

    public String getVersion() {
        return version;
    }

    public FwkDumpToXMLCommand(FwkControllerInterface controller) {
        super(controller);
        this.setTextKey("Text.Save");
        this.setIconKey("Icon.XML");
        this.setCommandName("XML");
    }

    public boolean execute(EventObject ev) {
        boolean retval = false;
        Cursor cursor = null;
        Container parent = FwkGUIFactory.getDialogParent(ev);
        FwkControllerInterface controller = this.getController();
        if (controller instanceof FwkDOMHandlerInterface) {
            int pos;
            if (parent == null) {
                Object source = ev.getSource();
                if (source instanceof JComponent) {
                    parent = ((JComponent)source).getTopLevelAncestor();
                }
                if (parent == null && controller instanceof FwkApplicationInterface) {
                    parent = (Container)((Object)((FwkApplicationInterface)controller).getPanel());
                }
            }
            FwkFileFilter filter = new FwkFileFilter();
            filter.addExtension("xml");
            filter.setDescription("XML Files");
            String xmlName = controller.getName();
            if (xmlName != null && (pos = xmlName.lastIndexOf(".")) >= 0) {
                xmlName = xmlName.substring(pos + 1);
            }
            FwkFileChooserDialogPaneValue value = new FwkFileChooserDialogPaneValue();
            value.setFileFilter(filter);
            value.setSelectedFile(xmlName + ".xml");
            FwkFileChooserDialogPane pane = new FwkFileChooserDialogPane(null, value);
            FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog(parent, xmlName + " " + FwkPropertyBus.getProperty(this.getTextKey()), "", pane);
            if (val != null) {
                if (parent != null) {
                    cursor = parent.getCursor();
                    parent.setCursor(Cursor.getPredefinedCursor(3));
                }
                boolean validate = FwkPropertyBus.getProperty("XML.Validate", false);
                String outFile = (String)val.getProperty("SelectedPath");
                ((FwkDOMHandlerInterface)((Object)controller)).writeToXML(outFile, validate);
            }
        } else {
            FwkContainer.showErrorMessage("FWK Error", this.getClass().getName(), "Controller doesn't implement the FwkDOMHandlerInterface.");
            throw new FwkException(-1073676289, "$RCSfile: FwkDumpToXMLCommand.java,v $", version, "AH 2001-03-07 16:54", "Controller doesn't implement the FwkDOMHandlerInterface.", this, null);
        }
        retval = true;
        if (cursor != null) {
            parent.setCursor(cursor);
        }
        return retval;
    }
}

