/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.command;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkFileFilter;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.dialog.FwkFileChooserDialogPane;
import com.highqsoft.fwk.dialog.FwkFileChooserDialogPaneValue;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDOMHandlerInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import java.awt.Container;
import java.awt.Cursor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FwkLoadFromXMLCommand
extends FwkCommand {
    public static final String version = "$Revision: 1.4 $";

    public String getVersion() {
        return version;
    }

    public FwkLoadFromXMLCommand(FwkControllerInterface controller) {
        super(controller);
        this.setTextKey("Text.Load");
        this.setIconKey("Icon.Open");
        this.setCommandName("Load");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(EventObject ev) {
        int pos;
        boolean retval = false;
        Cursor cursor = null;
        Container parent = FwkGUIFactory.getDialogParent(ev);
        FwkControllerInterface controller = this.getController();
        if (!(controller instanceof FwkDOMHandlerInterface)) {
            FwkContainer.showErrorMessage("FWK Error", this.getClass().getName(), "Controller doesn't implement the FwkDOMHandlerInterface.");
            throw new FwkException(-1073676289, "$RCSfile: FwkLoadFromXMLCommand.java,v $", version, "AH 2001-03-07 16:54", "Controller doesn't implement the FwkDOMHandlerInterface.", this, null);
        }
        if (parent == null) {
            Object source = ev.getSource();
            if (source instanceof JComponent) {
                parent = ((JComponent)source).getTopLevelAncestor();
            }
            if (parent == null && controller instanceof FwkApplicationInterface) {
                parent = (Container)((Object)((FwkApplicationInterface)controller).getPanel());
            }
        }
        FwkFileFilter filter = new FwkFileFilter();
        filter.addExtension("xml");
        filter.setDescription("XML Files");
        String xmlName = controller.getName();
        if (xmlName != null && (pos = xmlName.lastIndexOf(".")) >= 0) {
            xmlName = xmlName.substring(pos + 1);
        }
        FwkFileChooserDialogPaneValue value = new FwkFileChooserDialogPaneValue();
        value.setFileFilter(filter);
        value.setSelectedFile(xmlName + ".xml");
        FwkFileChooserDialogPane pane = new FwkFileChooserDialogPane(null, value);
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog(parent, xmlName + " " + FwkPropertyBus.getProperty(this.getTextKey()), "", pane);
        if (val != null) {
            if (parent != null) {
                cursor = parent.getCursor();
                parent.setCursor(Cursor.getPredefinedCursor(3));
            }
            boolean validate = FwkPropertyBus.getProperty("XML.Validate", false);
            String inFile = (String)val.getProperty("SelectedPath");
            try {
                FileInputStream is;
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                docBuilderFactory.setValidating(validate);
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                try {
                    is = new FileInputStream(new File(inFile));
                }
                catch (Throwable ioStream) {
                    throw new FwkException(-1073676289, "$RCSfile: FwkLoadFromXMLCommand.java,v $", version, "AH 2001-03-14 14:35", "Cannot open file <" + inFile + ">.", this, ioStream);
                }
                Document doc = docBuilder.parse(is);
                doc.getDocumentElement().normalize();
                Element root = doc.getDocumentElement();
                ((FwkDOMHandlerInterface)((Object)controller)).readFromDOM(doc, root);
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable junk) {}
                }
            }
            catch (SAXParseException err) {
                throw new FwkException(-1073676289, "$RCSfile: FwkLoadFromXMLCommand.java,v $", version, "AH 2000-11-17 16:35", "** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId() + "\n" + "   " + err.getMessage(), this, err);
            }
            catch (SAXException e) {
                throw new FwkException(-1073676289, "$RCSfile: FwkLoadFromXMLCommand.java,v $", version, "AH 2000-11-17 16:35", "SAX exception on file " + inFile, this, e);
            }
            catch (Throwable t) {
                throw new FwkException(-1073676289, "$RCSfile: FwkLoadFromXMLCommand.java,v $", version, "AH 2000-11-17 16:35", "XML Interpreter error on file " + inFile, this, t);
            }
        }
        retval = true;
        if (cursor != null) {
            parent.setCursor(cursor);
        }
        return retval;
    }
}

