/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.command;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkPanelInterface;
import com.highqsoft.interfaces.fwk.FwkPrintableInterface;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.EventObject;
import javax.swing.JComponent;

public class FwkPrintCommand
extends FwkCommand {
    public static final String version = "$Revision: 1.7 $";

    public String getVersion() {
        return version;
    }

    public FwkPrintCommand(FwkControllerInterface controller) {
        super(controller);
        this.setTextKey("Text.Print");
        this.setCommandName("Print");
        this.setIconKey("Icon.Printer");
    }

    public boolean execute(EventObject ev) {
        FwkControllerInterface controller = this.getController();
        Container parent = FwkGUIFactory.getDialogParent(ev);
        if (controller == null) {
            new FwkException(-1073676289, "$RCSfile: FwkPrintCommand.java,v $", version, "AH 2000-01-20 11:11", "There isn't a controller available.", this, null);
            return false;
        }
        FwkPrintableInterface printable = null;
        try {
            printable = (FwkPrintableInterface)controller;
        }
        catch (Throwable t) {
            new FwkException(-1073676289, "$RCSfile: FwkPrintCommand.java,v $", version, "AH 2000-01-20 11:05", "Controller does not implement FwkPrintableInterface", this, t);
        }
        if (printable != null) {
            PrinterJob pj = PrinterJob.getPrinterJob();
            pj.setJobName(printable.getPrintJobName());
            PageFormat pf = printable.getPageFormat(0);
            if (pf == null) {
                pf = pj.pageDialog(PrinterJob.getPrinterJob().defaultPage());
                printable.setPageFormat(pf, 0);
            }
            if (pj.printDialog()) {
                pj.setPrintable(printable.getPrintable(0), pf);
                try {
                    Cursor cursor = null;
                    Container container = null;
                    if (parent == null) {
                        FwkApplicationInterface appl;
                        FwkPanelInterface panel;
                        if (printable instanceof FwkApplicationInterface && (panel = (appl = (FwkApplicationInterface)printable).getPanel()) instanceof JComponent) {
                            JComponent component = (JComponent)((Object)panel);
                            container = component.getTopLevelAncestor();
                            if (component != null) {
                                cursor = component.getCursor();
                                container.setCursor(new Cursor(3));
                            }
                        }
                    } else {
                        cursor = parent.getCursor();
                        parent.setCursor(new Cursor(3));
                    }
                    pj.print();
                    if (cursor != null && parent != null) {
                        parent.setCursor(cursor);
                    }
                }
                catch (Throwable t) {
                    FwkContainer.showErrorMessage(parent, null, null, t);
                    throw new FwkException(-2147461538, "$RCSfile: FwkPrintCommand.java,v $", version, "AH 2000-01-19 10:16", "printer problem: job <" + pj.getJobName() + ">", printable.getPrintable(0), t);
                }
            }
        }
        return true;
    }
}

