/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.command;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkSortedArray;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.util.HQSPanel;
import com.highqsoft.fwk.util.StringFormat;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FwkSystemInfoCommand
extends FwkCommand {
    public static final String version = "$Revision: 1.7 $";
    protected JDialog dialog;

    public String getVersion() {
        return version;
    }

    public FwkSystemInfoCommand(FwkControllerInterface controller) {
        super(controller);
        this.setCommandName("SystemInfo");
        this.setTextKey("Text.SystemInfo");
        this.setIconKey("Icon.OpenBook_red");
        this.setToolBarEnabled(false);
    }

    public boolean execute(EventObject ev) {
        FwkControllerInterface controller;
        Container parent = FwkGUIFactory.getDialogParent(ev);
        if (parent == null && (controller = this.getController()) != null) {
            try {
                parent = controller instanceof FwkApplicationInterface ? (Container)((Object)((FwkApplicationInterface)controller).getPanel()) : (Container)((Object)controller);
            }
            catch (Throwable cp) {
                // empty catch block
            }
        }
        this.showOptionDialog(parent, FwkPropertyBus.getProperty("SystemInfo.Text.GUI_Title"));
        return true;
    }

    protected void showOptionDialog(Component parentComponent, String title) {
        String key;
        Frame frame = JOptionPane.getFrameForComponent(parentComponent);
        this.dialog = new JDialog(frame, title, true);
        JPanel panel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        panel.setLayout(borderLayout);
        this.dialog.getContentPane().add(panel);
        HQSPanel hqsPanel = new HQSPanel(11);
        hqsPanel.setText("System Properties");
        panel.add("North", hqsPanel);
        JTextArea textArea = new JTextArea(10, 10);
        textArea.setEditable(false);
        textArea.setBackground(panel.getBackground());
        JScrollPane scroller = new JScrollPane(textArea);
        Properties properties = System.getProperties();
        FwkSortedArray array = new FwkSortedArray();
        int maxLen = 0;
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            maxLen = Math.max(maxLen, key.length());
            array.add((Comparable)((Object)key));
        }
        String totMemLab = "total memory";
        maxLen = Math.max(maxLen, totMemLab.length());
        long totMem = Runtime.getRuntime().totalMemory();
        String freeMemLab = "free Memory";
        maxLen = Math.max(maxLen, freeMemLab.length());
        long freeMem = Runtime.getRuntime().freeMemory();
        String formatString = "%-" + maxLen + "s";
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            key = (String)array.get(i);
            String line = StringFormat.printf(formatString, key) + " : " + properties.getProperty(key) + "\n";
            textArea.append(line);
        }
        textArea.append(StringFormat.printf(formatString, totMemLab) + " : " + (double)Math.round((double)totMem / 1024.0 / 1024.0 * 1000.0) / 1000.0 + " MBytes\n");
        textArea.append(StringFormat.printf(formatString, freeMemLab) + " : " + (double)Math.round((double)freeMem / 1024.0 / 1024.0 * 1000.0) / 1000.0 + " MBytes\n");
        textArea.setCaretPosition(0);
        panel.add("Center", scroller);
        JButton ok = new JButton(FwkPropertyBus.getProperty("Text.Close"));
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FwkSystemInfoCommand.this.dialog.dispose();
                FwkSystemInfoCommand.this.dialog = null;
            }
        });
        panel.add("South", ok);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parentComponent);
        this.dialog.setVisible(true);
    }
}

