/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.dialog.FwkAuthenticationDialogPaneValue;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.util.HQSPanel;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class FwkAuthenticationDialogPane
extends FwkDialogPane
implements ComponentListener {
    public static final String version = "$Revision: 1.5 $";
    public static final String LABEL = "AuthenticationDialog.Text.Label";
    public static final String USERNAME_LABEL = "AuthenticationDialog.Text.UsernameLabel";
    public static final String PASSWORD_LABEL = "AuthenticationDialog.Text.PasswordLabel";
    public static final String DEFAULT_PREFIX = "Fwk";
    protected JTextField usernameField;
    protected JPasswordField passwordField;
    protected int textfieldSize = 20;
    protected String prefix = "Fwk";

    public String getVersion() {
        return version;
    }

    public FwkAuthenticationDialogPane() {
        this(DEFAULT_PREFIX, FwkContainer.getUserName(), (String)null);
    }

    public FwkAuthenticationDialogPane(String prefix) {
        this(prefix, FwkContainer.getUserName(), (String)null);
    }

    public FwkAuthenticationDialogPane(String prefix, FwkDialogPaneValueInterface value) {
        this(prefix, null, value);
    }

    public FwkAuthenticationDialogPane(String prefix, String title, FwkDialogPaneValueInterface value) {
        super(title);
        this.prefix = prefix != null ? prefix : DEFAULT_PREFIX;
        String username = (String)value.getProperty("Username");
        String password = (String)value.getProperty("Password");
        this.createPane(username, password);
    }

    public FwkAuthenticationDialogPane(String prefix, String username, String password) {
        this(prefix, null, username, password);
    }

    public FwkAuthenticationDialogPane(String prefix, String title, String username, String password) {
        super(title);
        this.prefix = prefix != null ? prefix : DEFAULT_PREFIX;
        this.createPane(username, password);
    }

    public void createPane(String username, String password) {
        if (password == null) {
            password = "";
        }
        if (username == null) {
            username = "";
        }
        this.setIdent(null);
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        HQSPanel hqsPanel = new HQSPanel(10);
        hqsPanel.setText(FwkPropertyBus.getProperty(this.prefix + LABEL));
        this.add((Component)hqsPanel, constraints);
        ++constraints.gridy;
        JPanel inputPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        JLabel usernameLabel = new JLabel(FwkPropertyBus.getProperty(this.prefix + USERNAME_LABEL));
        gbc.insets = new Insets(10, 5, 0, 0);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        inputPanel.add((Component)usernameLabel, gbc);
        this.usernameField = new JTextField(username, this.textfieldSize);
        gbc.insets = new Insets(10, 5, 0, 5);
        gbc.gridx = 1;
        inputPanel.add((Component)this.usernameField, gbc);
        JLabel passwordLabel = new JLabel(FwkPropertyBus.getProperty(this.prefix + PASSWORD_LABEL));
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.gridx = 0;
        ++gbc.gridy;
        inputPanel.add((Component)passwordLabel, gbc);
        this.passwordField = new JPasswordField(password, this.textfieldSize);
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.gridx = 1;
        inputPanel.add((Component)this.passwordField, gbc);
        constraints.fill = 0;
        constraints.anchor = 10;
        this.add((Component)inputPanel, constraints);
        this.addComponentListener(this);
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        return new FwkAuthenticationDialogPaneValue(this.getIdent(), this.usernameField.getText(), new String(this.passwordField.getPassword()));
    }

    public void setSelectedValue(FwkDialogPaneValueInterface value) {
        String s = (String)value.getProperty("Username");
        if (s != null) {
            this.usernameField.setText(s);
        }
        if ((s = (String)value.getProperty("Password")) != null) {
            this.passwordField.setText(s);
        }
    }

    public void componentHidden(ComponentEvent ev) {
        System.out.println("Component Hidden !!!!");
        ev.getComponent().setVisible(true);
    }

    public void componentMoved(ComponentEvent ev) {
    }

    public void componentResized(ComponentEvent ev) {
    }

    public void componentShown(ComponentEvent ev) {
    }
}

