/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.dialog.FwkColorDialogPaneValue;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FwkColorDialogPane
extends FwkDialogPane
implements ChangeListener {
    public static final String version = "$Revision: 1.3 $";
    JColorChooser jColorChooser;
    JSlider transSlider;
    JPanel sliderPanel;
    Color initialColor;
    float transparency;
    float initialTransparency;
    boolean sliderVisible;

    public String getVersion() {
        return version;
    }

    public FwkColorDialogPane() {
        this(null, null);
    }

    public FwkColorDialogPane(String title, Color color) {
        this.createPane(title, color, 0.0f, true);
    }

    public FwkColorDialogPane(String title, Color color, float transparency) {
        this.createPane(title, color, transparency, true);
    }

    protected void createPane(String t, Color color, float transparency, boolean sliderVisible) {
        this.sliderVisible = sliderVisible;
        if (t != null && t.length() != 0) {
            this.title = t;
        }
        this.ident = null;
        this.initialTransparency = transparency > 1.0f ? 1.0f : transparency;
        this.initialTransparency = this.initialTransparency < 0.0f ? 0.0f : this.initialTransparency;
        this.setLayout(new BorderLayout());
        if (color == null) {
            color = Color.white;
        }
        this.initialColor = color;
        this.jColorChooser = new JColorChooser(color);
        this.add((Component)this.jColorChooser, "Center");
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new BorderLayout());
        JLabel lab = new JLabel(FwkPropertyBus.getProperty("FwkColorDialogPane.Text.Transparency"));
        sliderPanel.add((Component)lab, "North");
        this.transSlider = new JSlider(0, 0, 100, (int)(transparency * 100.0f));
        this.transSlider.addChangeListener(this);
        this.transSlider.setPaintLabels(true);
        sliderPanel.add((Component)this.transSlider, "Center");
        this.add((Component)sliderPanel, "South");
        sliderPanel.setVisible(sliderVisible);
    }

    public void stateChanged(ChangeEvent e) {
        this.transparency = (float)((JSlider)e.getSource()).getValue() / 100.0f;
    }

    public void setInitialColor(Color color) {
        this.initialColor = color;
        this.jColorChooser.setColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public Color getInitialColor() {
        return new Color(this.initialColor.getRed(), this.initialColor.getGreen(), this.initialColor.getBlue());
    }

    public void setInitialTransparency(float trnasparency) {
        this.initialTransparency = this.transparency;
        if (this.transSlider != null) {
            this.transSlider.setValue((int)(this.transparency * 100.0f));
        }
    }

    public float getInitialTransparency() {
        return this.initialTransparency;
    }

    public void setTransparencySlider(boolean flag) {
        this.sliderVisible = flag;
        this.sliderPanel.setVisible(flag);
    }

    public boolean getTransparencySlider() {
        return this.sliderVisible;
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        return new FwkColorDialogPaneValue(this.getIdent(), this.jColorChooser.getColor(), this.transparency);
    }

    public void setSelectedValue(FwkDialogPaneValueInterface value) {
        if (this.transSlider != null) {
            try {
                Float t = (Float)value.getProperty("Transparency");
                if (t != null) {
                    this.transSlider.setValue((int)(t.floatValue() * 100.0f));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            Color c = (Color)value.getProperty("Color");
            if (c != null) {
                this.jColorChooser.setColor(c);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkColorDialogPane pane = new FwkColorDialogPane();
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog(null, "FwkInfoBusDialogPane - Test", "", pane);
        if (val != null) {
            System.out.println("FwkDialogPaneValueSupport Properties:");
            Iterator it = val.getProperties();
            if (it != null) {
                while (it.hasNext()) {
                    Object key = it.next();
                    System.out.println("Key: " + key + " / value:" + val.getProperty(key.toString()));
                }
            }
        } else {
            System.out.println("No value returned from FwkColorDialogPane.");
        }
    }
}

