/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkIconButton;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkServicesTreeModel;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.fwk.util.HQSPanel;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FwkConfigServiceDialog
extends JComponent {
    public static final String version = "$Revision: 1.8 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    protected static final String ROOT = "PLUGIN";
    protected static JFileChooser dirChooser;
    protected static JFileChooser fileChooser;
    protected JPanel panel;
    protected JComboBox files;
    protected JTree serviceTree;
    protected JPanel cardPanel;
    protected JTable fileTable;
    protected JTextArea error;
    protected JLabel spiVersion;
    protected JLabel name;
    protected JLabel iface;
    protected JTextArea serviceListDescription;
    protected JLabel serviceVersion;
    protected JLabel serviceName;
    protected JLabel serviceClassname;
    protected JLabel serviceURL;
    protected JTextArea serviceDescription;
    protected JLabel propertyName;
    protected JLabel propertyValue;
    protected JLabel propertyLocale;
    JDialog dialog;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    public FwkConfigServiceDialog() {
        this.createPanel();
    }

    public void show(Component parent) {
        this.dialog = this.createDialog(parent);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FwkConfigServiceDialog.this.setVisible(false);
            }
        });
        this.dialog.setVisible(true);
        this.dialog.dispose();
        this.dialog = null;
    }

    public void show() {
        this.show(null);
    }

    protected JDialog createDialog(Component parent) throws HeadlessException {
        FwkIconInterface icon;
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        FwkDescriptionInterface descriptor = FwkConfigServiceDialog.getDescriptor();
        String title = descriptor.getTitle();
        JDialog dialog = new JDialog(frame, title, true);
        if (parent == null && (icon = descriptor.getIcon()) != null) {
            Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, dialog);
            f.setIconImage(icon.getImage());
        }
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    protected File[] getInstallationDirectories() {
        Vector ret = new Vector();
        String[] arr = System.getProperty("java.class.path").split(File.pathSeparator);
        if (arr.length == 1) {
            ret = this.evalManifest(ret, arr[0]);
        } else {
            if (arr[0].endsWith(".jar") || arr[0].endsWith(".zip")) {
                ret = this.evalManifest(ret, arr[0]);
            }
            ret = this.evalArray(ret, "", arr);
        }
        return ret.toArray(new File[ret.size()]);
    }

    protected Vector evalManifest(Vector ret, String jarFilename) {
        if (ret == null) {
            ret = new Vector();
        }
        try {
            JarFile jarFile = new JarFile(jarFilename);
            Manifest manifest = jarFile.getManifest();
            Attributes attrs = manifest.getMainAttributes();
            String classpath = (String)attrs.get(new Attributes.Name("Class-Path"));
            File file = new File(jarFilename);
            if (classpath != null) {
                ret = this.evalArray(ret, file.getParent(), classpath.split("\\s"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    protected Vector evalArray(Vector ret, String prefix, String[] arr) {
        if (ret == null) {
            ret = new Vector<File>();
        }
        int size = arr.length;
        if (!prefix.endsWith(File.separator)) {
            prefix = prefix + File.separatorChar;
        }
        for (int i = 0; i < size; ++i) {
            arr[i] = arr[i].replace('/', File.separatorChar);
            if (arr[i].endsWith(".jar") || arr[i].endsWith(".zip")) continue;
            File file = new File(prefix + arr[i]);
            if (file.getAbsolutePath().endsWith("lib")) {
                ret.add(0, file);
                continue;
            }
            ret.add(file);
        }
        return ret;
    }

    public void createPanel() {
        this.setLayout(new BorderLayout());
        HQSPanel hqsPanel = new HQSPanel(16);
        hqsPanel.setText(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Subtitle", "Plugin Manager"));
        JPanel tmp = new JPanel();
        tmp.add(hqsPanel);
        this.add("North", tmp);
        JPanel main = new JPanel(new BorderLayout());
        this.add("Center", main);
        JPanel panel = new JPanel(new GridBagLayout());
        main.add("North", panel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        JLabel lab = new JLabel(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.InstallationDir", "Installation Directory") + ":");
        this.files = new JComboBox<File>(this.getInstallationDirectories());
        this.files.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                FwkConfigServiceDialog.this.reset();
            }
        });
        FwkIconButton browse = new FwkIconButton(FwkIconFile.getIcon("Icon.Open"));
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (dirChooser == null) {
                    dirChooser = new JFileChooser();
                    dirChooser.setCurrentDirectory((File)FwkConfigServiceDialog.this.files.getSelectedItem());
                    dirChooser.setDialogType(0);
                    dirChooser.setFileSelectionMode(1);
                    dirChooser.setMultiSelectionEnabled(false);
                }
                dirChooser.setDialogTitle(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.SelectInstallationDir", "Select Installation Directory"));
                int ret = dirChooser.showOpenDialog(FwkConfigServiceDialog.this);
                if (ret == 0) {
                    FwkConfigServiceDialog.this.files.insertItemAt(dirChooser.getSelectedFile(), 0);
                    FwkConfigServiceDialog.this.files.setSelectedIndex(0);
                    FwkConfigServiceDialog.this.reset();
                }
            }
        });
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel.add((Component)lab, gbc);
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        ++gbc.gridx;
        panel.add((Component)this.files, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel.add((Component)browse, gbc);
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.serviceTree = new JTree(new FwkServicesTreeModel(new File((File)this.files.getSelectedItem(), "services")));
        this.cardPanel = new JPanel(new CardLayout());
        this.cardPanel.add((Component)this.createRootPanel(), ROOT);
        this.cardPanel.add((Component)this.createServiceListPanel(), "servicelist");
        this.cardPanel.add((Component)this.createServicePanel(), "service");
        this.cardPanel.add((Component)this.createPropertyPanel(), "property");
        JSplitPane splitter = new JSplitPane(1, new JScrollPane(this.serviceTree), this.cardPanel);
        gbc.gridwidth = 3;
        gbc.gridheight = 10;
        main.add("Center", splitter);
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.gridx = 0;
        gbc.gridy += gbc.gridheight;
        JPanel butPanel = new JPanel(new GridBagLayout());
        GridBagConstraints butGbc = new GridBagConstraints();
        butGbc.gridx = 0;
        butGbc.gridy = 0;
        butGbc.weightx = 100.0;
        butGbc.weighty = 100.0;
        butGbc.fill = 2;
        butGbc.insets = new Insets(5, 5, 5, 5);
        JButton add = new JButton(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Add", "Add"));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (fileChooser == null) {
                    fileChooser = new JFileChooser();
                    fileChooser.setCurrentDirectory((File)FwkConfigServiceDialog.this.files.getSelectedItem());
                    fileChooser.setDialogType(0);
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.setMultiSelectionEnabled(false);
                    fileChooser.addChoosableFileFilter(new FileFilter(){

                        public boolean accept(File pathname) {
                            return pathname.isDirectory() || pathname.getName().toUpperCase().endsWith(".SPF");
                        }

                        public String getDescription() {
                            return FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.ServiceProviderFile", "(*.spf) Service Provider File");
                        }
                    });
                }
                fileChooser.setDialogTitle(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.SelectInstallationDir", "Select Installation Directory"));
                int ret = fileChooser.showOpenDialog(FwkConfigServiceDialog.this);
                if (ret == 0) {
                    FwkServicesTreeModel model = (FwkServicesTreeModel)FwkConfigServiceDialog.this.serviceTree.getModel();
                    try {
                        model.addService(new ZipFile(fileChooser.getSelectedFile()));
                        FwkConfigServiceDialog.this.serviceTree.repaint();
                        FwkConfigServiceDialog.this.error.setText(model.getErrorBuffer().toString());
                        FwkConfigServiceDialog.this.fileTable.revalidate();
                    }
                    catch (Throwable t) {
                        FwkContainer.showErrorMessage((Container)FwkConfigServiceDialog.this, FwkPropertyBus.getProperty("FwkConfigServiceDialog.Error.CannotReadFile", "Cannot read file") + ": " + fileChooser.getSelectedFile(), t.getMessage(), t);
                    }
                }
            }
        });
        butPanel.add((Component)add, butGbc);
        ++butGbc.gridx;
        JButton reset = new JButton(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Reset", "Reset"));
        reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                FwkConfigServiceDialog.this.reset();
            }
        });
        butPanel.add((Component)reset, butGbc);
        ++butGbc.gridx;
        JButton cancel = new JButton(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Cancel", "Cancel"));
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (FwkConfigServiceDialog.this.dialog != null) {
                    FwkConfigServiceDialog.this.dialog.setVisible(false);
                }
            }
        });
        butPanel.add((Component)cancel, butGbc);
        ++butGbc.gridx;
        JButton save = new JButton(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Save", "Save"));
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        FwkConfigServiceDialog.this.setCursor(new Cursor(3));
                        FwkServicesTreeModel model = (FwkServicesTreeModel)(this).FwkConfigServiceDialog.this.serviceTree.getModel();
                        try {
                            model.writeServiceListToXML((File)(this).FwkConfigServiceDialog.this.files.getSelectedItem());
                            model.copyFiles((File)(this).FwkConfigServiceDialog.this.files.getSelectedItem());
                            if ((this).FwkConfigServiceDialog.this.dialog != null) {
                                (this).FwkConfigServiceDialog.this.dialog.setVisible(false);
                            }
                            FwkConfigServiceDialog.this.setCursor(new Cursor(0));
                        }
                        catch (Throwable t) {
                            FwkConfigServiceDialog.this.setCursor(new Cursor(0));
                            FwkContainer.showErrorMessage((Container)FwkConfigServiceDialog.this, FwkPropertyBus.getProperty("FwkConfigServiceDialog.Error.CannotWriteFiles", "Cannot write XML files to") + ": " + fileChooser.getSelectedFile(), t.getMessage(), t);
                        }
                    }
                });
                t.start();
            }
        });
        butPanel.add((Component)save, butGbc);
        ++butGbc.gridx;
        main.add("South", butPanel);
        this.serviceTree.setCellRenderer(new Renderer());
        this.serviceTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                FwkServicesTreeModel model = (FwkServicesTreeModel)FwkConfigServiceDialog.this.serviceTree.getModel();
                TreeNode node = (TreeNode)e.getPath().getLastPathComponent();
                CardLayout cardLayout = (CardLayout)FwkConfigServiceDialog.this.cardPanel.getLayout();
                if (model.isRoot(node)) {
                    cardLayout.show(FwkConfigServiceDialog.this.cardPanel, FwkConfigServiceDialog.ROOT);
                } else {
                    try {
                        cardLayout.show(FwkConfigServiceDialog.this.cardPanel, model.getElement(node).getNodeName());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                FwkConfigServiceDialog.this.updateCardPanel();
            }
        });
        this.reset();
    }

    public JPanel createRootPanel() {
        JPanel ret = new JPanel(new BorderLayout());
        this.fileTable = new JTable(new FilesTableModel());
        this.fileTable.setEnabled(false);
        this.fileTable.setBackground(ret.getBackground());
        this.error = new JTextArea();
        String title = FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.ReadErrors", "Read Errors");
        this.error.setBorder(BorderFactory.createTitledBorder(title));
        JSplitPane splitter = new JSplitPane(0, new JScrollPane(this.fileTable), new JScrollPane(this.error));
        ret.add("Center", splitter);
        return ret;
    }

    public JPanel createServiceListPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        JLabel spiVersionLab = new JLabel(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.SPIVersion", "SPI Version") + ":");
        JLabel nameLab = new JLabel(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Name", "Name") + ":");
        JLabel interfaceLab = new JLabel(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Interface", "Interface") + ":");
        this.spiVersion = new JLabel();
        this.name = new JLabel();
        this.iface = new JLabel();
        this.serviceListDescription = new JTextArea();
        this.serviceListDescription.setEditable(false);
        String title = FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Description", "Description");
        this.serviceListDescription.setBorder(BorderFactory.createTitledBorder(title));
        this.serviceListDescription.setLineWrap(true);
        JPanel butPanel = new JPanel(new GridBagLayout());
        JButton delete = new JButton(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Delete", "Delete"));
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                TreePath path = FwkConfigServiceDialog.this.serviceTree.getSelectionPath();
                TreeNode node = (TreeNode)path.getLastPathComponent();
                int ret = JOptionPane.showConfirmDialog(FwkConfigServiceDialog.this.panel, FwkPropertyBus.getProperty("FwkConfigServiceDialog.Message.ReallyDelete", "Do you really want to delete that node?") + "\n" + FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Node", "Node") + ":" + node.toString(), FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Confirm", "Confirm"), 0);
                if (ret == 0) {
                    FwkServicesTreeModel model = (FwkServicesTreeModel)FwkConfigServiceDialog.this.serviceTree.getModel();
                    model.removeNode(node);
                    FwkConfigServiceDialog.this.serviceTree.setSelectionPath(path.getParentPath());
                }
            }
        });
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 0;
        g.weightx = 100.0;
        g.weighty = 1.0;
        g.fill = 2;
        g.insets = new Insets(5, 5, 5, 5);
        butPanel.add((Component)new JPanel(), g);
        ++g.gridx;
        g.weightx = 1.0;
        butPanel.add((Component)delete, g);
        ret.add((Component)spiVersionLab, gbc);
        ++gbc.gridy;
        ret.add((Component)nameLab, gbc);
        ++gbc.gridy;
        ret.add((Component)interfaceLab, gbc);
        gbc.gridy = 0;
        ++gbc.gridx;
        gbc.weightx = 100.0;
        ret.add((Component)this.spiVersion, gbc);
        ++gbc.gridy;
        ret.add((Component)this.name, gbc);
        ++gbc.gridy;
        ret.add((Component)this.iface, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 4;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        ret.add((Component)new JScrollPane(this.serviceListDescription), gbc);
        gbc.gridy += gbc.gridheight;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        ret.add((Component)butPanel, gbc);
        title = FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.ServiceList", "ServiceList");
        ret.setBorder(BorderFactory.createTitledBorder(title));
        return ret;
    }

    public JPanel createServicePanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        JLabel serviceVersionLab = new JLabel(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Version", "Version") + ":");
        JLabel nameLab = new JLabel(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Name", "Name") + ":");
        JLabel classnameLab = new JLabel(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Classname", "Classname") + ":");
        JLabel urlLab = new JLabel(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.JARFile", "JAR File") + ":");
        this.serviceVersion = new JLabel();
        this.serviceName = new JLabel();
        this.serviceClassname = new JLabel();
        this.serviceURL = new JLabel();
        this.serviceDescription = new JTextArea();
        this.serviceDescription.setEditable(false);
        String title = FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Description", "Description");
        this.serviceDescription.setBorder(BorderFactory.createTitledBorder(title));
        this.serviceDescription.setLineWrap(true);
        JPanel butPanel = new JPanel(new GridBagLayout());
        JButton delete = new JButton(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Delete", "Delete"));
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                TreePath path = FwkConfigServiceDialog.this.serviceTree.getSelectionPath();
                TreeNode node = (TreeNode)path.getLastPathComponent();
                int ret = JOptionPane.showConfirmDialog(FwkConfigServiceDialog.this.panel, FwkPropertyBus.getProperty("FwkConfigServiceDialog.Message.ReallyDelete", "Do you really want to delete that node?") + "\n" + FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Node", "Node") + ":" + node.toString(), FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Confirm", "Confirm"), 0);
                if (ret == 0) {
                    FwkServicesTreeModel model = (FwkServicesTreeModel)FwkConfigServiceDialog.this.serviceTree.getModel();
                    model.removeNode(node);
                    FwkConfigServiceDialog.this.serviceTree.setSelectionPath(path.getParentPath());
                }
            }
        });
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 0;
        g.weightx = 100.0;
        g.weighty = 1.0;
        g.fill = 2;
        g.insets = new Insets(5, 5, 5, 5);
        butPanel.add((Component)new JPanel(), g);
        ++g.gridx;
        g.weightx = 1.0;
        butPanel.add((Component)delete, g);
        gbc.weightx = 1.0;
        ret.add((Component)serviceVersionLab, gbc);
        ++gbc.gridy;
        ret.add((Component)nameLab, gbc);
        ++gbc.gridy;
        ret.add((Component)classnameLab, gbc);
        ++gbc.gridy;
        ret.add((Component)urlLab, gbc);
        gbc.gridy = 0;
        ++gbc.gridx;
        gbc.weightx = 100.0;
        ret.add((Component)this.serviceVersion, gbc);
        ++gbc.gridy;
        ret.add((Component)this.serviceName, gbc);
        ++gbc.gridy;
        ret.add((Component)this.serviceClassname, gbc);
        ++gbc.gridy;
        ret.add((Component)this.serviceURL, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 4;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        ret.add((Component)new JScrollPane(this.serviceDescription), gbc);
        gbc.gridy += gbc.gridheight;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        ret.add((Component)butPanel, gbc);
        title = FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Service", "Service");
        ret.setBorder(BorderFactory.createTitledBorder(title));
        return ret;
    }

    public JPanel createPropertyPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        JLabel propertyNameLab = new JLabel(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Name", "Name") + ":");
        JLabel propertyValueLab = new JLabel(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Value", "Value") + ":");
        JLabel propertyLocaleLab = new JLabel(FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Locale", "Locale") + ":");
        this.propertyName = new JLabel();
        this.propertyValue = new JLabel();
        this.propertyLocale = new JLabel();
        gbc.weightx = 1.0;
        ret.add((Component)propertyNameLab, gbc);
        ++gbc.gridy;
        ret.add((Component)propertyValueLab, gbc);
        ++gbc.gridy;
        ret.add((Component)propertyLocaleLab, gbc);
        ++gbc.gridy;
        gbc.gridy = 0;
        ++gbc.gridx;
        gbc.weightx = 100.0;
        ret.add((Component)this.propertyName, gbc);
        ++gbc.gridy;
        ret.add((Component)this.propertyValue, gbc);
        ++gbc.gridy;
        ret.add((Component)this.propertyLocale, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        ret.add((Component)new JPanel(), gbc);
        String title = FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Property", "Property");
        ret.setBorder(BorderFactory.createTitledBorder(title));
        return ret;
    }

    protected void reset() {
        this.serviceTree.setModel(new FwkServicesTreeModel(new File((File)this.files.getSelectedItem(), "services")));
        int count = this.serviceTree.getRowCount();
        int row = 0;
        while (row < count) {
            this.serviceTree.expandRow(row++);
            count = this.serviceTree.getRowCount();
        }
        FwkServicesTreeModel model = (FwkServicesTreeModel)this.serviceTree.getModel();
        this.fileTable.revalidate();
        this.error.setText(model.getErrorBuffer().toString());
    }

    public void updateCardPanel() {
        FwkServicesTreeModel model = (FwkServicesTreeModel)this.serviceTree.getModel();
        TreeNode node = null;
        try {
            node = (TreeNode)this.serviceTree.getSelectionPath().getLastPathComponent();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (node != null) {
            try {
                this.spiVersion.setText(model.getSPIVersion(node));
                this.name.setText(model.getNodeName(node));
                this.iface.setText(model.getInterfaceName(node));
                this.serviceListDescription.setText(model.getNodeDescription(node));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                this.serviceVersion.setText(model.getNodeVersion(node));
                this.serviceName.setText(model.getNodeName(node));
                this.serviceClassname.setText(model.getNodeClassname(node));
                this.serviceURL.setText(model.getNodeURL(node));
                this.serviceDescription.setText(model.getNodeDescription(node));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                this.propertyName.setText(model.getPropertyName(node));
                this.propertyValue.setText(model.getPropertyValue(node));
                this.propertyLocale.setText(model.getPropertyLocale(node));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkConfigServiceDialog dialog = new FwkConfigServiceDialog();
        dialog.show(null);
        System.exit(0);
    }

    static {
        FwkContainer.addComponentProperties(FwkConfigServiceDialog.class);
        descriptor.setAuthor("Hans-Joachim Bothe");
        descriptor.setBuild(version);
        descriptor.setDescription("ASAM ODS Application Model Generator");
        descriptor.setTitleName("FwkConfigServiceDialog.Text.Title");
        descriptor.setName(FwkConfigServiceDialog.class.getName());
        descriptor.setClassName(FwkConfigServiceDialog.class.getName());
        descriptor.setIconKey("Icon.Gear");
        descriptor.setCreationDate("$Date: 2007/06/12 09:10:15 $", null);
    }

    public class FilesTableModel
    extends AbstractTableModel {
        public int getRowCount() {
            FwkServicesTreeModel model = (FwkServicesTreeModel)FwkConfigServiceDialog.this.serviceTree.getModel();
            return model.getIncludedFilesCount();
        }

        public int getColumnCount() {
            return 1;
        }

        public Object getValueAt(int row, int column) {
            FwkServicesTreeModel model = (FwkServicesTreeModel)FwkConfigServiceDialog.this.serviceTree.getModel();
            return model.getIncludedItem(row);
        }

        public String getColumnName(int column) {
            return FwkPropertyBus.getProperty("FwkConfigServiceDialog.Text.Files", "Files");
        }
    }

    public class Renderer
    extends DefaultTreeCellRenderer {
        Icon icon;
        Icon icon_spf;
        Icon book;
        Icon openBook;

        public Renderer() {
            this.setLeafIcon(FwkIconFile.getIcon("Icon.blue-ball"));
            this.icon = FwkIconFile.getIcon("Icon.Gear");
            this.icon_spf = FwkIconFile.getIcon("Icon.Gear_magenta");
            this.book = FwkIconFile.getIcon("Icon.Book_red");
            this.openBook = FwkIconFile.getIcon("Icon.OpenBook_red");
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            TreeNode node = (TreeNode)value;
            FwkServicesTreeModel model = (FwkServicesTreeModel)tree.getModel();
            if (model.isRoot(node)) {
                this.setClosedIcon(this.getDefaultClosedIcon());
                this.setOpenIcon(this.getDefaultOpenIcon());
            } else if (model.isService(node)) {
                if (model.isSPFNode(node)) {
                    this.setClosedIcon(this.icon_spf);
                    this.setOpenIcon(this.icon_spf);
                } else {
                    this.setClosedIcon(this.icon);
                    this.setOpenIcon(this.icon);
                }
            } else {
                this.setClosedIcon(this.book);
                this.setOpenIcon(this.openBook);
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
    }
}

