/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkPropertyGroup;
import com.highqsoft.fwk.dialog.FwkDialog;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.fwk.util.HQSPanel;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class FwkConfirmDialog {
    public static final String version = "$Revision: 1.6 $";
    FwkPropertyGroup properties;
    boolean confirmed;
    String[] message;
    String title;
    JDialog dialog;

    public String getVersion() {
        return version;
    }

    protected FwkConfirmDialog() {
        FwkContainer.addComponentProperties(FwkDialog.class);
        this.message = null;
        this.properties = null;
        this.confirmed = true;
        this.title = null;
        this.dialog = null;
        this.setProperty("FwkConfirmDialog.Icon", "FwkHelpBroker_bg");
    }

    public FwkConfirmDialog(String title, String[] message) {
        this();
        this.message = message;
        this.title = title;
    }

    public FwkConfirmDialog(String title, String[] message, boolean confirmed) {
        this(title, message);
        this.confirmed = confirmed;
    }

    public boolean showDialog() {
        return this.showDialog(null);
    }

    public boolean showDialog(Container parent) {
        FwkIconInterface icon;
        if (this.title == null) {
            this.title = "";
        }
        this.dialog = new JDialog(JOptionPane.getFrameForComponent(parent), this.title, true);
        Container contentPane = this.dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        Frame frame = JOptionPane.getFrameForComponent(contentPane);
        if (parent == null && frame != null && (icon = FwkIconFile.getIcon(this.getProperty("FwkConfirmDialog.Icon"))) != null) {
            frame.setIconImage(icon.getImage());
        }
        this.dialog.setDefaultCloseOperation(0);
        HQSPanel hqsPanel = new HQSPanel(10);
        if (this.message != null && this.message.length != 0) {
            StringBuffer text = new StringBuffer(this.message[0]);
            int size = this.message.length;
            for (int i = 1; i < size; ++i) {
                text.append("\n").append(this.message[i]);
            }
            hqsPanel.setText(text.toString());
        }
        contentPane.add("North", hqsPanel);
        JPanel butPanel = new JPanel();
        contentPane.add("South", butPanel);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        butPanel.setLayout(gbl);
        JButton yes = new JButton(this.getProperty("FwkConfirmDialog.Text.Yes"));
        yes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                FwkConfirmDialog.this.confirmed = true;
                FwkConfirmDialog.this.dialog.setVisible(false);
            }
        });
        butPanel.add((Component)yes, gbc);
        ++gbc.gridx;
        JButton no = new JButton(this.getProperty("FwkConfirmDialog.Text.No"));
        no.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                FwkConfirmDialog.this.confirmed = false;
                FwkConfirmDialog.this.dialog.setVisible(false);
            }
        });
        butPanel.add((Component)no, gbc);
        ++gbc.gridx;
        this.dialog.pack();
        if (this.confirmed) {
            yes.requestFocus();
        } else {
            no.requestFocus();
        }
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.setVisible(true);
        return this.confirmed;
    }

    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new FwkPropertyGroup();
        }
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        String ret = null;
        if (this.properties != null) {
            ret = this.properties.getProperty(key, (String)null);
        }
        if (ret == null) {
            ret = FwkPropertyBus.getProperty(key, key);
        }
        return ret;
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkConfirmDialog confirmDialog = new FwkConfirmDialog("Junk", new String[]{"xxx"}, false);
        System.out.println(confirmDialog.showDialog());
        System.exit(0);
    }
}

