/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.application.help.FwkHelp;
import com.highqsoft.fwk.application.help.FwkHelpBroker;
import com.highqsoft.fwk.util.HQSPanel;
import com.highqsoft.fwk.util.StringFormat;
import com.highqsoft.interfaces.fwk.FwkDialogInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.fwk.FwkKeyListenerInterface;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.help.HelpSet;
import javax.help.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;

public class FwkDialog
extends JDialog
implements FwkDialogInterface {
    protected static final String HELP_PANEL = "HelpPanel";
    protected static final String WORKING_PANEL = "WorkingPanel";
    public static final String version = "$Revision: 1.9 $";
    private FwkDialogPaneValueInterface[] initialValue;
    private FwkDialogPaneValueInterface[] selectValue;
    private FwkDialogPaneInterface[] pane;
    private JButton okButton;
    private JButton cancelButton;
    private JButton resetButton;
    private JButton helpButton;
    private JButton closeButton;
    protected JPanel cardPanel;
    protected static FwkHelp fwkHelp;
    protected JPanel helpPanel;
    protected CardLayout cardLayout;
    private JTabbedPane tabbedPane;
    KeyboardListener keyboardListener;

    public String getVersion() {
        return version;
    }

    private FwkDialog() {
    }

    public FwkDialog(Component parent, String title, boolean modal, FwkDialogPaneInterface pane, ActionListener okListener, ActionListener cancelListener, ActionListener closeListener, ActionListener resetListener) {
        this(parent, title, modal, pane, okListener, cancelListener, closeListener, resetListener, -1);
    }

    public FwkDialog(Component parent, String title, boolean modal, FwkDialogPaneInterface pane, ActionListener okListener, ActionListener cancelListener, ActionListener closeListener, ActionListener resetListener, int hqsType) {
        super(JOptionPane.getFrameForComponent(parent), title, modal);
        FwkContainer.addComponentProperties(FwkDialog.class);
        this.pane = new FwkDialogPaneInterface[1];
        this.initialValue = new FwkDialogPaneValueInterface[1];
        this.selectValue = new FwkDialogPaneValueInterface[1];
        this.pane[0] = pane;
        pane.addKeyListener(this.getKeyListener());
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(gbl);
        if (hqsType >= 0) {
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 100.0;
            gbc.weighty = 1.0;
            gbc.fill = 0;
            gbc.anchor = 11;
            contentPane.add((Component)new HQSPanel(hqsType), gbc);
            ++gbc.gridy;
        } else {
            gbc.gridx = 0;
            gbc.gridy = 0;
        }
        this.cardPanel = new JPanel();
        if (pane.needsHelp()) {
            this.cardLayout = new CardLayout();
            this.cardPanel.setLayout(this.cardLayout);
            this.cardPanel.add((Component)((JComponent)((Object)pane)), WORKING_PANEL);
            this.helpPanel = this.createHelpPanel();
            this.cardPanel.add((Component)this.helpPanel, HELP_PANEL);
            this.cardLayout.show(this.cardPanel, WORKING_PANEL);
        } else {
            this.cardLayout = null;
            this.cardPanel.setLayout(new BorderLayout());
            this.cardPanel.add("Center", (JComponent)((Object)pane));
        }
        JPanel buttonPane = this.createButtons(okListener, pane.needsOk(), cancelListener, pane.needsCancel(), resetListener, pane.needsReset(), closeListener, pane.needsClose(), pane.needsHelp());
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.ipadx = 10;
        gbc.fill = 1;
        gbc.anchor = 15;
        contentPane.add((Component)this.cardPanel, gbc);
        if (buttonPane != null) {
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 100.0;
            gbc.weighty = 0.0;
            gbc.ipadx = 10;
            gbc.fill = 2;
            gbc.anchor = 15;
            contentPane.add((Component)buttonPane, gbc);
        }
        this.pack();
        this.setLocationRelativeTo(parent);
        if (this.helpButton != null) {
            pane.buttonCreated(5, this.helpButton);
        }
        JRootPane root = this.getRootPane();
        if (this.closeButton != null) {
            pane.buttonCreated(4, this.closeButton);
            root.setDefaultButton(this.closeButton);
        }
        if (this.cancelButton != null) {
            pane.buttonCreated(1, this.cancelButton);
            root.setDefaultButton(this.cancelButton);
        }
        if (this.resetButton != null) {
            pane.buttonCreated(3, this.resetButton);
            root.setDefaultButton(this.resetButton);
        }
        if (this.okButton != null) {
            pane.buttonCreated(2, this.okButton);
            root.setDefaultButton(this.okButton);
        }
        pane.dialogWillOpen(this);
    }

    public FwkDialog(Component parent, String title, boolean modal, FwkDialogPaneInterface[] pane, ActionListener okListener, ActionListener cancelListener, ActionListener resetListener, ActionListener closeListener) {
        super(JOptionPane.getFrameForComponent(parent), title, modal);
        FwkContainer.addComponentProperties(FwkDialog.class);
        this.pane = pane;
        int size = pane.length;
        this.initialValue = new FwkDialogPaneValueInterface[size];
        this.selectValue = new FwkDialogPaneValueInterface[size];
        this.tabbedPane = new JTabbedPane();
        boolean needsOk = false;
        boolean needsCancel = false;
        boolean needsReset = false;
        boolean needsClose = false;
        boolean needsHelp = false;
        for (int i = 0; i < size; ++i) {
            this.tabbedPane.addTab(pane[i].getTitle(), pane[i].getIcon(), (Component)((Object)pane[i]), pane[i].getTip());
            needsOk |= pane[i].needsOk();
            needsCancel |= pane[i].needsCancel();
            needsReset |= pane[i].needsReset();
            needsClose |= pane[i].needsClose();
            needsHelp |= pane[i].needsHelp();
        }
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(gbl);
        this.cardPanel = new JPanel();
        if (needsHelp) {
            this.cardLayout = new CardLayout();
            this.cardPanel.setLayout(this.cardLayout);
            this.cardPanel.add((Component)this.tabbedPane, WORKING_PANEL);
            this.helpPanel = this.createHelpPanel();
            this.cardPanel.add((Component)this.helpPanel, HELP_PANEL);
            this.cardLayout.show(this.cardPanel, WORKING_PANEL);
        } else {
            this.cardLayout = null;
            this.cardPanel.setLayout(new BorderLayout());
            this.cardPanel.add("Center", this.tabbedPane);
        }
        JPanel buttonPane = this.createButtons(okListener, needsOk, cancelListener, needsCancel, resetListener, needsReset, closeListener, needsClose, needsHelp);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        gbc.anchor = 15;
        contentPane.add((Component)this.cardPanel, gbc);
        if (buttonPane != null) {
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 100.0;
            gbc.weighty = 0.0;
            gbc.ipadx = 10;
            gbc.fill = 2;
            gbc.anchor = 15;
            contentPane.add((Component)buttonPane, gbc);
        }
        this.pack();
        this.setLocationRelativeTo(parent);
        for (int i = 0; i < size; ++i) {
            if (this.okButton != null) {
                pane[i].buttonCreated(2, this.okButton);
            }
            if (this.cancelButton != null) {
                pane[i].buttonCreated(1, this.cancelButton);
            }
            if (this.resetButton != null) {
                pane[i].buttonCreated(3, this.resetButton);
            }
            if (this.helpButton != null) {
                pane[i].buttonCreated(5, this.helpButton);
            }
            if (this.closeButton != null) {
                pane[i].buttonCreated(4, this.closeButton);
            }
            if (this.helpButton != null) {
                pane[i].buttonCreated(5, this.helpButton);
            }
            pane[i].dialogWillOpen(this);
        }
    }

    public void release() {
    }

    private JPanel createButtons(ActionListener okListener, boolean createOk, ActionListener cancelListener, boolean createCancel, ActionListener resetListener, boolean createReset, ActionListener closeListener, boolean createClose, boolean createHelp) {
        String okString = FwkPropertyBus.getProperty("FwkDialog.Text.Ok");
        String cancelString = FwkPropertyBus.getProperty("FwkDialog.Text.Cancel");
        String resetString = FwkPropertyBus.getProperty("FwkDialog.Text.Reset");
        String closeString = FwkPropertyBus.getProperty("FwkDialog.Text.Close");
        String helpString = FwkPropertyBus.getProperty("FwkDialog.Text.Help");
        String okMnemonic = FwkPropertyBus.getProperty("FwkDialog.Mnemonic.Ok", okString);
        String cancelMnemonic = FwkPropertyBus.getProperty("FwkDialog.Mnemonic.Cancel", cancelString);
        String closeMnemonic = FwkPropertyBus.getProperty("FwkDialog.Mnemonic.Close", closeString);
        String resetMnemonic = FwkPropertyBus.getProperty("FwkDialog.Mnemonic.Reset", resetString);
        String helpMnemonic = FwkPropertyBus.getProperty("FwkDialog.Mnemonic.Help", helpString);
        this.okButton = null;
        this.cancelButton = null;
        this.resetButton = null;
        this.helpButton = null;
        this.closeButton = null;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(gbl);
        if (createOk) {
            this.okButton = new JButton(okString);
            this.getRootPane().setDefaultButton(this.okButton);
            this.okButton.setDefaultCapable(true);
            this.okButton.setActionCommand("Ok");
            if (okMnemonic.length() == 1) {
                this.okButton.setMnemonic(okMnemonic.charAt(0));
            }
            this.okButton.addActionListener(new OkActionListener(okListener));
            this.okButton.addKeyListener(this.getKeyListener());
        }
        if (createCancel) {
            this.cancelButton = new JButton(cancelString);
            this.cancelButton.setMnemonic(cancelMnemonic.charAt(0));
            this.cancelButton.setActionCommand("Cancel");
            this.cancelButton.addActionListener(new CancelActionListener(cancelListener));
            this.cancelButton.addKeyListener(this.getKeyListener());
        }
        if (createClose) {
            this.closeButton = new JButton(closeString);
            this.closeButton.setMnemonic(closeMnemonic.charAt(0));
            this.closeButton.setActionCommand("Close");
            this.closeButton.addActionListener(new CancelActionListener(closeListener));
            this.closeButton.addKeyListener(this.getKeyListener());
        }
        if (createReset) {
            this.resetButton = new JButton(resetString);
            this.resetButton.setMnemonic(resetMnemonic.charAt(0));
            this.resetButton.setActionCommand("Reset");
            if (resetListener != null) {
                this.resetButton.addActionListener(resetListener);
            }
            this.resetButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FwkDialog.this.reset();
                }
            });
            this.resetButton.addKeyListener(this.getKeyListener());
        }
        if (createHelp) {
            this.helpButton = new JButton(helpString);
            this.helpButton.setMnemonic(helpMnemonic.charAt(0));
            this.helpButton.setActionCommand("Help");
            this.helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    JComponent p = FwkDialog.this.tabbedPane == null ? (JComponent)((Object)FwkDialog.this.pane[0]) : (JComponent)((Object)FwkDialog.this.pane[FwkDialog.this.tabbedPane.getSelectedIndex()]);
                    HelpSet helpSet = FwkContainer.getHelpSet(p);
                    if (helpSet != null) {
                        String helpID = (String)p.getClientProperty("HelpID");
                        Map.ID id = null;
                        if (helpID != null) {
                            try {
                                id = Map.ID.create((String)helpID, (HelpSet)helpSet);
                            }
                            catch (Throwable tId2) {
                                Object tId2;
                                if (FwkContainer.getDebugLevel() <= 0) {
                                    System.err.println("Help id <" + helpID + "> not found in helpset.");
                                    tId2 = null;
                                }
                                FwkContainer.showErrorMessage(FwkPropertyBus.getProperty("HelpSet.Error.Title", "HelpSet Error"), StringFormat.printf(FwkPropertyBus.getProperty("FwkHelpIDActionListener.ErrorHelpID.Text", "Cannot find HelpSet entry <%s>"), helpID), tId2);
                            }
                        }
                        if (id == null) {
                            id = helpSet.getHomeID();
                        }
                        try {
                            fwkHelp.getModel().setCurrentID(id);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    FwkDialog.this.cardLayout.show(FwkDialog.this.cardPanel, FwkDialog.HELP_PANEL);
                }
            });
            this.helpButton.addKeyListener(this.getKeyListener());
        }
        if (createClose || createCancel || createOk || createReset || createHelp) {
            int count = 0;
            gbc.insets = new Insets(5, 5, 5, 5);
            if (createHelp) {
                gbc.gridx = count++;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                gbc.weightx = 100.0;
                gbc.weighty = 100.0;
                gbc.fill = 2;
                gbc.anchor = 15;
                buttonPane.add((Component)this.helpButton, gbc);
            }
            if (createCancel) {
                gbc.gridx = count++;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                gbc.weightx = 100.0;
                gbc.weighty = 100.0;
                gbc.fill = 2;
                gbc.anchor = 15;
                buttonPane.add((Component)this.cancelButton, gbc);
            }
            if (createClose) {
                gbc.gridx = count++;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                gbc.weightx = 100.0;
                gbc.weighty = 100.0;
                gbc.fill = 2;
                gbc.anchor = 15;
                buttonPane.add((Component)this.closeButton, gbc);
            }
            if (createReset) {
                gbc.gridx = count++;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                gbc.weightx = 100.0;
                gbc.weighty = 100.0;
                gbc.fill = 2;
                gbc.anchor = 15;
                buttonPane.add((Component)this.resetButton, gbc);
            }
            if (createOk) {
                gbc.gridx = count++;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                gbc.weightx = 100.0;
                gbc.weighty = 100.0;
                gbc.fill = 2;
                gbc.anchor = 15;
                buttonPane.add((Component)this.okButton, gbc);
            }
            return buttonPane;
        }
        return null;
    }

    protected JPanel createHelpPanel() {
        JPanel ret = new JPanel();
        ret.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JButton back = new JButton(FwkPropertyBus.getProperty("FwkDialog.Text.Back"));
        back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                FwkDialog.this.cardLayout.show(FwkDialog.this.cardPanel, FwkDialog.WORKING_PANEL);
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.anchor = 15;
        buttonPanel.add((Component)back, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 100.0;
        buttonPanel.add((Component)new JPanel(), gbc);
        ret.add("South", buttonPanel);
        HelpSet helpSet = FwkHelpBroker.findHelpSet();
        if (fwkHelp == null) {
            if (helpSet != null) {
                if (fwkHelp == null) {
                    fwkHelp = new FwkHelp(helpSet);
                }
                fwkHelp.setLocale(FwkContainer.getLocale());
                ret.add("Center", (Component)((Object)fwkHelp));
            }
            if (helpSet != null) {
                try {
                    fwkHelp.getModel().setCurrentID(helpSet.getHomeID());
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    public boolean cancelDialog() {
        if (this.cancelButton != null) {
            this.cancelButton.doClick();
            return true;
        }
        return false;
    }

    public boolean resetDialog() {
        if (this.resetButton != null) {
            this.resetButton.doClick();
            return true;
        }
        return false;
    }

    public boolean commitDialog() {
        if (this.okButton != null) {
            this.okButton.doClick();
            return true;
        }
        return false;
    }

    public JComponent getDialogComponent(int ident) {
        JButton ret = null;
        switch (ident) {
            case 1: {
                ret = this.cancelButton;
                break;
            }
            case 2: {
                ret = this.okButton;
                break;
            }
            case 3: {
                ret = this.resetButton;
                break;
            }
            case 4: {
                ret = this.closeButton;
                break;
            }
            case 5: {
                ret = this.helpButton;
                break;
            }
        }
        return ret;
    }

    public FwkKeyListenerInterface getKeyListener() {
        if (this.keyboardListener == null) {
            this.keyboardListener = new KeyboardListener();
        }
        return this.keyboardListener;
    }

    public void setVisible(boolean flag) {
        if (flag) {
            int size = this.pane.length;
            for (int i = 0; i < size; ++i) {
                this.initialValue[i] = this.pane[i].getSelectedValue();
            }
        }
        super.setVisible(flag);
    }

    public void save() {
        int size = this.pane.length;
        for (int i = 0; i < size; ++i) {
            this.selectValue[i] = this.pane[i].getSelectedValue();
        }
    }

    public FwkDialogPaneValueInterface[] get() {
        return this.selectValue;
    }

    public void reset() {
        int size = this.pane.length;
        for (int i = 0; i < size; ++i) {
            this.pane[i].setSelectedValue(this.initialValue[i]);
            this.selectValue[i] = null;
        }
    }

    public class KeyboardListener
    extends KeyAdapter
    implements FwkKeyListenerInterface {
        public void keyReleased(KeyEvent e) {
            FwkDialogPaneInterface p = FwkDialog.this.tabbedPane == null ? FwkDialog.this.pane[0] : FwkDialog.this.pane[FwkDialog.this.tabbedPane.getSelectedIndex()];
            switch (e.getKeyCode()) {
                case 27: {
                    if (FwkDialog.this.cancelButton == null) break;
                    if (p != null) {
                        if (!p.isAllowedToConsume(e)) break;
                        FwkDialog.this.cancelButton.doClick();
                        break;
                    }
                    FwkDialog.this.cancelButton.doClick();
                    break;
                }
                case 10: {
                    if (FwkDialog.this.okButton == null) break;
                    if (p != null) {
                        if (!p.isAllowedToConsume(e)) break;
                        FwkDialog.this.okButton.doClick();
                        break;
                    }
                    FwkDialog.this.okButton.doClick();
                    break;
                }
            }
        }
    }

    public class CancelActionListener
    implements ActionListener {
        ActionListener cancelListener = null;

        public CancelActionListener(ActionListener cancelListener) {
            this.cancelListener = cancelListener;
        }

        public void actionPerformed(ActionEvent e) {
            int size = FwkDialog.this.pane.length;
            for (int i = 0; i < size; ++i) {
                FwkDialog.this.pane[i].dialogWillClose(FwkDialog.this);
                FwkDialog.this.pane[i].buttonCreated(2, null);
                FwkDialog.this.pane[i].buttonCreated(3, null);
                FwkDialog.this.pane[i].buttonCreated(1, null);
                FwkDialog.this.pane[i].buttonCreated(4, null);
                FwkDialog.this.pane[i].buttonCreated(5, null);
            }
            boolean stop = true;
            try {
                for (int i = 0; i < size; ++i) {
                    FwkDialog.this.pane[i].cancelPerformed(e);
                }
                if (this.cancelListener != null) {
                    this.cancelListener.actionPerformed(e);
                }
            }
            catch (Throwable t) {
                stop = false;
                new FwkException(-1073676289, "$RCSfile: FwkDialog.java,v $", FwkDialog.version, "AH 2001-09-03 11:59", "Cannot cancel dialog.", this, t);
            }
            if (stop) {
                FwkDialog.this.reset();
                FwkDialog.this.setVisible(false);
            }
        }
    }

    public class OkActionListener
    implements ActionListener {
        ActionListener okListener = null;

        public OkActionListener(ActionListener okListener) {
            this.okListener = okListener;
        }

        public void actionPerformed(ActionEvent e) {
            int size = FwkDialog.this.pane.length;
            boolean consume = true;
            int count = 0;
            while (consume && count < size) {
                consume = FwkDialog.this.pane[count++].isAllowedToConsume(e);
            }
            if (consume) {
                boolean stop = true;
                try {
                    int i;
                    FwkDialog.this.save();
                    for (i = 0; i < size; ++i) {
                        FwkDialog.this.pane[i].dialogWillClose(FwkDialog.this);
                        FwkDialog.this.pane[i].buttonCreated(2, null);
                        FwkDialog.this.pane[i].buttonCreated(5, null);
                        FwkDialog.this.pane[i].buttonCreated(4, null);
                        FwkDialog.this.pane[i].buttonCreated(1, null);
                        FwkDialog.this.pane[i].buttonCreated(3, null);
                    }
                    try {
                        for (i = 0; i < size; ++i) {
                            FwkDialog.this.pane[i].okPerformed(e);
                        }
                        if (this.okListener != null) {
                            this.okListener.actionPerformed(e);
                        }
                    }
                    catch (Throwable t) {
                        stop = false;
                        new FwkException(-1073676289, "$RCSfile: FwkDialog.java,v $", FwkDialog.version, "AH 2001-03-09 11:45", "Cannot read values from dialog panel.", this, t);
                    }
                    if (stop) {
                        FwkDialog.this.setVisible(false);
                    }
                }
                catch (Throwable t) {
                    new FwkException(-1073676289, "$RCSfile: FwkDialog.java,v $", FwkDialog.version, "AH 2000-04-28 09:49", "Cannot read values from dialog panel.", this, t);
                }
            }
        }
    }
}

