/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkFileFilter;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.dialog.FwkFileChooserDialogPaneValue;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.fwk.FwkFileFilterInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyChangeListenerInterface;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class FwkFileChooserDialogPane
extends FwkDialogPane
implements FwkPropertyChangeListenerInterface {
    public static final String version = "$Revision: 1.4 $";
    public static final String DEFAULT_PREFIX = "Fwk";
    protected String prefix = "Fwk";
    protected FwkDialogPaneValueInterface value;
    protected JFileChooser chooser;
    protected JButton newButton;

    public String getVersion() {
        return version;
    }

    public FwkFileChooserDialogPane() {
    }

    public FwkFileChooserDialogPane(String prefix, FwkDialogPaneValueInterface value) {
        this(prefix, null, value);
    }

    public FwkFileChooserDialogPane(String prefix, String title, FwkDialogPaneValueInterface value) {
        super(title);
        this.prefix = prefix != null ? prefix : DEFAULT_PREFIX;
        this.createPane(value);
    }

    protected void analizeClass(Component container, ArrayList labels, ArrayList buttons) {
        String val;
        if (container instanceof JLabel) {
            val = ((JLabel)container).getText();
            if (val != null && val.length() != 0) {
                labels.add(container);
            }
        } else if (container instanceof JButton) {
            val = ((JButton)container).getText();
            if (val != null && val.length() != 0) {
                container.getParent().setVisible(false);
            } else {
                buttons.add(container);
            }
        }
        if (container instanceof Container) {
            Component[] c = ((Container)container).getComponents();
            for (int i = 0; i < c.length; ++i) {
                this.analizeClass(c[i], labels, buttons);
            }
        }
    }

    public void createPane(FwkDialogPaneValueInterface newValue) {
        if (FwkContainer.getJavaVersionAsFloat() < 1.4f) {
            String val;
            JLabel lab;
            int i;
            this.chooser = new JFileChooser();
            this.add(this.chooser);
            String lafName = FwkPropertyBus.getProperty("LookAndFeel");
            ArrayList buttons = new ArrayList();
            ArrayList labels = new ArrayList();
            this.analizeClass(this.chooser, labels, buttons);
            if (lafName.indexOf("Mot") >= 0) {
                for (i = 0; i < labels.size(); ++i) {
                    lab = (JLabel)labels.get(i);
                    val = lab.getText();
                    if (val.startsWith("Folder")) {
                        lab.setText(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Text.Directory") + ":");
                        lab.setDisplayedMnemonic(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Mnemonic.Directory", 0));
                        continue;
                    }
                    if (val.startsWith("Filter")) {
                        lab.setText(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Text.Type") + ":");
                        lab.setDisplayedMnemonic(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Mnemonic.Type", 0));
                        continue;
                    }
                    if (val.startsWith("Files")) {
                        lab.setText(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Text.File") + ":");
                        lab.setDisplayedMnemonic(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Mnemonic.File", 0));
                        continue;
                    }
                    if (val.startsWith("Enter path")) {
                        lab.setText(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Text.Directory") + ":");
                        lab.setDisplayedMnemonic(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Mnemonic.Directory", 0));
                        continue;
                    }
                    if (!val.startsWith("Enter file")) continue;
                    lab.setText(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Text.Enter") + ":");
                    lab.setDisplayedMnemonic(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Mnemonic.Enter", 0));
                }
            } else if (lafName.indexOf("Win") >= 0) {
                for (i = 0; i < labels.size(); ++i) {
                    lab = (JLabel)labels.get(i);
                    val = lab.getText();
                    if (val.startsWith("Look")) {
                        lab.setText(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Text.Directory") + ":");
                        lab.setDisplayedMnemonic(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Mnemonic.Directory", 0));
                        continue;
                    }
                    if (val.startsWith("Files of")) {
                        lab.setText(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Text.Type") + ":");
                        lab.setDisplayedMnemonic(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Mnemonic.Type", 0));
                        continue;
                    }
                    if (!val.startsWith("File")) continue;
                    lab.setText(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Text.File") + ":");
                    lab.setDisplayedMnemonic(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Mnemonic.File", 0));
                }
            } else {
                for (i = 0; i < labels.size(); ++i) {
                    lab = (JLabel)labels.get(i);
                    val = lab.getText();
                    if (val.startsWith("Look")) {
                        lab.setText(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Text.Directory") + ":");
                        lab.setDisplayedMnemonic(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Mnemonic.Directory", 0));
                        continue;
                    }
                    if (val.startsWith("Files of")) {
                        lab.setText(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Text.Type") + ":");
                        lab.setDisplayedMnemonic(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Mnemonic.Type", 0));
                        continue;
                    }
                    if (!val.startsWith("File name")) continue;
                    lab.setText(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Text.File") + ":");
                    lab.setDisplayedMnemonic(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Mnemonic.File", 0));
                }
            }
            for (int i2 = 0; i2 < buttons.size(); ++i2) {
                JButton but = (JButton)buttons.get(i2);
                val = but.getToolTipText();
                if (val == null || val.length() == 0) continue;
                but.setToolTipText(FwkPropertyBus.getProperty(this.prefix + "FileChooserDialog.Text.ToolTip." + val.replace(' ', '_')));
            }
            this.setSelectedValue(newValue);
        } else {
            this.chooser = new JFileChooser();
            this.chooser.setControlButtonsAreShown(false);
            this.add(this.chooser);
            this.setSelectedValue(newValue);
        }
    }

    public JComponent getNextComponent(ArrayList arr, Class clazz, int count) {
        JComponent ret = null;
        int size = arr.size();
        while (count < size && ret == null) {
            Object elem;
            if (!clazz.isInstance(elem = arr.get(count++))) continue;
            ret = (JComponent)elem;
        }
        return ret;
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        this.value.setProperty("CurrentDirectory", this.chooser.getCurrentDirectory().getPath());
        this.value.setProperty("FileFilter", this.chooser.getFileFilter());
        String filename = ((BasicFileChooserUI)this.chooser.getUI()).getFileName();
        if (filename != null && filename.length() != 0) {
            this.value.setProperty("SelectedFile", filename);
        }
        if (FwkContainer.getJavaVersionAsFloat() < 1.4f) {
            // empty if block
        }
        return this.value;
    }

    public void setSelectedValue(FwkDialogPaneValueInterface newValue) {
        this.value = newValue != null ? newValue : new FwkFileChooserDialogPaneValue();
        this.setCurrentDirectory((String)this.value.getProperty("CurrentDirectory"));
        this.setFileFilter((FwkFileFilter)this.value.getProperty("FileFilter"));
        this.setNewButtonVisibility((String)this.value.getProperty("NewButtonVisibility"));
        if (FwkContainer.getJavaVersionAsFloat() < 1.4f) {
            this.setSelectedFile((String)this.value.getProperty("SelectedFile"));
        }
        this.setChoosableFileFilters((FwkFileFilterInterface[])this.value.getProperty("ChoosableFileFilters"));
        this.value.addPropertyChangeListener(this);
    }

    private void setNewButtonVisibility(String visibility) {
        if (visibility != null) {
            this.newButton.setVisible(visibility.compareTo("visible") == 0);
        }
    }

    private void setCurrentDirectory(String currentDirectory) {
        if (currentDirectory != null) {
            this.chooser.setCurrentDirectory(new File(currentDirectory));
        }
    }

    private void setFileFilter(FwkFileFilterInterface fileFilter) {
        this.chooser.setFileFilter((FileFilter)((Object)fileFilter));
    }

    protected void setChoosableFileFilters(FwkFileFilterInterface[] fileFilters) {
        int i;
        int size;
        FileFilter[] cur = this.chooser.getChoosableFileFilters();
        if (cur != null && cur.length != 0) {
            size = cur.length;
            for (i = 0; i < size; ++i) {
                this.chooser.removeChoosableFileFilter(cur[i]);
            }
        }
        if (fileFilters != null && fileFilters.length != 0) {
            size = fileFilters.length;
            for (i = 0; i < size; ++i) {
                this.chooser.addChoosableFileFilter((FileFilter)((Object)fileFilters[i]));
            }
        }
    }

    private void setSelectedFile(String selectedFile) {
        if (selectedFile != null) {
            this.chooser.setSelectedFile(new File(selectedFile));
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        Object newValue = ev.getNewValue();
        if (propertyName != null) {
            if (propertyName.compareTo("CurrentDirectory") == 0) {
                this.setCurrentDirectory((String)newValue);
            } else if (propertyName.compareTo("FileFilter") == 0) {
                this.setFileFilter((FwkFileFilter)newValue);
            } else if (propertyName.compareTo("NewButtonVisibility") == 0) {
                this.setNewButtonVisibility((String)newValue);
            } else if (propertyName.compareTo("SelectedFile") == 0) {
                this.setSelectedFile((String)newValue);
            }
        }
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkFileChooserDialogPaneValue value = new FwkFileChooserDialogPaneValue();
        FwkFileChooserDialogPane pane = new FwkFileChooserDialogPane(null, value);
        FwkFileFilter filter = new FwkFileFilter();
        filter.addExtension("xml");
        filter.setDescription("Extensible Markup Language Files");
        value.setFileFilter(filter);
        value.setSelectedFile("FwkTest.xml");
        value.setNewButtonVisibility("invisible");
        value.setCurrentDirectory("..");
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog(null, "FwkFileChooserDialogPane - Test", "", pane);
        if (val != null) {
            System.out.println("FwkFileChooserDialogPane Properties:");
            Iterator it = val.getProperties();
            if (it != null) {
                while (it.hasNext()) {
                    Object key = it.next();
                    System.out.println("   Key: " + key + " / value:" + val.getProperty(key.toString()));
                }
            }
            System.out.println("Current directory = " + val.getProperty("CurrentDirectory"));
            System.out.println("File Filter       = " + val.getProperty("FileFilter"));
            System.out.println("Selected file     = " + val.getProperty("SelectedFile"));
        } else {
            System.out.println("No value returned from FwkFileChooserDialogPane.");
        }
    }
}

