/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkFileFilter;
import com.highqsoft.fwk.dialog.FwkDialogPaneValue;
import com.highqsoft.interfaces.fwk.FwkFileFilterInterface;
import java.io.File;

public class FwkFileChooserDialogPaneValue
extends FwkDialogPaneValue {
    public static final String CURRENT_DIRECTORY = "CurrentDirectory";
    public static final String FILE_FILTER = "FileFilter";
    public static final String NEW_BUTTON_VISIBILITY = "NewButtonVisibility";
    public static final String SELECTED_FILE = "SelectedFile";
    public static final String SELECTED_PATH = "SelectedPath";
    public static final String CHOOSABLE_FILEFILTERS = "ChoosableFileFilters";
    public static final String VISIBLE = "visible";
    public static final String INVISIBLE = "invisible";
    protected String currentDirectory = null;
    protected int fileFilterIndex = -1;
    protected FwkFileFilterInterface[] choosableFileFilters = null;
    protected String selectedFile = null;
    protected String newButtonVisibility = null;

    public FwkFileChooserDialogPaneValue() {
        this.setCurrentDirectory(null);
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void addChoosableFileFilter(FwkFileFilterInterface filter) {
        if (this.choosableFileFilters == null || this.choosableFileFilters.length == 0) {
            this.choosableFileFilters = new FwkFileFilterInterface[1];
            this.choosableFileFilters[0] = filter;
            this.fileFilterIndex = this.choosableFileFilters.length - 1;
        } else {
            int size = this.choosableFileFilters.length;
            boolean found = false;
            int count = 0;
            while (!found && count < size) {
                found = this.choosableFileFilters[count++].equals(filter);
            }
            if (!found) {
                FwkFileFilterInterface[] tmp = new FwkFileFilterInterface[this.choosableFileFilters.length + 1];
                System.arraycopy(this.choosableFileFilters, 0, tmp, 0, this.choosableFileFilters.length);
                tmp[this.choosableFileFilters.length] = filter;
                this.choosableFileFilters = tmp;
                this.fileFilterIndex = this.choosableFileFilters.length - 1;
            } else {
                this.fileFilterIndex = count - 1;
            }
        }
    }

    public FwkFileFilterInterface[] getChoosableFileFilters() {
        FwkFileFilter[] ret;
        if (this.choosableFileFilters == null || this.choosableFileFilters.length == 0) {
            ret = null;
        } else {
            ret = new FwkFileFilter[this.choosableFileFilters.length];
            System.arraycopy(this.choosableFileFilters, 0, ret, 0, this.choosableFileFilters.length);
        }
        return ret;
    }

    public void setChoosableFileFilters(FwkFileFilterInterface[] newFilters) {
        if (newFilters == null || newFilters.length == 0) {
            this.choosableFileFilters = null;
            this.fileFilterIndex = -1;
        } else {
            this.choosableFileFilters = new FwkFileFilter[newFilters.length];
            System.arraycopy(newFilters, 0, this.choosableFileFilters, 0, newFilters.length);
            this.fileFilterIndex = this.choosableFileFilters.length;
        }
    }

    public FwkFileFilterInterface getFileFilter() {
        if (this.fileFilterIndex != -1) {
            return this.choosableFileFilters[this.fileFilterIndex];
        }
        return null;
    }

    public String getNewButtonVisibility() {
        return this.newButtonVisibility;
    }

    public String getSelectedPath() {
        return this.currentDirectory + File.separator + this.selectedFile;
    }

    public String getSelectedFile() {
        return this.selectedFile;
    }

    public void setNewButtonVisibility(String visibility) {
        String oldVisibility = this.newButtonVisibility;
        if (visibility != null) {
            this.newButtonVisibility = visibility;
            this.firePropertyChange(NEW_BUTTON_VISIBILITY, oldVisibility, this.newButtonVisibility);
        }
    }

    public void setCurrentDirectory(String dirName) {
        String oldDir = this.currentDirectory;
        this.currentDirectory = dirName == null || dirName.length() == 0 ? FwkContainer.getUserDirectory() : dirName;
        this.firePropertyChange(CURRENT_DIRECTORY, oldDir, this.currentDirectory);
    }

    public void setFileFilter(FwkFileFilterInterface fileFilter) {
        FwkFileFilterInterface oldFilter = this.getFileFilter();
        this.addChoosableFileFilter(fileFilter);
        this.firePropertyChange(FILE_FILTER, oldFilter, this.getFileFilter());
    }

    public void setSelectedFile(String selectedFile) {
        String oldFile = this.selectedFile;
        this.selectedFile = selectedFile;
        this.firePropertyChange(SELECTED_FILE, oldFile, selectedFile);
    }

    public void setSelectedPath(String selected) {
        File file = new File(selected).getAbsoluteFile();
        this.setCurrentDirectory(file.getAbsolutePath());
        if (file.isFile()) {
            this.setSelectedFile(file.getName());
        }
    }
}

