/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkFileFilter;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.dialog.FwkFileDialogPaneValue;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyChangeListenerInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class FwkFileDialogPane
extends FwkDialogPane
implements FwkPropertyChangeListenerInterface,
ListSelectionListener {
    public static final String version = "$Revision: 1.4 $";
    static boolean deLang;
    public static final String DEFAULT_PREFIX = "Fwk";
    protected String prefix = "Fwk";
    protected FwkFileDialogPaneValue initialValue;
    protected FwkFileDialogPaneValue currentValue;
    protected JButton newButton;
    protected TableModel tm;
    protected JTable table;
    protected JTextField textField;
    protected FileEntry[] entries;

    public String getVersion() {
        return version;
    }

    public FwkFileDialogPane() {
    }

    public FwkFileDialogPane(String prefix, FwkFileDialogPaneValue value) {
        this(prefix, null, value);
    }

    public FwkFileDialogPane(String prefix, String title, FwkFileDialogPaneValue value) {
        super(title);
        this.prefix = prefix != null ? prefix : DEFAULT_PREFIX;
        this.initialValue = value;
        this.currentValue = (FwkFileDialogPaneValue)value.clone();
        this.createPane();
    }

    public void createPane() {
        this.tm = new TableModel();
        this.table = new JTable(this.tm);
        this.table.setGridColor(this.table.getBackground());
        this.table.setDefaultRenderer(this.table.getColumnClass(0), new CellRenderer());
        this.table.setIntercellSpacing(new Dimension(7, 1));
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addMouseListener(new MouseListener());
        JScrollPane scroll = new JScrollPane(this.table);
        this.textField = new JTextField();
        this.setLayout(new BorderLayout());
        this.add("Center", scroll);
        this.add("South", this.textField);
        this.updateGUI();
    }

    protected void updateGUI() {
        if (this.currentValue != null) {
            String v;
            File dir = this.currentValue.getPathFile();
            File[] list = dir.listFiles();
            if (list != null && list.length != 0) {
                this.entries = new FileEntry[list.length];
                for (int i = list.length - 1; i >= 0; --i) {
                    this.entries[i] = new FileEntry(list[i]);
                }
                Arrays.sort(this.entries);
            } else {
                this.entries = null;
            }
            this.tm.setFiles(this.entries);
            String[] arr = this.currentValue.getFilenames();
            if (arr.length > 1) {
                StringBuffer buf = new StringBuffer();
                buf.append("\"" + arr[0] + "\"");
                int size = arr.length;
                for (int i = 1; i < size; ++i) {
                    buf.append(",\"" + arr[i] + "\"");
                }
                v = buf.toString();
            } else {
                v = arr.length > 0 ? arr[0] : "";
            }
            this.textField.setText(v);
        } else {
            this.tm.setFiles(null);
            this.textField.setText("");
        }
    }

    protected void getLabeledComponents(ArrayList compList, Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof JPanel) {
                this.getLabeledComponents(compList, ((Container)components[i]).getComponents());
                continue;
            }
            if (!(components[i] instanceof JButton) && !(components[i] instanceof JLabel) && !(components[i] instanceof JToggleButton)) continue;
            compList.add(components[i]);
        }
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        return (FwkFileDialogPaneValue)this.currentValue.clone();
    }

    public void setSelectedValue(FwkDialogPaneValueInterface newValue) {
        this.currentValue = newValue != null ? (FwkFileDialogPaneValue)((FwkFileDialogPaneValue)newValue).clone() : new FwkFileDialogPaneValue();
    }

    protected void setNewButtonVisibility(String visibility) {
    }

    protected void setCurrentDirectory(String currentDirectory) {
    }

    protected void setFileFilter(FwkFileFilter fileFilter) {
    }

    protected void setSelectedFile(String selectedFile) {
    }

    public void propertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        if (propertyName != null) {
            // empty if block
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        String v;
        int[] sel = this.table.getSelectedRows();
        int size = sel.length;
        if (size > 1) {
            StringBuffer buf = new StringBuffer();
            buf.append("\"" + this.entries[sel[0]].file.getName() + "\"");
            for (int i = 1; i < size; ++i) {
                buf.append(",\"" + this.entries[sel[i]].file.getName() + "\"");
            }
            v = buf.toString();
        } else {
            v = size > 0 ? this.entries[sel[0]].file.getName() : "";
        }
        this.textField.setText(v);
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            System.out.println("You chose to open this file: " + chooser.getSelectedFile().getName());
        }
        FwkFileDialogPaneValue value = new FwkFileDialogPaneValue();
        value.setFilenames(new String[]{"Andy.xml", "Karst.html"});
        FwkFileDialogPane pane = new FwkFileDialogPane(null, value);
        FwkFileFilter filter = new FwkFileFilter();
        filter.addExtension("xml");
        filter.setDescription("Extensible Markup Language Files");
        value.setFileFilter(filter);
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog(null, "FwkFileChooserDialogPane - Test", "", pane);
        if (val != null) {
            System.out.println("FwkFileDialogPane Properties:");
            System.out.println(val);
            Iterator it = val.getProperties();
            if (it != null) {
                while (it.hasNext()) {
                    Object key = it.next();
                    System.out.println("   Key: " + key + " / value:" + val.getProperty(key.toString()));
                }
            }
        } else {
            System.out.println("No value returned from FwkFileChooserDialogPane.");
        }
        System.exit(0);
    }

    static {
        Locale locale = FwkContainer.getLocale();
        deLang = locale.getLanguage().compareTo("de") == 0;
    }

    class FileEntry
    implements Comparable {
        File file;

        public FileEntry(File file) {
            this.file = file;
        }

        public int compareTo(Object obj) {
            File other = ((FileEntry)obj).file;
            if (this.file.isDirectory() && other.isDirectory()) {
                return this.file.compareTo(other);
            }
            if (other.isDirectory()) {
                return ("{" + this.file.getName()).compareToIgnoreCase(other.getName());
            }
            if (this.file.isDirectory()) {
                return this.file.getName().compareToIgnoreCase("{" + other.getName());
            }
            return this.file.compareTo(other);
        }
    }

    class CellRenderer
    extends JLabel
    implements TableCellRenderer {
        Calendar calendar;
        boolean de_lang;
        SimpleDateFormat formatter;
        JFileChooser fc = new JFileChooser();

        public CellRenderer() {
            this.calendar = Calendar.getInstance();
            this.formatter = deLang ? new SimpleDateFormat("dd.MM.yyyy HH:mm:ss") : new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                FileEntry entry = (FileEntry)value;
                switch (column) {
                    case 0: {
                        this.setHorizontalAlignment(2);
                        this.setIcon(this.fc.getIcon(entry.file));
                        this.setText(entry.file.getName());
                        break;
                    }
                    case 1: {
                        this.setHorizontalAlignment(4);
                        if (entry.file.isDirectory()) {
                            this.setText("");
                        } else {
                            long kb = entry.file.length() / 1024L;
                            this.setText("" + kb + " KB");
                        }
                        this.setIcon(null);
                        break;
                    }
                    case 2: {
                        this.setHorizontalAlignment(4);
                        this.setText(this.formatter.format(new Date(entry.file.lastModified())));
                        break;
                    }
                }
                if (isSelected) {
                    this.setOpaque(true);
                    this.setBackground(Color.blue.darker());
                    this.setForeground(Color.yellow);
                } else {
                    this.setOpaque(false);
                    this.setBackground(table.getBackground());
                    this.setForeground(Color.black);
                }
            }
            return this;
        }
    }

    class TableModel
    extends AbstractTableModel {
        FileEntry[] files;

        public TableModel() {
            this(null);
        }

        public TableModel(FileEntry[] list) {
            this.setFiles(list);
        }

        public void setFiles(FileEntry[] list) {
            if (list == null) {
                this.files = new FileEntry[0];
            } else {
                this.files = new FileEntry[list.length];
                System.arraycopy(list, 0, this.files, 0, list.length);
            }
            this.fireTableDataChanged();
        }

        public Object getValueAt(int row, int column) {
            return this.files[row];
        }

        public String getColumnName(int col) {
            String ret = "";
            if (deLang) {
                switch (col) {
                    case 0: {
                        ret = "Name";
                        break;
                    }
                    case 1: {
                        ret = "Gr\u00f6\u00dfe";
                        break;
                    }
                    case 2: {
                        ret = "Ge\u00e4ndert am";
                        break;
                    }
                    default: {
                        ret = "" + (65 + col);
                        break;
                    }
                }
            } else {
                switch (col) {
                    case 0: {
                        ret = "Name";
                        break;
                    }
                    case 1: {
                        ret = "Size";
                        break;
                    }
                    case 2: {
                        ret = "Modification Date";
                        break;
                    }
                    default: {
                        ret = "" + (65 + col);
                    }
                }
            }
            return ret;
        }

        public int getRowCount() {
            return this.files.length;
        }

        public int getColumnCount() {
            return 3;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }
    }

    class MouseListener
    extends MouseAdapter {
        MouseListener() {
        }

        public void mouseReleased(MouseEvent ev) {
            int[] sel;
            if (ev.getClickCount() == 1 && ev.getModifiers() == 4 && (sel = FwkFileDialogPane.this.table.getSelectedRows()).length == 1) {
                System.out.println("PopupMenu hochfahren.");
            }
        }
    }
}

