/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkFileFilter;
import com.highqsoft.fwk.dialog.FwkDialogPaneValue;
import java.io.File;
import java.util.Iterator;

public class FwkFileDialogPaneValue
extends FwkDialogPaneValue
implements Cloneable {
    public static final String version = "$Revision: 1.4 $";
    protected static final int READ_FILE = 1;
    protected static final int READ_DIRECTORY = 2;
    protected static final int CREATE_DIRECTORY = 3;
    protected static final int CREATE_FILE = 4;
    protected File dir;
    protected FwkFileFilter fileFilter = null;
    protected int operation;
    protected String[] names;

    public String getVersion() {
        return version;
    }

    public FwkFileDialogPaneValue() {
        this.setPath(null);
        this.operation = 1;
        this.names = new String[0];
    }

    public FwkFileDialogPaneValue(String ident) {
        this();
        this.setIdent(ident);
    }

    public FwkFileDialogPaneValue(File file) {
        this();
        this.dir = file != null ? (file.isDirectory() ? new File(file.getAbsolutePath()) : new File(file.getParent())) : new File(FwkContainer.getUserDirectory());
    }

    public FwkFileDialogPaneValue(String ident, File file) {
        this(file);
        this.setIdent(ident);
    }

    public boolean getCreateDirectory() {
        return this.operation == 3;
    }

    public void setCreateDirectory(boolean flag) {
        boolean old = this.getCreateDirectory();
        if (old != flag) {
            if (flag) {
                this.operation = 3;
            }
            this.firePropertyChange("CreateDirectory", old, flag);
        }
    }

    public boolean getCreateFile() {
        return this.operation == 4;
    }

    public void setCreateFile(boolean flag) {
        boolean old = this.getCreateFile();
        if (old != flag) {
            if (flag) {
                this.operation = 4;
            }
            this.firePropertyChange("CreateFile", old, flag);
        }
    }

    public boolean getReadDirectory() {
        return this.operation == 2;
    }

    public void setReadDirectory(boolean flag) {
        boolean old = this.getReadDirectory();
        if (old != flag) {
            if (flag) {
                this.operation = 2;
            }
            this.firePropertyChange("ReadDirectory", old, flag);
        }
    }

    public boolean getReadFile() {
        return this.operation == 1;
    }

    public void setReadFile(boolean flag) {
        boolean old = this.getReadFile();
        if (old != flag) {
            if (flag) {
                this.operation = 1;
            }
            this.firePropertyChange("ReadFile", old, flag);
        }
    }

    public String getPath() {
        String ret = "";
        if (this.dir != null) {
            ret = this.dir.getAbsolutePath();
        }
        return ret;
    }

    public File getPathFile() {
        return new File(this.getPath());
    }

    public String[] getFilenames() {
        String[] ret = null;
        if (this.names != null) {
            ret = new String[this.names.length];
            System.arraycopy(this.names, 0, ret, 0, this.names.length);
        } else {
            ret = new String[]{};
        }
        return ret;
    }

    public FwkFileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setPath(String dirName) {
        File tmp;
        String oldDir = this.getPath();
        this.dir = dirName != null ? ((tmp = new File(dirName)).isDirectory() ? new File(tmp.getAbsolutePath()) : new File(tmp.getParent())) : new File(FwkContainer.getUserDirectory());
        this.firePropertyChange("Path", oldDir, dirName);
    }

    public void setFileFilter(FwkFileFilter fileFilter) {
        FwkFileFilter oldFilter = this.fileFilter;
        this.fileFilter = fileFilter;
        this.firePropertyChange("FileFilter", oldFilter, fileFilter);
    }

    public void setFilename(String selectedFile) {
        String[] old = this.names;
        if (selectedFile != null) {
            this.names = new String[1];
            this.names[0] = selectedFile;
        }
        this.firePropertyChange("Filename", old, this.names);
    }

    public void setFilenames(String[] selectedFile) {
        String[] old = this.names;
        if (selectedFile != null) {
            this.names = new String[selectedFile.length];
            System.arraycopy(selectedFile, 0, this.names, 0, selectedFile.length);
        } else {
            this.names = new String[0];
        }
        this.firePropertyChange("Filename", old, this.names);
    }

    public File[] getFiles() {
        File[] ret = new File[this.names.length];
        int size = this.names.length;
        String path = this.getPath();
        for (int i = 0; i < size; ++i) {
            ret[i] = new File(path, this.names[i]);
        }
        return ret;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret = this.getCreateFile() ? ret.append("cf ") : (this.getCreateDirectory() ? ret.append("cd ") : (this.getReadDirectory() ? ret.append("rd ") : ret.append("rf ")));
        File[] files = this.getFiles();
        int size = files.length;
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                ret.append("\"" + files[i].getAbsolutePath() + "\"");
                continue;
            }
            ret.append(",\"" + files[i].getAbsolutePath() + "\"");
        }
        return ret.toString();
    }

    public Object clone() {
        FwkFileDialogPaneValue ret = new FwkFileDialogPaneValue(this.getIdent(), this.dir);
        ret.setFilenames(this.names);
        ret.fileFilter = this.fileFilter;
        ret.operation = this.operation;
        return ret;
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkFileDialogPaneValue value = new FwkFileDialogPaneValue();
        value.setFilenames(new String[]{"Andy.xml", "karst.html"});
        System.out.println(value);
        System.out.println("FwkFileDialogPane Properties:");
        Iterator it = value.getProperties();
        if (it != null) {
            while (it.hasNext()) {
                Object key = it.next();
                System.out.println("   Key: " + key + " / value:" + value.getProperty(key.toString()));
            }
        }
        System.exit(0);
    }
}

