/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkSortedArray;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.dialog.FwkFontDialogPaneValue;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FwkFontDialogPane
extends FwkDialogPane
implements ListSelectionListener,
ChangeListener,
ItemListener {
    public static final String version = "$Revision: 1.4 $";
    public static final String SELECTEDFONT_PROPERTY = "SelectedFont";
    protected JComboBox family;
    protected JComboBox sizes;
    protected JCheckBox italic;
    protected JCheckBox bold;
    protected JComponent preview;
    protected static String[] fSizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "16", "18", "20", "24", "28", "32", "36", "48", "72"};
    protected String previewString = null;
    protected boolean noUpdate = false;
    protected Font initialFont;
    protected FwkDialogPaneValueInterface selectedValue;
    protected static final Font defaultFont;
    protected static final FwkSortedArray fontList;

    public String getVersion() {
        return version;
    }

    public FwkFontDialogPane() {
        this(null, defaultFont);
    }

    public FwkFontDialogPane(String t, Font font) {
        if (t != null && t.length() != 0) {
            this.title = t;
        }
        this.selectedValue = new FwkFontDialogPaneValue();
        this.previewString = FwkPropertyBus.getProperty("FwkFontDialogPaneBrick.Text.Sample_Text");
        this.setLayout(new GridLayout(2, 1));
        JPanel tp = new JPanel();
        tp.setLayout(new FlowLayout(1));
        if (font == null) {
            font = defaultFont;
        }
        this.initialFont = new Font(font.getName(), font.getStyle(), font.getSize());
        this.selectedValue.setProperty("Font", this.initialFont);
        if (fontList != null) {
            int size = fontList.size();
            int currentIndex = 0;
            String initialFamily = this.initialFont.getFamily();
            this.family = new JComboBox();
            for (int i = 0; i < size; ++i) {
                this.family.addItem(fontList.elementAt(i));
                if (((Comparable)fontList.elementAt(i)).compareTo(initialFamily) != 0) continue;
                currentIndex = i;
            }
            this.family.getAccessibleContext().setAccessibleName("Fontfamily");
            this.family.getAccessibleContext().setAccessibleDescription("Select the font family");
            this.family.setSelectedIndex(currentIndex);
            this.family.addItemListener(this);
            tp.add(this.family);
            currentIndex = 0;
            String initialFontSize = "" + this.initialFont.getSize();
            this.sizes = new JComboBox();
            this.sizes.setEditable(true);
            size = fSizes.length;
            for (int i = 0; i < size; ++i) {
                this.sizes.addItem(fSizes[i]);
                if (fSizes[i].compareTo(initialFontSize) != 0) continue;
                currentIndex = i;
            }
            this.sizes.getAccessibleContext().setAccessibleName("Fontsize");
            this.sizes.getAccessibleContext().setAccessibleDescription("Select the font size");
            this.sizes.setSelectedIndex(currentIndex);
            this.sizes.addItemListener(this);
            tp.add(this.sizes);
            this.bold = new JCheckBox(FwkPropertyBus.getProperty("FwkFontDialogPaneBrick.Text.Bold"));
            this.bold.setSelected(this.initialFont.isBold());
            this.bold.addChangeListener(this);
            tp.add(this.bold);
            this.italic = new JCheckBox(FwkPropertyBus.getProperty("FwkFontDialogPaneBrick.Text.Italic"));
            this.italic.setSelected(this.initialFont.isItalic());
            this.italic.addChangeListener(this);
            tp.add(this.italic);
            this.preview = new JComponent(){
                int ascent;

                public void paint(Graphics g) {
                    g.setFont(this.getFont());
                    if (FwkFontDialogPane.this.previewString == null) {
                        g.drawString(this.getFont().getFontName(), 0, this.ascent);
                    } else {
                        g.drawString(FwkFontDialogPane.this.previewString, 0, this.ascent);
                    }
                }

                public Dimension getPreferredSize() {
                    Integer maxSize = new Integer(fSizes[fSizes.length - 1]);
                    this.ascent = maxSize * 3 / 4;
                    return new Dimension(maxSize, maxSize);
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.preview.setFont((Font)this.selectedValue.getProperty("Font"));
            JPanel prevP = new JPanel();
            prevP.setBorder(BorderFactory.createTitledBorder(FwkPropertyBus.getProperty("FwkFontDialogPaneBrick.Text.Sample")));
            prevP.setLayout(new GridLayout(1, 1));
            prevP.add(this.preview);
            this.add(tp);
            this.add(prevP);
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (!this.noUpdate) {
            this.recalc();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.noUpdate) {
            this.recalc();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (!this.noUpdate) {
            this.recalc();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.noUpdate) {
            this.recalc();
        }
    }

    private void recalc() {
        if (this.italic != null) {
            String s;
            Font selectedFont = (Font)this.selectedValue.getProperty("Font");
            int style = 0;
            if (this.italic.isSelected()) {
                style |= 2;
            }
            if (this.bold.isSelected()) {
                style |= 1;
            }
            Integer size = (s = (String)this.sizes.getSelectedItem()).length() == 0 ? new Integer(selectedFont.getSize()) : new Integer(s);
            s = (String)this.family.getSelectedItem();
            if (s.length() == 0) {
                s = selectedFont.getFamily();
            }
            this.setSelectedFont(s, style, size);
            this.preview.setFont((Font)this.getSelectedValue().getProperty("Font"));
            this.preview.repaint();
        }
    }

    public void setSelectedFont(String n, int sy, int sz) {
        if (this.italic != null) {
            this.noUpdate = true;
            this.italic.setSelected((sy & 2) != 0);
            this.bold.setSelected((sy & 1) != 0);
            this.family.setSelectedItem(n);
            this.sizes.setSelectedItem("" + sz);
            this.noUpdate = false;
        }
        Font oldFont = (Font)this.selectedValue.getProperty("Font");
        Font selectedFont = new Font(n, sy, sz);
        this.firePropertyChange(SELECTEDFONT_PROPERTY, oldFont, selectedFont);
        if (this.preview != null) {
            this.preview.setFont(selectedFont);
            this.preview.repaint();
        }
        this.selectedValue.setProperty("Font", selectedFont);
    }

    public void setInitialFont(Font font) {
        this.initialFont = new Font(font.getName(), font.getStyle(), font.getSize());
    }

    public void setInitialFont(String n, int sy, int sz) {
        this.setInitialFont(new Font(n, sy, sz));
    }

    public Font getInitialFont() {
        return new Font(this.initialFont.getName(), this.initialFont.getStyle(), this.initialFont.getSize());
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        FwkFontDialogPaneValue ret = new FwkFontDialogPaneValue();
        ret.setIdent(this.getIdent());
        ret.setProperty("Font", this.selectedValue.getProperty("Font"));
        return ret;
    }

    public void setSelectedValue(FwkDialogPaneValueInterface value) {
        Font f = (Font)value.getProperty("Font");
        if (f != null) {
            this.setSelectedFont(f.getName(), f.getStyle(), f.getSize());
        }
        this.setIdent((String)value.getProperty("Ident"));
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkFontDialogPane pane = new FwkFontDialogPane();
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog(null, "FwkInfoBusDialogPane - Test", "", pane);
        if (val != null) {
            System.out.println("FwkDialogPaneValueSupport Properties:");
            Iterator it = val.getProperties();
            if (it != null) {
                while (it.hasNext()) {
                    Object key = it.next();
                    System.out.println("Key: " + key + " / value:" + val.getProperty(key.toString()));
                }
            }
        } else {
            System.out.println("No value returned from FwkFontDialogPane.");
        }
    }

    static {
        fontList = new FwkSortedArray();
        String[] fontStringList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(Locale.getDefault());
        for (int i = fontStringList.length - 1; i > 0; --i) {
            fontList.add((Comparable)((Object)fontStringList[i]));
        }
        defaultFont = new Font(fontStringList[0], 1, 12);
    }
}

