/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkSortedArray;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.dialog.FwkInfoBusDialogPaneValue;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.factory.FwkInfoBusProducerFactory;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusMemberInterface;
import com.highqsoft.interfaces.fwk.FwkInstructionInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataConsumer;
import javax.infobus.InfoBusItemAvailableEvent;
import javax.infobus.InfoBusItemRevokedEvent;
import javax.infobus.InfoBusMember;
import javax.infobus.InfoBusMemberSupport;
import javax.infobus.InfoBusMembershipException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FwkInfoBusDialogPane
extends FwkDialogPane
implements InfoBusMember,
InfoBusDataConsumer {
    public static final String version = "$Revision: 1.4 $";
    JTextField ibText;
    JTextField mtText;
    JTextField fltText;
    JList list;
    String initialInfoBusName;
    String infoBusName;
    String initialMimeType;
    String mimeType;
    String initialFilter;
    String filter;
    String selectedItem;
    FwkArray selectedItemList = new FwkArray();
    FwkSortedArray dataItemList = new FwkSortedArray();
    HashMap dataItemNameList = new HashMap();
    boolean connected = false;
    static InfoBusMemberSupport infoMemberSupport = new InfoBusMemberSupport();

    public String getVersion() {
        return version;
    }

    public FwkInfoBusDialogPane() {
        this((String)null, (String)null, (String)null, (String)null);
    }

    public FwkInfoBusDialogPane(String title, String infoBusName, String mimeType, String filter) {
        this.initialize(infoBusName, mimeType, filter);
        this.createPane(title);
    }

    public FwkInfoBusDialogPane(String title, String infoBusName, DataFlavor dataFlavor, String filter) {
        if (dataFlavor == null) {
            this.initialize(infoBusName, "", filter);
        } else {
            this.initialize(infoBusName, dataFlavor.getMimeType(), filter);
        }
        this.createPane(title);
    }

    protected void initialize(String infoBusName, String mimeType, String filter) {
        this.initialInfoBusName = infoBusName == null ? FwkDataBus.BUSNAME : infoBusName;
        infoBusName = this.initialInfoBusName;
        this.initialFilter = filter == null ? "*" : filter;
        filter = this.initialFilter;
        this.initialMimeType = mimeType == null ? FwkContainer.getMimeType(FwkColumnAccessInterface.class) : mimeType;
        mimeType = this.initialMimeType;
        this.selectedItem = "";
    }

    protected void createPane(String t) {
        if (t != null && t.length() != 0) {
            this.title = t;
        }
        this.ident = null;
        this.filter = this.initialFilter;
        this.infoBusName = this.initialInfoBusName;
        this.mimeType = this.initialMimeType;
        this.setLayout(new BorderLayout());
        Box txtPanel = new Box(1);
        JPanel mtPanel = new JPanel();
        mtPanel.setBorder(BorderFactory.createTitledBorder(FwkPropertyBus.getProperty("FwkInfoBusDialogPaneBrick.Text.MimeType")));
        mtPanel.setLayout(new FlowLayout());
        this.mtText = new JTextField(this.mimeType, 50);
        ActionListener mtListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FwkInfoBusDialogPane.this.ibText.grabFocus();
            }
        };
        this.mtText.addActionListener(mtListener);
        FocusListener mtFocus = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                JTextField src = (JTextField)e.getSource();
                String newMimeType = src.getText();
                FwkInfoBusDialogPane.this.setMimeType(newMimeType);
                FwkInfoBusDialogPane.this.updateListBox();
            }
        };
        this.mtText.addFocusListener(mtFocus);
        mtPanel.add(this.mtText);
        txtPanel.add(mtPanel);
        JPanel ibPanel = new JPanel();
        ibPanel.setBorder(BorderFactory.createTitledBorder(FwkPropertyBus.getProperty("FwkInfoBusDialogPaneBrick.Text.InfoBusParameters")));
        ibPanel.setLayout(new FlowLayout());
        JLabel lab = new JLabel(FwkPropertyBus.getProperty("FwkInfoBusDialogPaneBrick.Text.InfoBusName") + ":");
        ibPanel.add(lab);
        this.ibText = new JTextField(this.infoBusName, 15);
        ActionListener ibListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FwkInfoBusDialogPane.this.fltText.grabFocus();
            }
        };
        this.ibText.addActionListener(ibListener);
        FocusListener ibFocus = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                JTextField src = (JTextField)e.getSource();
                String newName = src.getText();
                FwkInfoBusDialogPane.this.setInfoBusName(newName);
                FwkInfoBusDialogPane.this.updateListBox();
            }
        };
        this.ibText.addFocusListener(ibFocus);
        ibPanel.add(this.ibText);
        lab = new JLabel(FwkPropertyBus.getProperty("FwkInfoBusDialogPaneBrick.Text.InfoBusFilter") + ":");
        ibPanel.add(lab);
        this.fltText = new JTextField(this.filter, 15);
        ActionListener fltListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FwkInfoBusDialogPane.this.list.grabFocus();
            }
        };
        this.fltText.addActionListener(fltListener);
        FocusListener fltFocus = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                JTextField src = (JTextField)e.getSource();
                String newFilter = src.getText();
                FwkInfoBusDialogPane.this.setFilter(newFilter);
                FwkInfoBusDialogPane.this.updateListBox();
            }
        };
        this.fltText.addFocusListener(fltFocus);
        ibPanel.add(this.fltText);
        txtPanel.add(ibPanel);
        this.add("North", txtPanel);
        JPanel lstPanel = new JPanel();
        lstPanel.setBorder(BorderFactory.createTitledBorder(FwkPropertyBus.getProperty("FwkInfoBusDialogPaneBrick.Text.DataItems")));
        lstPanel.setLayout(new BorderLayout());
        this.list = new JList();
        int visible = 10;
        try {
            visible = Integer.parseInt(FwkPropertyBus.getProperty("FwkInfoBusDialogPane.List.VisibleItems"));
        }
        catch (Throwable ti) {
            ti.printStackTrace();
        }
        this.list.setVisibleRowCount(visible);
        ListSelectionListener listListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JList src = (JList)e.getSource();
                    FwkInfoBusDialogPane.this.selectedItemList.clear();
                    int[] all = src.getSelectedIndices();
                    int size = all.length;
                    for (int i = 0; i < size; ++i) {
                        FwkInfoBusDialogPane.this.selectedItemList.add(FwkInfoBusDialogPane.this.dataItemNameList.get(FwkInfoBusDialogPane.this.dataItemList.get(all[i])));
                    }
                    int index = src.getSelectedIndex();
                    if (index >= 0) {
                        FwkInfoBusDialogPane.this.selectedItem = (String)FwkInfoBusDialogPane.this.dataItemNameList.get(FwkInfoBusDialogPane.this.dataItemList.get(index));
                    }
                }
            }
        };
        this.list.addListSelectionListener(listListener);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && e.getModifiers() == 4) {
                    JList srcList = (JList)e.getSource();
                    int index = srcList.locationToIndex(e.getPoint());
                    srcList.setSelectedIndex(index);
                    InfoBus ib = FwkInfoBusDialogPane.this.getInfoBus();
                    try {
                        JPopupMenu popup;
                        FwkInstructionInterface obj = (FwkInstructionInterface)ib.findDataItem((String)srcList.getSelectedValue(), new DataFlavor[]{new DataFlavor(FwkInfoBusDialogPane.this.mimeType)}, (InfoBusDataConsumer)FwkInfoBusDialogPane.this);
                        if (obj != null && (popup = FwkGUIFactory.createPopupMenu(obj.getCommands())) != null) {
                            popup.show((Component)e.getSource(), e.getX(), e.getY());
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                } else if (e.getClickCount() == 2 && e.getModifiers() == 16 && FwkInfoBusDialogPane.this.fwkDialog != null) {
                    FwkInfoBusDialogPane.this.fwkDialog.commitDialog();
                }
            }
        };
        this.list.addMouseListener(mouseListener);
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setPreferredSize(new Dimension(100, 20 * visible));
        lstPanel.add("Center", scrollPane);
        JButton but = new JButton(FwkPropertyBus.getProperty("FwkInfoBusDialogPane.Text.Delete"));
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DataFlavor[] fl = new DataFlavor[1];
                try {
                    fl[0] = new DataFlavor(FwkInfoBusDialogPane.this.mimeType);
                    int size = FwkInfoBusDialogPane.this.selectedItemList.size();
                    String[] vals = new String[size];
                    vals = FwkInfoBusDialogPane.this.selectedItemList.toArray(vals);
                    FwkInfoBusProducerFactory.getInstance().revokeFromAll(vals, fl);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        lstPanel.add("South", but);
        this.add("Center", lstPanel);
        this.setInfoBusName(this.infoBusName);
        this.updateListBox();
    }

    protected void updateListBox() {
        Object[] objs;
        if (this.dataItemNameList == null) {
            this.dataItemList = new FwkSortedArray();
            this.dataItemNameList = new HashMap();
        } else {
            this.dataItemList.clear();
            this.dataItemNameList.clear();
        }
        InfoBus ib = this.getInfoBus();
        DataFlavor[] flavor = new DataFlavor[1];
        try {
            flavor[0] = new DataFlavor(this.mimeType);
        }
        catch (Throwable throwable) {
            flavor[0] = null;
        }
        this.list.setListData(new String[]{""});
        if (ib != null && flavor[0] != null && (objs = ib.findMultipleDataItems(this.filter, flavor, (InfoBusDataConsumer)this)) != null) {
            int length = objs.length;
            for (int i = 0; i < length; ++i) {
                this.addItem(objs[i]);
            }
            if (this.dataItemList.size() != 0) {
                this.list.setListData(this.dataItemList.toArray());
                this.list.setVisibleRowCount(this.dataItemList.size());
                this.list.repaint();
                if (this.selectedItem != null && this.selectedItem.length() != 0) {
                    Iterator it = this.dataItemNameList.keySet().iterator();
                    boolean found = false;
                    while (!found && it.hasNext()) {
                        String value = (String)this.dataItemNameList.get(it.next());
                        int index = this.dataItemList.find((Comparable)((Object)value));
                        if (index == -1) continue;
                        this.list.setSelectedIndex(index);
                        found = true;
                    }
                }
            }
        }
    }

    protected void addItem(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Object[]) {
            Object[] arr = (Object[])obj;
            for (int i = arr.length - 1; i >= 0; --i) {
                this.addItem(arr[i]);
            }
            return;
        }
        String textValue = null;
        String itemName = null;
        if (obj instanceof FwkColumnAccessInterface) {
            textValue = ((FwkColumnAccessInterface)obj).getShortName();
            itemName = ((FwkColumnAccessInterface)obj).getName();
        } else if (obj instanceof FwkDescriptionInterface) {
            textValue = ((FwkDescriptionInterface)obj).getName();
        } else {
            Method method = null;
            try {
                method = obj.getClass().getMethod("getName", null);
            }
            catch (Throwable t1) {
                // empty catch block
            }
            if (method != null) {
                try {
                    textValue = (String)method.invoke(obj, null);
                }
                catch (Throwable t3) {}
            } else {
                try {
                    method = obj.getClass().getMethod("getProperty", null);
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                if (method != null) {
                    Object[] param = new Object[]{"Name"};
                    try {
                        textValue = (String)method.invoke(obj, param);
                    }
                    catch (Throwable t4) {
                        // empty catch block
                    }
                }
            }
        }
        if (textValue == null) {
            textValue = obj.toString();
        }
        if (itemName == null) {
            itemName = textValue;
        }
        this.dataItemNameList.put(textValue, itemName);
        this.dataItemList.add((Comparable)((Object)textValue));
    }

    public void setInfoBusName(String infoBusName) {
        if (this.isConnected()) {
            if (this.infoBusName.compareTo(infoBusName) != 0) {
                try {
                    try {
                        this.leaveInfoBus();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.joinInfoBus(infoBusName);
                    InfoBus ib = this.getInfoBus();
                    ib.addDataConsumer((InfoBusDataConsumer)this);
                    this.ibText.setText(infoBusName);
                    this.infoBusName = infoBusName;
                    this.setConnected(true);
                }
                catch (Exception e) {
                    this.setConnected(false);
                    JOptionPane.showMessageDialog(this, e.getMessage(), FwkPropertyBus.getProperty("FwkInfoBusDialogPaneBrick.Text.Message_Title"), 2);
                }
            }
        } else {
            try {
                this.joinInfoBus(infoBusName);
                this.infoBusName = infoBusName;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), FwkPropertyBus.getProperty("FwkInfoBusDialogPaneBrick.Text.Message_Title"), 2);
            }
            try {
                InfoBus ib = this.getInfoBus();
                ib.addDataConsumer((InfoBusDataConsumer)this);
                this.infoBusName = infoBusName;
                this.setConnected(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), FwkPropertyBus.getProperty("FwkInfoBusDialogPaneBrick.Text.Message_Title"), 2);
            }
        }
    }

    public void setMimeTypeEditable(boolean flag) {
        this.mtText.setEditable(flag);
        if (flag) {
            JTextField junk = new JTextField();
            this.mtText.setBackground(junk.getBackground());
        } else {
            JLabel junk = new JLabel();
            this.mtText.setBackground(junk.getBackground());
        }
    }

    public void setInfoBusNameEditable(boolean flag) {
        this.ibText.setEditable(flag);
        if (flag) {
            JTextField junk = new JTextField();
            this.ibText.setBackground(junk.getBackground());
        } else {
            JLabel junk = new JLabel();
            this.ibText.setBackground(junk.getBackground());
        }
    }

    public String getInfoBusName() {
        return this.infoBusName;
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    public void dataItemAvailable(InfoBusItemAvailableEvent e) {
        DataFlavor[] eDataFlavor = e.getDataFlavors();
        int i = 0;
        boolean added = false;
        int size = eDataFlavor.length;
        while (i < size && !added) {
            InfoBus ib;
            if (!(added = this.mimeType.compareTo(eDataFlavor[i++].getMimeType()) == 0) || (ib = this.getInfoBus()) == null) continue;
            Object obj = ib.findDataItem(e.getDataItemName(), eDataFlavor, (InfoBusDataConsumer)this);
            this.addItem(obj);
            this.list.setListData(this.dataItemList.toArray());
            this.list.setVisibleRowCount(this.dataItemList.size());
            this.list.repaint();
            if (this.selectedItem == null || this.selectedItem.length() == 0) continue;
            Iterator it = this.dataItemNameList.keySet().iterator();
            boolean found = false;
            while (!found && it.hasNext()) {
                String value = (String)this.dataItemNameList.get(it.next());
                int index = this.dataItemList.find((Comparable)((Object)value));
                if (index == -1) continue;
                this.list.setSelectedIndex(index);
                found = true;
            }
        }
    }

    public void dataItemRevoked(InfoBusItemRevokedEvent e) {
        boolean found = false;
        String value = null;
        int index = -1;
        Iterator it = this.dataItemNameList.keySet().iterator();
        while (!found && it.hasNext()) {
            value = (String)this.dataItemNameList.get(it.next());
            index = this.dataItemList.find((Comparable)((Object)value));
            if (index == -1) continue;
            found = true;
        }
        if (index >= 0 && found) {
            this.dataItemNameList.remove(this.dataItemList.get(index));
            this.dataItemList.remove(index);
        }
        if (this.list != null) {
            this.list.setListData(this.dataItemList.toArray());
            this.list.setVisibleRowCount(this.dataItemList.size());
            this.list.repaint();
        }
    }

    public void setInfoBus(InfoBus newInfoBus) throws PropertyVetoException {
        infoMemberSupport.setInfoBus(newInfoBus);
    }

    public InfoBus getInfoBus() {
        return infoMemberSupport.getInfoBus();
    }

    public void joinInfoBus(String busName) throws InfoBusMembershipException, PropertyVetoException {
        Object[] dataItem;
        try {
            infoMemberSupport.joinInfoBus(busName);
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.infoBusName = busName;
        InfoBus ib = this.getInfoBus();
        if (ib != null && (dataItem = ib.findMultipleDataItems("*", FwkContainer.getDataFlavor(FwkInfoBusMemberInterface.class), (InfoBusDataConsumer)this)) != null) {
            FwkSortedArray items = new FwkSortedArray('d');
            for (int i = dataItem.length - 1; i >= 0; --i) {
                FwkArrayInterface list = FwkContainer.getMimeTypes(dataItem[i].getClass());
                if (list == null || list.size() == 0) continue;
                for (int j = list.size() - 1; j >= 0; --j) {
                    items.add(list.get(j));
                }
            }
        }
    }

    public void joinInfoBus(Component component) throws InfoBusMembershipException, PropertyVetoException {
        infoMemberSupport.joinInfoBus(component);
    }

    public void leaveInfoBus() throws InfoBusMembershipException, PropertyVetoException {
        infoMemberSupport.leaveInfoBus();
    }

    public void addInfoBusVetoableListener(VetoableChangeListener vcl) {
        infoMemberSupport.addInfoBusVetoableListener(vcl);
    }

    public void removeInfoBusVetoableListener(VetoableChangeListener vcl) {
        infoMemberSupport.removeInfoBusVetoableListener(vcl);
    }

    public void addInfoBusPropertyListener(PropertyChangeListener pcl) {
        infoMemberSupport.addInfoBusPropertyListener(pcl);
    }

    public void removeInfoBusPropertyListener(PropertyChangeListener pcl) {
        infoMemberSupport.removeInfoBusPropertyListener(pcl);
    }

    protected void setConnected(boolean flag) {
        this.connected = flag;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setInitialInfoBusName(String infoBusName) {
        this.initialInfoBusName = infoBusName;
        this.setInfoBusName(this.initialInfoBusName);
    }

    public String getInitialInfoBusName() {
        return this.initialInfoBusName;
    }

    public void setInitialMimeType(String mimeType) {
        this.initialMimeType = mimeType;
        this.mimeType = mimeType;
        this.mtText.setText(mimeType);
    }

    public String getInitialMimeType() {
        return this.initialMimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
        this.mtText.setText(mimeType);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setInitialFilter(String filter) {
        this.initialFilter = filter;
        this.filter = filter;
        this.fltText.setText(filter);
    }

    public String getInitialFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.fltText.setText(filter);
    }

    public String getFilter() {
        return this.filter;
    }

    public void setSelectionMode(int mode) {
        this.list.setSelectionMode(mode);
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        FwkInfoBusDialogPaneValue ipv = new FwkInfoBusDialogPaneValue(this.getIdent(), this.selectedItem + "@" + this.infoBusName, this.mimeType);
        ipv.setProperty("Filter", this.filter);
        ipv.setProperty("MimeType", this.mimeType);
        String[] list = new String[this.selectedItemList.size()];
        ipv.setProperty("ItemList", this.selectedItemList.toArray(list));
        return ipv;
    }

    public void setSelectedValue(FwkDialogPaneValueInterface value) {
        String s = (String)value.getProperty("InfoBusName");
        if (s != null && s.length() != 0) {
            this.setInfoBusName(s);
        }
        if ((s = (String)value.getProperty("MimeType")) != null && s.length() != 0) {
            this.setMimeType(s);
        }
        if ((s = (String)value.getProperty("Filter")) != null && s.length() != 0) {
            this.setFilter(s);
        }
        if ((s = (String)value.getProperty("ItemName")) != null && s.length() != 0) {
            this.selectedItem = s;
        }
        this.updateListBox();
    }

    public boolean needsReset() {
        return false;
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkInfoBusDialogPane pane = new FwkInfoBusDialogPane();
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog(null, "FwkInfoBusDialogPane - Test", "", pane);
        if (val != null) {
            System.out.println("FwkDialogPaneValueSupport Properties:");
            Iterator it = val.getProperties();
            if (it != null) {
                while (it.hasNext()) {
                    Object key = it.next();
                    System.out.println("Key: " + key + " / value:" + val.getProperty(key.toString()));
                }
            }
        } else {
            System.out.println("No value returned from FwkInfoBusDialogPane.");
        }
    }
}

