/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.dialog.FwkListDialogPaneValue;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FwkListDialogPane
extends FwkDialogPane {
    public static final String version = "$Revision: 1.3 $";
    public static final String LABEL = "ListDialog.Text.Label";
    public static final String DEFAULT_PREFIX = "Fwk";
    protected JPanel jLabelPanel;
    protected JList jList;
    protected String prefix = "Fwk";
    protected FwkDialogPaneValueInterface value;

    public String getVersion() {
        return version;
    }

    public FwkListDialogPane() {
        this(DEFAULT_PREFIX);
    }

    public FwkListDialogPane(String prefix) {
        this(prefix, null);
    }

    public FwkListDialogPane(String prefix, FwkDialogPaneValueInterface value) {
        this(prefix, null, value);
    }

    public FwkListDialogPane(String prefix, String title, FwkDialogPaneValueInterface value) {
        super(title);
        this.prefix = prefix != null ? prefix : DEFAULT_PREFIX;
        this.createPane(value);
    }

    public void createPane(FwkDialogPaneValueInterface value) {
        Integer selectedIndex;
        this.setLayout(new BorderLayout());
        this.jLabelPanel = new JPanel();
        this.add((Component)this.jLabelPanel, "North");
        this.jList = new JList();
        this.jList.setSelectionMode(0);
        JScrollPane scroll = new JScrollPane(this.jList);
        this.add((Component)scroll, "Center");
        this.setSelectedValue(value);
        if (value != null && (selectedIndex = ((FwkListDialogPaneValue)value).getSelectedIndex()) != null) {
            this.jList.setSelectedIndex(selectedIndex);
        }
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        int selectedIndex = this.jList.getSelectedIndex();
        if (selectedIndex >= 0) {
            ((FwkListDialogPaneValue)this.value).setSelectedIndex(new Integer(selectedIndex));
        }
        return this.value;
    }

    public void setSelectedValue(FwkDialogPaneValueInterface value) {
        this.value = value;
        if (this.jList != null && value != null) {
            Object rowCount;
            Object index = value.getProperty("SelectedIndex");
            if (index != null && index instanceof Integer) {
                int selectedIndex = (Integer)index;
                this.jList.setSelectedIndex(selectedIndex);
                this.jList.ensureIndexIsVisible(selectedIndex);
            } else {
                Object name = value.getProperty("SelectedName");
                if (name != null && name instanceof String) {
                    String selectedName = (String)name;
                    this.jList.setSelectedValue(selectedName, true);
                }
            }
            Object list = value.getProperty("SelectList");
            if (list != null && list instanceof String[]) {
                this.jList.setListData((String[])list);
            }
            if ((rowCount = value.getProperty("VisibleRowCount")) != null && rowCount instanceof Integer) {
                this.jList.setVisibleRowCount((Integer)rowCount);
            }
            String labelName = null;
            Object label = value.getProperty("LabelName");
            if (label != null && label instanceof String) {
                labelName = (String)label;
            }
            if (labelName == null) {
                labelName = this.prefix + LABEL;
            }
            this.jLabelPanel.removeAll();
            String labelText = FwkPropertyBus.getProperty(labelName);
            if (labelText.compareTo("FwkListDialog.Text.Label") != 0 && labelText.length() > 0) {
                StringTokenizer st = new StringTokenizer(labelText, "\n");
                while (st.hasMoreTokens()) {
                    this.jLabelPanel.add(new JLabel(st.nextToken()));
                }
            }
        }
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkListDialogPane pane = new FwkListDialogPane(DEFAULT_PREFIX);
        String[] selectList = new String[]{"Hamburg", "Frankfurt", "M\u00fcnchen", "Hannover", "Stuttgart", "N\u00fcrnberg", "Berlin", "K\u00f6ln", "Aachen", "D\u00fcsseldorf"};
        Integer selectedIndex = new Integer(8);
        FwkListDialogPaneValue val = new FwkListDialogPaneValue(null);
        val.setSelectList(selectList);
        val.setSelectedIndex(selectedIndex);
        val.setVisibleRowCount(new Integer(4));
        pane.setSelectedValue(val);
        val = (FwkListDialogPaneValue)FwkDialogFactory.showDialog(null, "FwkListDialogPane - Test", "", pane);
        if (val != null) {
            System.out.println("FwkListDialogPane.main, properties:");
            Iterator it = val.getProperties();
            if (it != null) {
                while (it.hasNext()) {
                    Object key = it.next();
                    System.out.println("   Key: " + key + " / value:" + val.getProperty(key.toString()));
                }
            }
        } else {
            System.out.println("No value returned from FwkTextDialogPane.");
        }
    }
}

