/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.dialog.FwkListDialogPane;
import com.highqsoft.fwk.dialog.FwkListDialogPaneValue;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyChangeListenerInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyEditorDialogPaneValueInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FwkPropertyEditorDialogPane
extends FwkDialogPane
implements ActionListener,
KeyListener,
FwkPropertyChangeListenerInterface {
    public static final String version = "$Revision: 1.5 $";
    public static final String LABEL = "PropertyEditorDialog.Text.Label";
    public static final String DEFAULT_PREFIX = "Fwk";
    protected int textfieldSize = 20;
    protected String prefix = "Fwk";
    protected FwkDialogPaneValueInterface value;
    protected Hashtable textfieldHash = new Hashtable();

    public String getVersion() {
        return version;
    }

    public FwkPropertyEditorDialogPane() {
    }

    public FwkPropertyEditorDialogPane(String prefix, FwkDialogPaneValueInterface value) {
        this(prefix, null, value);
    }

    public FwkPropertyEditorDialogPane(String prefix, String title, FwkDialogPaneValueInterface value) {
        super(title);
        this.prefix = prefix != null ? prefix : DEFAULT_PREFIX;
        this.createPane(value);
    }

    public void createPane(FwkDialogPaneValueInterface value) {
        Iterator it;
        this.setSelectedValue(value);
        JPanel descrPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)descrPanel, "West");
        this.setLayout(new BorderLayout());
        this.add((Component)northPanel, "North");
        GridBagLayout gridbag = new GridBagLayout();
        descrPanel.setLayout(gridbag);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        String panelLabel = this.prefix + LABEL;
        String panelLabelText = FwkPropertyBus.getProperty(panelLabel);
        if (panelLabel.compareTo(panelLabelText) != 0) {
            StringTokenizer st = new StringTokenizer(panelLabelText, "\n");
            constraints.insets = new Insets(5, 5, 0, 5);
            constraints.gridx = 0;
            while (st.hasMoreTokens()) {
                JLabel label = new JLabel(st.nextToken());
                constraints.gridwidth = 2;
                gridbag.setConstraints(label, constraints);
                descrPanel.add(label);
                constraints.insets = new Insets(0, 5, 0, 5);
                ++constraints.gridy;
            }
        }
        if ((it = value.getProperties()) != null) {
            while (it.hasNext()) {
                Object buttonObj;
                String propertyName = (String)it.next();
                String labelName = (String)this.getPropertyAttribute(propertyName, "LabelName");
                JLabel label = null;
                label = labelName != null ? new JLabel(FwkPropertyBus.getProperty(labelName)) : new JLabel();
                this.setPropertyAttribute(propertyName, "LabelWidget", label);
                constraints.insets = new Insets(10, 5, 0, 0);
                constraints.gridx = 0;
                ++constraints.gridy;
                constraints.gridwidth = 1;
                gridbag.setConstraints(label, constraints);
                descrPanel.add(label);
                Object propertyValue = value.getProperty(propertyName);
                JTextField field = new JTextField((String)propertyValue, this.textfieldSize);
                field.addKeyListener(this);
                this.textfieldHash.put(field, propertyName);
                this.setPropertyAttribute(propertyName, "TextFieldWidget", field);
                constraints.insets = new Insets(10, 5, 0, 5);
                constraints.gridx = 1;
                boolean editable = true;
                Object editObj = this.getPropertyAttribute(propertyName, "TextFieldEditable");
                if (editObj != null && editObj instanceof Boolean) {
                    editable = (Boolean)editObj;
                }
                field.setEditable(editable);
                if (!editable) {
                    field.setBackground(this.getBackground());
                    field.setSelectionColor(this.getBackground());
                }
                gridbag.setConstraints(field, constraints);
                descrPanel.add(field);
                String unitName = (String)this.getPropertyAttribute(propertyName, "Unit");
                JLabel unitLabel = null;
                if (unitName != null) {
                    unitLabel = new JLabel(unitName);
                    constraints.insets = new Insets(14, 0, 0, 0);
                    constraints.gridx = 2;
                    gridbag.setConstraints(unitLabel, constraints);
                    descrPanel.add(unitLabel);
                }
                if ((buttonObj = this.getPropertyAttribute(propertyName, "SelectButtonLabel")) == null || !(buttonObj instanceof String)) continue;
                JButton selectButton = new JButton((String)buttonObj);
                Dimension prefSize = selectButton.getPreferredSize();
                prefSize.width -= 20;
                prefSize.height = field.getPreferredSize().height;
                selectButton.setPreferredSize(prefSize);
                selectButton.addActionListener(this);
                selectButton.setActionCommand(propertyName);
                constraints.insets = new Insets(10, 0, 0, 0);
                constraints.gridx = 2;
                gridbag.setConstraints(selectButton, constraints);
                descrPanel.add(selectButton);
            }
        }
    }

    private Object getPropertyAttribute(String propertyName, String attrName) {
        if (this.value instanceof FwkPropertyEditorDialogPaneValueInterface) {
            return ((FwkPropertyEditorDialogPaneValueInterface)this.value).getPropertyAttribute(propertyName, attrName);
        }
        return null;
    }

    private void setPropertyAttribute(String propertyName, String attrName, Object attrValue) {
        if (this.value instanceof FwkPropertyEditorDialogPaneValueInterface) {
            ((FwkPropertyEditorDialogPaneValueInterface)this.value).setPropertyAttribute(propertyName, attrName, attrValue);
        }
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        return this.value;
    }

    public void setSelectedValue(FwkDialogPaneValueInterface value) {
        this.value = value;
        value.addPropertyChangeListener(this);
    }

    public void actionPerformed(ActionEvent ev) {
        String propertyName = ev.getActionCommand();
        String[] selectList = (String[])this.getPropertyAttribute(propertyName, "SelectList");
        if (selectList != null && selectList.length > 0) {
            Integer visibleRowCount = (Integer)this.getPropertyAttribute(propertyName, "VisibleRowCount");
            Integer selectedIndex = (Integer)this.getPropertyAttribute(propertyName, "SelectedIndex");
            String selectedName = (String)this.getPropertyAttribute(propertyName, "SelectedName");
            String labelName = (String)this.getPropertyAttribute(propertyName, "LabelName");
            String labelText = null;
            if (labelName != null) {
                labelText = FwkPropertyBus.getProperty(labelName);
            }
            FwkListDialogPaneValue val = new FwkListDialogPaneValue(null);
            val.setSelectList(selectList);
            if (selectedIndex != null) {
                val.setSelectedIndex(selectedIndex);
            } else if (selectedName != null) {
                val.setSelectedName(selectedName);
            }
            if (visibleRowCount != null) {
                val.setVisibleRowCount(visibleRowCount);
            } else {
                val.setVisibleRowCount(new Integer(4));
            }
            FwkListDialogPane pane = new FwkListDialogPane(this.prefix, val);
            val = (FwkListDialogPaneValue)FwkDialogFactory.showDialog(null, labelText, "", pane);
            if (val != null) {
                this.setPropertyAttribute(propertyName, "SelectedName", val.getSelectedName());
                this.setPropertyAttribute(propertyName, "SelectedIndex", val.getProperty("SelectedIndex"));
            }
        }
    }

    public void keyPressed(KeyEvent ev) {
    }

    public void keyReleased(KeyEvent ev) {
        JTextField field = (JTextField)ev.getSource();
        String propertyName = (String)this.textfieldHash.get(field);
        if (propertyName != null) {
            this.value.setProperty(propertyName, field.getText());
        }
    }

    public void keyTyped(KeyEvent ev) {
    }

    public void propertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        Object newValue = ev.getNewValue();
        if (propertyName != null) {
            JTextField field;
            String attrName = null;
            int atPos = propertyName.indexOf(64);
            if (atPos >= 0) {
                attrName = propertyName.substring(0, atPos);
                propertyName = propertyName.substring(atPos + 1);
            }
            if (attrName != null && (attrName.compareTo("SelectedName") == 0 || attrName.compareTo("SelectedIndex") == 0) && (field = (JTextField)this.getPropertyAttribute(propertyName, "TextFieldWidget")) != null) {
                String curValue = field.getText();
                if (attrName.compareTo("SelectedName") == 0) {
                    if (newValue == null) {
                        field.setText("");
                    } else if (newValue instanceof String && curValue.compareTo(newValue.toString()) != 0) {
                        field.setText((String)newValue);
                    }
                } else if (newValue instanceof Integer) {
                    String[] selectList = (String[])this.getPropertyAttribute(propertyName, "SelectList");
                    int pos = (Integer)newValue;
                    if (pos >= 0 && pos < selectList.length && selectList[pos].compareTo(curValue) != 0) {
                        field.setText(selectList[pos]);
                    }
                }
            }
        }
    }
}

