/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkListMap;
import com.highqsoft.fwk.dialog.FwkDialogPaneValue;
import com.highqsoft.interfaces.fwk.FwkPropertyEditorDialogPaneValueInterface;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class FwkPropertyEditorDialogPaneValue
extends FwkDialogPaneValue
implements FwkPropertyEditorDialogPaneValueInterface {
    protected Map properties = null;
    protected Map disabledProperties = null;
    protected Map propertyAttributes = null;

    public FwkPropertyEditorDialogPaneValue() {
        this(false);
    }

    public FwkPropertyEditorDialogPaneValue(boolean sorted) {
        this.properties = sorted ? Collections.synchronizedMap(new TreeMap()) : Collections.synchronizedMap(new FwkListMap());
        this.disabledProperties = Collections.synchronizedMap(new HashMap());
    }

    public FwkPropertyEditorDialogPaneValue(String ident, Map properties) {
        this();
        this.setProperties(properties);
        this.setIdent(ident);
    }

    public void disable(String propertyName) {
        this.disabledProperties.put(propertyName, propertyName);
    }

    public void enable(String propertyName) {
        this.disabledProperties.remove(propertyName);
    }

    public Object getProperty(String propertyName) {
        Object propertyValue = null;
        if (!this.disabledProperties.containsKey(propertyName) && (propertyValue = super.getProperty(propertyName)) == null) {
            propertyValue = this.properties.get(propertyName);
        }
        return propertyValue;
    }

    public Iterator getProperties() {
        if (this.properties != null) {
            return this.properties.keySet().iterator();
        }
        return null;
    }

    public Object getPropertyAttribute(String propertyName, String attrName) {
        Map attrMap;
        Object attrValue = null;
        if (this.propertyAttributes != null && (attrMap = (Map)this.propertyAttributes.get(propertyName)) != null) {
            attrValue = attrMap.get(attrName);
        }
        return attrValue;
    }

    public Map getPropertyAttributes(String propertyName) {
        if (this.propertyAttributes != null) {
            return (Map)this.propertyAttributes.get(propertyName);
        }
        return null;
    }

    public void setProperties(Map properties) {
        Iterator it = properties.keySet().iterator();
        if (it != null) {
            while (it.hasNext()) {
                String propertyName = (String)it.next();
                if (this.disabledProperties.containsKey(propertyName)) continue;
                Object propertyValue = properties.get(propertyName);
                super.setProperty(propertyName, propertyValue);
                this.setProperty(propertyName, propertyValue);
            }
        }
    }

    public void setProperty(String propertyName, Object propertyValue) {
        if (!this.disabledProperties.containsKey(propertyName)) {
            super.setProperty(propertyName, propertyValue);
            Object oldValue = this.properties.get(propertyName);
            this.properties.put(propertyName, propertyValue);
            this.firePropertyChange(propertyName, oldValue, propertyValue);
        }
    }

    public void setPropertyAttribute(String propertyName, String attrName, Object attrValue) {
        Map<String, Object> attrMap;
        if (this.propertyAttributes == null) {
            this.propertyAttributes = Collections.synchronizedMap(new HashMap());
        }
        if ((attrMap = (Map<String, Object>)this.propertyAttributes.get(propertyName)) == null) {
            attrMap = Collections.synchronizedMap(new TreeMap());
            this.propertyAttributes.put(propertyName, attrMap);
        }
        Object oldValue = attrMap.get(attrName);
        attrMap.put(attrName, attrValue);
        this.firePropertyChange(attrName + "@" + propertyName, oldValue, attrValue);
    }

    public void setPropertyAttributes(String propertyName, Map attrMap) {
        if (this.propertyAttributes == null) {
            this.propertyAttributes = Collections.synchronizedMap(new HashMap());
        }
        Map oldAttrMap = (Map)this.propertyAttributes.get(propertyName);
        this.propertyAttributes.put(propertyName, attrMap);
        this.firePropertyChange(propertyName, oldAttrMap, attrMap);
    }
}

