/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.dialog.FwkTextDialogPaneValue;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.fwk.FwkKeyListenerInterface;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FwkTextDialogPane
extends FwkDialogPane {
    public static final String version = "$Revision: 1.3 $";
    protected JTextArea jTextArea;
    protected String initialText;

    public String getVersion() {
        return version;
    }

    public FwkTextDialogPane() {
        this(null, null, 20, 1);
    }

    public FwkTextDialogPane(int width, int height) {
        this(null, null, width, height);
    }

    public FwkTextDialogPane(String title, String text, int width, int height) {
        this.createPane(title, text, width, height);
    }

    protected void createPane(String title, String text, int width, int height) {
        if (text == null) {
            text = "";
        }
        int count = 1;
        int len = 0;
        int index = text.indexOf(10);
        if (index < 0) {
            len = text.length();
        }
        while (index > 0) {
            int index1 = text.indexOf(10, index + 1);
            len = Math.max(len, index1 - index);
            index = index1;
            ++count;
        }
        if (title != null && title.length() != 0) {
            this.title = title;
        }
        this.ident = null;
        this.setLayout(new BorderLayout());
        this.jTextArea = new JTextArea();
        this.jTextArea.setText(text);
        this.jTextArea.setColumns(width);
        this.jTextArea.setRows(count);
        this.jTextArea.setEditable(true);
        JScrollPane scroll = new JScrollPane(this.jTextArea);
        scroll.setPreferredSize(new Dimension(100, 100));
        this.add("Center", scroll);
        this.setInitialText(text);
    }

    public void setInitialText(String text) {
        if (text == null) {
            text = "";
        }
        this.initialText = text;
        this.jTextArea.setText(text);
    }

    public void setInitialText(String[] text) {
        this.setInitialText(FwkTextDialogPaneValue.concatenateText(text));
    }

    public String getInitialText() {
        return this.initialText;
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        return new FwkTextDialogPaneValue(this.getIdent(), this.jTextArea.getText());
    }

    public void setSelectedValue(FwkDialogPaneValueInterface value) {
        try {
            String text = (String)value.getProperty("Text");
            if (text != null) {
                this.jTextArea.setText(text);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addKeyListener(FwkKeyListenerInterface listener) {
        this.jTextArea.addKeyListener(listener);
    }

    public boolean isAllowedToConsume(EventObject e) {
        boolean ret = true;
        if (e instanceof KeyEvent) {
            KeyEvent evt = (KeyEvent)e;
            ret = !this.jTextArea.hasFocus() || evt.getKeyCode() != 10;
        }
        return ret;
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkTextDialogPane pane = new FwkTextDialogPane();
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog(null, "FwkInfoBusDialogPane - Test", "", pane);
        if (val != null) {
            System.out.println("FwkDialogPaneValueSupport Properties:");
            Iterator it = val.getProperties();
            if (it != null) {
                while (it.hasNext()) {
                    Object key = it.next();
                    System.out.println("Key: " + key + " / value:" + val.getProperty(key.toString()));
                }
            }
        } else {
            System.out.println("No value returned from FwkTextDialogPane.");
        }
    }
}

