/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.dialog.FwkTextDialogPaneValue;
import com.highqsoft.fwk.util.StringUtilities;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import java.awt.BorderLayout;
import javax.swing.JTextField;

public class FwkTextFieldDialogPane
extends FwkDialogPane {
    public static final String version = "$Revision: 1.4 $";
    protected JTextField jTextField;
    protected String initialText;

    public String getVersion() {
        return version;
    }

    public FwkTextFieldDialogPane() {
        this(null, null, 20);
    }

    public FwkTextFieldDialogPane(int width) {
        this(null, null, width);
    }

    public FwkTextFieldDialogPane(String title, String text, int width) {
        this.createPane(title, text, width);
    }

    protected void createPane(String t, String text, int width) {
        if (t != null && t.length() != 0) {
            this.title = t;
        }
        this.ident = null;
        this.setLayout(new BorderLayout());
        this.jTextField = new JTextField(width);
        this.add("Center", this.jTextField);
        this.setInitialText(text);
    }

    public void setSize(int width) {
        this.jTextField.setColumns(width);
    }

    public void setInitialText(String text) {
        if (text == null) {
            text = "";
        }
        this.initialText = text;
        this.jTextField.setText(text);
    }

    public void setInitialText(String[] text) {
        this.setInitialText(StringUtilities.concatenate(text, "\n", false));
    }

    public String getInitialText() {
        return this.initialText;
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        return new FwkTextDialogPaneValue(this.getIdent(), this.jTextField.getText());
    }

    public void setSelectedValue(FwkDialogPaneValueInterface value) {
        try {
            String text = (String)value.getProperty("Text");
            if (text != null) {
                this.jTextField.setText(text);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

