/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.dialog.FwkToggleDialogPaneValue;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class FwkToggleDialogPane
extends FwkDialogPane {
    public static final String version = "$Revision: 1.4 $";
    AbstractMap initialMap;
    AbstractMap checks;
    boolean exclusive = false;

    public String getVersion() {
        return version;
    }

    public FwkToggleDialogPane() {
        this(null, null, 20, 1);
    }

    public FwkToggleDialogPane(int width, int height) {
        this(null, null, width, height);
    }

    public FwkToggleDialogPane(String title, AbstractMap map, int width, int height) {
        this.createPane(title, map, width, height);
    }

    public void setExclusive(boolean exclusive) {
        if (this.exclusive != exclusive) {
            this.exclusive = exclusive;
            this.updatePanel();
        }
    }

    public boolean getExclusive() {
        return this.exclusive;
    }

    protected void createPane(String t, AbstractMap map, int width, int height) {
        if (t != null && t.length() != 0) {
            this.title = t;
        }
        this.ident = null;
        if (map == null) {
            map = new HashMap();
        }
        this.setInitialMap(map);
        this.updatePanel();
    }

    protected void updatePanel() {
        block7: {
            this.removeAll();
            int size = this.initialMap.size();
            if (size == 0) break block7;
            Object[] keys = new String[size];
            int rows = (int)Math.sqrt(size);
            if (rows * rows < size) {
                ++rows;
            }
            this.setLayout(new GridLayout(rows, rows));
            Iterator it = this.initialMap.keySet().iterator();
            int count = 0;
            if (it != null) {
                while (it.hasNext()) {
                    keys[count++] = (String)it.next();
                }
            }
            Arrays.sort(keys);
            this.checks = new HashMap();
            MouseAdapter listener = new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    if ((e.getModifiers() & 0x10) != 0) {
                        String key = ((JLabel)e.getSource()).getText();
                        if (!FwkToggleDialogPane.this.exclusive) {
                            JCheckBox cb;
                            cb.setSelected(!(cb = (JCheckBox)FwkToggleDialogPane.this.checks.get(key)).isSelected());
                        } else {
                            JRadioButton cb;
                            cb.setSelected(!(cb = (JRadioButton)FwkToggleDialogPane.this.checks.get(key)).isSelected());
                        }
                    }
                }
            };
            if (!this.exclusive) {
                for (count = 0; count < size; ++count) {
                    JPanel p = new JPanel();
                    p.setLayout(new BorderLayout());
                    FwkToggleDialogPaneValue.ToggleValue val = (FwkToggleDialogPaneValue.ToggleValue)this.initialMap.get(keys[count]);
                    JCheckBox cb = new JCheckBox("", val.value);
                    this.checks.put(keys[count], cb);
                    p.add((Component)cb, "West");
                    JLabel l = new JLabel(FwkPropertyBus.getProperty(val.textKey), FwkIconFile.getIcon(val.iconKey), 2);
                    l.addMouseListener(listener);
                    p.add((Component)l, "Center");
                    this.add(p);
                }
            } else {
                ButtonGroup group = new ButtonGroup();
                for (count = 0; count < size; ++count) {
                    JPanel p = new JPanel();
                    p.setLayout(new BorderLayout());
                    FwkToggleDialogPaneValue.ToggleValue val = (FwkToggleDialogPaneValue.ToggleValue)this.initialMap.get(keys[count]);
                    JRadioButton cb = new JRadioButton("", val.isSelected());
                    this.checks.put(keys[count], cb);
                    p.add((Component)cb, "West");
                    JLabel l = new JLabel(FwkPropertyBus.getProperty(val.textKey), FwkIconFile.getIcon(val.iconKey), 2);
                    l.addMouseListener(listener);
                    p.add((Component)l, "Center");
                    group.add(cb);
                    this.add(p);
                }
            }
        }
    }

    protected void setInitialMap(AbstractMap map) {
        if (map == null) {
            map = new HashMap();
        }
        this.initialMap = map;
        this.updatePanel();
        this.validate();
    }

    public AbstractMap getInitialMap() {
        return this.initialMap;
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        HashMap ret;
        block7: {
            block6: {
                ret = new HashMap();
                if (this.checks == null) break block6;
                Iterator it = this.checks.keySet().iterator();
                if (it == null) break block7;
                if (!this.exclusive) {
                    while (it.hasNext()) {
                        Object key = it.next();
                        JCheckBox cb = (JCheckBox)this.checks.get(key);
                        FwkToggleDialogPaneValue.ToggleValue val = (FwkToggleDialogPaneValue.ToggleValue)this.initialMap.get(key);
                        ret.put(key, new FwkToggleDialogPaneValue.ToggleValue((String)key, val.iconKey, cb.isSelected()));
                    }
                } else {
                    while (it.hasNext()) {
                        Object key = it.next();
                        JRadioButton cb = (JRadioButton)this.checks.get(key);
                        FwkToggleDialogPaneValue.ToggleValue val = (FwkToggleDialogPaneValue.ToggleValue)this.initialMap.get(key);
                        ret.put(key, new FwkToggleDialogPaneValue.ToggleValue((String)key, val.iconKey, cb.isSelected()));
                    }
                }
                break block7;
            }
            Iterator it = this.initialMap.keySet().iterator();
            if (it != null) {
                while (it.hasNext()) {
                    Object key = it.next();
                    FwkToggleDialogPaneValue.ToggleValue val = (FwkToggleDialogPaneValue.ToggleValue)this.initialMap.get(key);
                    ret.put(key, new FwkToggleDialogPaneValue.ToggleValue((String)key, val.iconKey, val.value));
                }
            }
        }
        return new FwkToggleDialogPaneValue(this.getIdent(), ret);
    }

    public void setSelectedValue(FwkDialogPaneValueInterface value) {
        try {
            AbstractMap map = (AbstractMap)value.getProperty("Map");
            if (map != null) {
                this.setInitialMap(map);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkToggleDialogPane pane = new FwkToggleDialogPane();
        pane.setExclusive(true);
        FwkToggleDialogPaneValue ini = new FwkToggleDialogPaneValue();
        ini.add("AoAny", false);
        ini.add("AoMeasurement", false);
        ini.add("AoLocalColumn", true);
        ini.add("AoTest", true);
        ini.add("AoSubTest", true);
        pane.setSelectedValue(ini);
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog(null, "FwkToggleDialogPane - Test", "AoAny", pane);
        if (val != null) {
            AbstractMap map = (AbstractMap)val.getProperty("Map");
            System.out.println("FwkDialogPaneValueSupport Properties:");
            Iterator it = map.keySet().iterator();
            if (it != null) {
                while (it.hasNext()) {
                    Object key = it.next();
                    System.out.println("Key: " + key + " / value:" + map.get(key));
                }
            }
            System.out.println("\nselectedKeys:");
            String[] arr = ((FwkToggleDialogPaneValue)val).get();
            for (int i = 0; i < arr.length; ++i) {
                System.out.println(arr[i]);
            }
        } else {
            System.out.println("No value returned from FwkTextDialogPane.");
        }
        System.exit(0);
    }
}

