/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.exception;

import com.highqsoft.fwk.Fwk;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.exception.FwkExceptionWriterInterface;
import com.highqsoft.fwk.exception.FwkFileWriter;
import com.highqsoft.fwk.exception.FwkLibraryWriter;
import com.highqsoft.interfaces.fwk.FwkExceptionInterface;
import com.highqsoft.interfaces.fwk.FwkInterface;

public class FwkExceptionWriter
extends Fwk
implements FwkExceptionWriterInterface,
FwkInterface {
    public static final String version = "$Revision: 1.3 $";
    static FwkExceptionWriter instance = null;
    static FwkExceptionWriterInterface writer = null;
    boolean writeToFile = false;

    public String getVersion() {
        return version;
    }

    private FwkExceptionWriter() {
    }

    public static FwkExceptionWriter getInstance() {
        if (instance == null) {
            instance = new FwkExceptionWriter();
        }
        return instance;
    }

    public boolean isAlive() {
        return writer != null && writer.isAlive();
    }

    public Throwable getException() {
        if (this.isAlive()) {
            return writer.getException();
        }
        return null;
    }

    public void init(String program, String version, String[] args) {
        String className;
        Throwable externWriterProblem = null;
        if (program == null) {
            program = this.getClass().getName();
        }
        if (version == null) {
            version = "";
        }
        if ((className = System.getProperty("ExceptionWriter.Class")) != null) {
            try {
                Class<?> clazz = Class.forName(className);
                writer = (FwkExceptionWriterInterface)clazz.newInstance();
                if (!writer.isAlive()) {
                    writer = null;
                }
            }
            catch (Throwable t) {
                externWriterProblem = t;
                writer = null;
            }
        }
        if (writer == null && !(writer = new FwkLibraryWriter()).isAlive()) {
            writer = new FwkFileWriter();
            if (!writer.isAlive()) {
                System.err.println(this.getClass().getName() + ": Cannot initialize the Exception writer!");
                writer = null;
            } else {
                this.writeToFile = true;
            }
        }
        if (writer != null) {
            writer.init(program, version, args);
        }
        if (externWriterProblem != null) {
            new FwkException(-1073676289, "$RCSfile: FwkExceptionWriter.java,v $", version, "AH 2000-10-20 10:11", "Cannot create an instance of the type <" + className + ">.", null, externWriterProblem);
        }
    }

    public static void write(int code, String className, String fileName, String version, String lineIdent, String parameter) {
        FwkExceptionWriter.getInstance().put(code, className, fileName, version, lineIdent, parameter);
    }

    public void put(int code, String className, String fileName, String version, String lineIdent, String parameter) {
        if (this.isAlive()) {
            writer.put(code, className, fileName, this.getVersion(), lineIdent, parameter);
        }
    }

    public static void write(FwkExceptionInterface exception) {
        FwkExceptionWriter.getInstance().put(exception);
    }

    public void put(FwkExceptionInterface exception) {
        if (this.isAlive()) {
            writer.put(exception);
        }
    }

    public void close() {
        if (this.isAlive()) {
            writer.close();
        }
    }

    public boolean isError(int code) {
        if (this.isAlive()) {
            return writer.isError(code);
        }
        return false;
    }

    public boolean isWarning(int code) {
        if (this.isAlive()) {
            return writer.isWarning(code);
        }
        return false;
    }

    public boolean isInformation(int code) {
        if (this.isAlive()) {
            return writer.isInformation(code);
        }
        return false;
    }

    public boolean isOccured() {
        if (this.isAlive()) {
            return writer.isOccured();
        }
        return false;
    }

    public void reset() {
        if (this.isAlive()) {
            writer.reset();
        }
    }

    public String getParams() {
        return writer.isAlive() ? writer.toString() : "writer not alive.";
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getParams() + "]";
    }
}

