/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.exception;

import com.highqsoft.fwk.Fwk;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.exception.FwkExceptionWriterInterface;
import com.highqsoft.interfaces.fwk.FwkExceptionInterface;
import com.highqsoft.interfaces.fwk.FwkInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Calendar;

public class FwkFileWriter
extends Fwk
implements FwkExceptionWriterInterface,
FwkInterface {
    public static final String version = "$Revision: 1.3 $";
    static File filename;
    static Throwable exception;
    static PrintWriter pw;
    static String hostname;
    static String programName;
    static String programVersion;
    static int last_code;
    static String last_file;
    static String last_revision;
    static String last_lineIdent;
    static String parameter;
    static boolean error_occured;
    static String formatSpace;

    public String getVersion() {
        return version;
    }

    public FwkFileWriter() {
        this.openFile();
    }

    private void openFile() {
        if (pw != null) {
            pw.close();
        }
        pw = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            pw = new PrintWriter(fos);
        }
        catch (Exception ex) {
            exception = ex;
        }
    }

    public boolean isAlive() {
        return pw != null && exception == null;
    }

    public Throwable getException() {
        return exception;
    }

    public void init(String program, String version, String[] args) {
        if (!this.isAlive()) {
            if (program == null || program == "") {
                program = "Unknown";
            }
            programName = program;
            if (version == null || version == "") {
                version = "0.0";
            }
            programVersion = version;
            String c = filename.getName();
            if (c.endsWith(".log")) {
                int i = c.indexOf(".log");
                c = c.substring(0, i) + ".bak";
            }
            File orgFile = new File(filename.getParent(), filename.getName());
            File backFile = new File(filename.getParent(), c);
            try {
                orgFile.renameTo(backFile);
            }
            catch (Exception exp) {
                // empty catch block
            }
            String argsCon = "";
            if (args != null && args.length != 0) {
                for (int i = 0; i < args.length; ++i) {
                    argsCon = argsCon + args[i];
                }
            }
            this.put(1073742824, this.getClass().getName(), "$RCSfile: FwkFileWriter.java,v $", version, "AH 1999-02-03 20:06", argsCon);
            this.reset();
        }
    }

    private String formatString(String s, int l, boolean left) {
        if (s == null) {
            s = "";
        }
        String ret = "";
        ret = s.length() > l ? (left ? s.substring(0, l - 1) : s.substring(s.length() - l)) : (left ? s + formatSpace.substring(0, l - s.length()) : formatSpace.substring(0, l - s.length()) + s);
        return ret;
    }

    public void put(FwkExceptionInterface exception) {
        this.put(exception.getNumber(), exception.getClassName(), exception.getFilename(), exception.getCodeVersion(), exception.getIdent(), exception.getParameter());
    }

    public void put(int code, String className, String fileName, String version, String lineIdent, String parameter) {
        if (!this.isAlive()) {
            this.openFile();
        }
        if (this.isAlive()) {
            char eventlogType;
            switch (code & 0xC0000000) {
                case -1073741824: {
                    eventlogType = 'E';
                    break;
                }
                case -2147483648: {
                    eventlogType = 'W';
                    break;
                }
                case 0x40000000: {
                    eventlogType = 'I';
                    break;
                }
                default: {
                    eventlogType = 'I';
                }
            }
            pw.print(eventlogType + ",");
            Calendar calendar = Calendar.getInstance();
            pw.print("\"" + this.formatString("" + calendar.get(1), 4, false).replace(' ', '0') + "-" + this.formatString("" + calendar.get(2), 2, false).replace(' ', '0') + "-" + this.formatString("" + calendar.get(5), 2, false).replace(' ', '0') + " " + this.formatString("" + calendar.get(11), 2, false).replace(' ', '0') + ":" + this.formatString("" + calendar.get(12), 2, false).replace(' ', '0') + ":" + this.formatString("" + calendar.get(13), 2, false).replace(' ', '0') + "\",");
            pw.print("\"" + this.formatString(programName, 16, true) + "\",");
            pw.print(this.formatString("" + (code & 0xFFFF), 5, false).replace(' ', '0') + ",");
            pw.print("\"" + this.formatString(hostname, 12, true) + "\",");
            pw.print(this.formatString("\"" + System.getProperty("user.name"), 12, true) + "\",");
            pw.print("\"" + programVersion + "\",");
            pw.print(className);
            pw.print(", ");
            pw.print(fileName);
            pw.print(", ");
            pw.print(version);
            pw.print(", \"");
            pw.print(lineIdent);
            pw.print("\"");
            if (parameter == null || parameter.length() == 0) {
                pw.println();
            } else {
                pw.println(",\"" + parameter + "\"");
            }
            pw.flush();
            last_code = code;
            last_file = className;
            last_revision = version;
            last_lineIdent = lineIdent;
            FwkFileWriter.parameter = parameter;
            error_occured = true;
        }
    }

    public void close() {
        if (this.isAlive()) {
            pw.close();
        }
    }

    public boolean isError(int code) {
        boolean result;
        switch (code & 0xC0000000) {
            case -1073741824: {
                result = true;
                break;
            }
            case -2147483648: {
                result = false;
                break;
            }
            case 0x40000000: {
                result = false;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean isWarning(int code) {
        boolean result;
        switch (code & 0xC0000000) {
            case -1073741824: {
                result = false;
                break;
            }
            case -2147483648: {
                result = true;
                break;
            }
            case 0x40000000: {
                result = false;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean isInformation(int code) {
        boolean result;
        switch (code & 0xC0000000) {
            case -1073741824: {
                result = false;
                break;
            }
            case -2147483648: {
                result = false;
                break;
            }
            case 0x40000000: {
                result = true;
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }

    public boolean isOccured() {
        return error_occured;
    }

    public void reset() {
        last_code = 0;
        last_file = "";
        last_revision = "";
        last_lineIdent = "";
        parameter = "";
        error_occured = false;
    }

    public String getParams() {
        String ret = "filename=\"" + filename + "\" ";
        ret = this.isAlive() ? ret + "isAlive=true" : ret + "isAlive=false";
        return ret;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getParams() + "]";
    }

    public void setDefaults() {
        this.reset();
    }

    static {
        exception = null;
        pw = null;
        programName = "";
        programVersion = "";
        last_code = 0;
        last_file = "";
        last_revision = "";
        last_lineIdent = "";
        parameter = "";
        error_occured = false;
        filename = new File(FwkContainer.getUserDirectory(), "com-highqsoft-error.log");
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            hostname = "Unknown";
        }
        char[] arr = new char[64];
        for (int i = 0; i < 64; ++i) {
            arr[i] = 32;
        }
        formatSpace = new String(arr);
    }
}

