/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.factory;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkMimeType;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusProducerInterface;
import com.highqsoft.interfaces.fwk.FwkMimeTypeInterface;
import com.highqsoft.interfaces.fwk.FwkPortInterface;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.infobus.DataItem;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataConsumer;
import javax.infobus.InfoBusDataProducer;
import javax.infobus.InfoBusItemAvailableEvent;
import javax.infobus.InfoBusItemRequestedEvent;
import javax.infobus.InfoBusItemRevokedEvent;
import javax.infobus.InfoBusMemberSupport;

public class FwkInfoBusPortFactory
extends FwkMimeType
implements FwkInfoBusProducerInterface {
    public static final String version = "$Revision: 1.4 $";
    public static final String PORTMIMETYPE = FwkContainer.getMimeType(FwkPortInterface.class);
    public static final String BRICKMIMETYPE = FwkContainer.getMimeType(FwkMimeTypeInterface.class);
    static FwkInfoBusPortFactory producer;
    HashMap portList;

    public String getVersion() {
        return version;
    }

    private FwkInfoBusPortFactory() {
        this("");
    }

    private FwkInfoBusPortFactory(String itemName) {
        super(PORTMIMETYPE);
        this.setMemberName(itemName);
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            ib.addDataProducer((InfoBusDataProducer)this);
        }
        this.portList = new HashMap();
    }

    public void finalize() throws Throwable {
        this.unregister();
        super.finalize();
    }

    public FwkControllerInterface getController() {
        return null;
    }

    public void setController(FwkControllerInterface controller) {
    }

    public void unregister() {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            ib.removeDataProducer((InfoBusDataProducer)this);
        }
    }

    public void register() {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            ib.addDataProducer((InfoBusDataProducer)this);
        }
    }

    public synchronized void register(FwkPortInterface port) {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            String ident = port.getMemberName();
            if ((FwkContainer.getTraceLevel() & 0x80L) != 0L) {
                FwkContainer.sendTrace(port, 128L, "Register <" + port.getName() + "> at " + ib.getName(), FwkContainer.getLocalHost(), FwkContainer.getUserName());
            }
            this.portList.put(ident, port);
            this.fireItemAvailable(port, this.getDataFlavors());
        }
    }

    public synchronized void unregister(FwkPortInterface port) {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            String ident = port.getMemberName();
            if ((FwkContainer.getTraceLevel() & 0x100L) != 0L) {
                FwkContainer.sendTrace(port, 256L, "Unregister <" + port.getName() + "> at " + ib.getName(), FwkContainer.getLocalHost(), FwkContainer.getUserName());
            }
            this.fireItemRevoked((DataItem)this.portList.remove(ident));
        }
    }

    public boolean revoke(String itemName, DataFlavor[] flavor) {
        if (this.isAssignable(flavor)) {
            if (itemName == null) {
                return true;
            }
            if (itemName.indexOf(42) != -1 || itemName.indexOf(63) != -1) {
                String key;
                FwkArray arr = new FwkArray();
                Iterator it = this.portList.keySet().iterator();
                while (it.hasNext()) {
                    key = (String)it.next();
                    if (!Pattern.match(key, itemName, false)) continue;
                    arr.add(key);
                }
                int size = arr.size();
                for (int i = 0; i < size; ++i) {
                    key = (String)arr.get(i);
                    this.fireItemRevoked((DataItem)this.portList.remove(key));
                }
            } else {
                this.fireItemRevoked((DataItem)this.portList.remove(itemName));
            }
        }
        return true;
    }

    public boolean isAssignable(DataFlavor[] flavors) {
        if (flavors != null) {
            for (int i = flavors.length - 1; i >= 0; --i) {
                if (flavors[i].getMimeType().compareTo(PORTMIMETYPE) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public void fireItemAvailable(DataItem item, DataFlavor[] flavor) {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            FwkPortInterface port = (FwkPortInterface)item;
            String ident = port.getMemberName();
            port.fireItemAdded();
            ib.fireItemAvailable(ident, flavor, (InfoBusDataProducer)this);
        }
    }

    public void fireItemRevoked(DataItem item) {
        InfoBus ib;
        if (item != null && (ib = this.getInfoBus()) != null) {
            FwkPortInterface port = (FwkPortInterface)item;
            if (port != null) {
                port.fireItemRevoked();
            }
            ib.fireItemRevoked(port.getMemberName(), (InfoBusDataProducer)this);
        }
    }

    public Object findDataItem(String dataItemName) {
        return this.findDataItem(dataItemName, this.getDataFlavors());
    }

    public Object findDataItem(String dataItemName, DataFlavor[] flavors) {
        Object ret = null;
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            FwkInfoBusPortFactoryConsumer consumer = new FwkInfoBusPortFactoryConsumer();
            ib.addDataConsumer((InfoBusDataConsumer)consumer);
            ret = ib.findDataItem(dataItemName, flavors, (InfoBusDataConsumer)consumer);
            ib.removeDataConsumer((InfoBusDataConsumer)consumer);
        }
        return ret;
    }

    public Object[] findMultipleDataItems(String dataItemName) {
        return this.findMultipleDataItems(dataItemName, this.getDataFlavors());
    }

    public Object[] findMultipleDataItems(String dataItemName, DataFlavor[] flavors) {
        Object[] ret = new Object[]{};
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            FwkInfoBusPortFactoryConsumer consumer = new FwkInfoBusPortFactoryConsumer();
            ib.addDataConsumer((InfoBusDataConsumer)consumer);
            ret = ib.findMultipleDataItems(dataItemName, flavors, (InfoBusDataConsumer)consumer);
            ib.removeDataConsumer((InfoBusDataConsumer)consumer);
        }
        return ret;
    }

    public void setInfoBusName(String newName) {
    }

    public static FwkInfoBusPortFactory getInstance() {
        if (producer == null) {
            producer = new FwkInfoBusPortFactory("FwkInfoBusPortFactory@FwkPortBus");
        }
        return producer;
    }

    protected void firePatternItemAvailable(String pattern, DataFlavor[] flavor, Vector arr) {
        Object[] obj;
        if (this.isConnected() && pattern != null && (obj = this.portList.values().toArray()) != null && obj.length > 0) {
            for (int i = obj.length - 1; i >= 0; --i) {
                FwkPortInterface p = (FwkPortInterface)obj[i];
                String ident = p.getName();
                if (!Pattern.match(ident, pattern, false)) continue;
                this.fireItemAvailable(p, flavor, arr);
            }
        }
    }

    protected void fireItemAvailable(FwkPortInterface p, DataFlavor[] flavor, Vector arr) {
        if (this.isConnected() && p.isConnected()) {
            boolean added = false;
            int col = flavor.length - 1;
            while (col >= 0 && !added) {
                added = this.getDataFlavors()[0].equals(flavor[col--]);
                if (!added) continue;
                arr.add(p);
            }
        }
    }

    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        DataFlavor[] dataFlavor;
        int i;
        DataFlavor[] flavor;
        if ((FwkContainer.getTraceLevel() & 4L) != 0L) {
            FwkContainer.sendTrace(this, 4L, "Item <" + ev.getDataItemName() + "> requested at " + "FwkPortBus", FwkContainer.getLocalHost(), FwkContainer.getUserName());
        }
        if (ev.getDataItem() == null && (flavor = ev.getDataFlavors()) != null) {
            for (i = flavor.length - 1; i >= 0; --i) {
                if (flavor[i].getMimeType().compareTo(FWKMIMETYPE) != 0) continue;
                ev.setDataItem((Object)this);
                return;
            }
        }
        if (ev.getDataItem() == null && (dataFlavor = ev.getDataFlavors()) != null) {
            for (i = dataFlavor.length - 1; i >= 0; --i) {
                String key = ev.getDataItemName();
                if (key.indexOf(42) != -1 || key.indexOf(63) != -1) {
                    Vector arr = new Vector();
                    this.firePatternItemAvailable(key, dataFlavor, arr);
                    if (arr.size() == 0) continue;
                    ev.setDataItem((Object)arr.toArray());
                    continue;
                }
                Object p = this.portList.get(key);
                if (p == null) continue;
                ev.setDataItem(p);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        this.firePropertyChange(ev);
    }

    class FwkInfoBusPortFactoryConsumer
    extends InfoBusMemberSupport
    implements InfoBusDataConsumer {
        public void dataItemAvailable(InfoBusItemAvailableEvent event) {
        }

        public void dataItemRevoked(InfoBusItemRevokedEvent event) {
        }

        public void propertyChange(PropertyChangeEvent event) {
        }
    }
}

