/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.factory;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkMimeType;
import com.highqsoft.fwk.FwkSortedArray;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusProducerInterface;
import com.highqsoft.interfaces.fwk.FwkMimeTypeInterface;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.infobus.DataItem;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataConsumer;
import javax.infobus.InfoBusDataProducer;
import javax.infobus.InfoBusItemAvailableEvent;
import javax.infobus.InfoBusItemRequestedEvent;
import javax.infobus.InfoBusItemRevokedEvent;
import javax.infobus.InfoBusMemberSupport;

public class FwkInfoBusProducerFactory
extends FwkMimeType
implements FwkInfoBusProducerInterface {
    public static final String version = "$Revision: 1.4 $";
    public static final String PRODUCERMIMETYPE = FwkContainer.getMimeType(FwkInfoBusProducerInterface.class);
    public static final String FWKMIMETYPE = FwkContainer.getMimeType(FwkMimeTypeInterface.class);
    static FwkInfoBusProducerFactory producer;
    HashMap producerList;

    public String getVersion() {
        return version;
    }

    private FwkInfoBusProducerFactory() {
        this("");
    }

    private FwkInfoBusProducerFactory(String itemName) {
        super(PRODUCERMIMETYPE);
        this.setMemberName(itemName);
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            ib.addDataProducer((InfoBusDataProducer)this);
        }
        this.producerList = new HashMap();
    }

    public void finalize() throws Throwable {
        this.unregister();
        super.finalize();
    }

    public void unregister() {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            ib.removeDataProducer((InfoBusDataProducer)this);
        }
    }

    public FwkControllerInterface getController() {
        return null;
    }

    public void setController(FwkControllerInterface controller) {
    }

    public void register() {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            ib.addDataProducer((InfoBusDataProducer)this);
        }
    }

    public synchronized void register(FwkInfoBusProducerInterface producer) {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            String ident = producer.getMemberName();
            if ((FwkContainer.getTraceLevel() & 0x80L) != 0L) {
                FwkContainer.sendTrace(producer, 128L, "Register <" + producer.getName() + "> at " + "FwkProducerBus", FwkContainer.getLocalHost(), FwkContainer.getUserName());
            }
            this.producerList.put(ident, producer);
            this.fireItemAvailable(producer, this.getDataFlavors());
        }
    }

    public synchronized void unregister(FwkInfoBusProducerInterface producer) {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            String ident = producer.getMemberName();
            if ((FwkContainer.getTraceLevel() & 0x100L) != 0L) {
                FwkContainer.sendTrace(producer, 256L, "Unregister <" + producer.getName() + "> at " + "FwkProducerBus", FwkContainer.getLocalHost(), FwkContainer.getUserName());
            }
            this.fireItemRevoked((DataItem)this.producerList.remove(ident));
        }
    }

    public static FwkInfoBusProducerFactory getInstance() {
        if (producer == null) {
            producer = new FwkInfoBusProducerFactory("FwkInfoBusProducerFactory@FwkProducerBus");
        }
        return producer;
    }

    public void revokeFromAll(String[] itemList, DataFlavor[] flavor) {
        int size = itemList.length;
        for (int i = 0; i < size; ++i) {
            this.revokeFromAll(itemList[i], flavor);
        }
    }

    public void revokeFromAll(String itemName, DataFlavor[] flavor) {
        Object[] arr = this.findMultipleDataItems("*", FwkContainer.getDataFlavor(FwkInfoBusProducerInterface.class));
        if (arr != null) {
            for (int i = arr.length - 1; i >= 0; --i) {
                try {
                    FwkInfoBusProducerInterface producer = (FwkInfoBusProducerInterface)arr[i];
                    producer.revoke(itemName, flavor);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public boolean revoke(String itemName, DataFlavor[] flavor) {
        if (this.isAssignable(flavor)) {
            if (itemName == null) {
                return true;
            }
            if (itemName.indexOf(42) != -1 || itemName.indexOf(63) != -1) {
                String key;
                FwkArray arr = new FwkArray();
                Iterator it = this.producerList.keySet().iterator();
                while (it.hasNext()) {
                    key = (String)it.next();
                    if (!Pattern.match(key, itemName, false)) continue;
                    arr.add(key);
                }
                int size = arr.size();
                for (int i = 0; i < size; ++i) {
                    key = (String)arr.get(i);
                    this.fireItemRevoked((DataItem)this.producerList.remove(key));
                }
            } else {
                this.fireItemRevoked((DataItem)this.producerList.remove(itemName));
            }
        }
        return true;
    }

    public boolean isAssignable(DataFlavor[] flavors) {
        if (flavors != null) {
            for (int i = flavors.length - 1; i >= 0; --i) {
                if (flavors[i].getMimeType().compareTo(PRODUCERMIMETYPE) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public void fireItemAvailable(DataItem item, DataFlavor[] flavor) {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            FwkInfoBusProducerInterface producer = (FwkInfoBusProducerInterface)item;
            String ident = producer.getMemberName();
            producer.fireItemAdded();
            ib.fireItemAvailable(ident, flavor, (InfoBusDataProducer)this);
        }
    }

    public void fireItemRevoked(DataItem item) {
        InfoBus ib;
        if (item != null && (ib = this.getInfoBus()) != null) {
            FwkInfoBusProducerInterface producer = (FwkInfoBusProducerInterface)item;
            if (producer != null) {
                producer.fireItemRevoked();
            }
            ib.fireItemRevoked(producer.getMemberName(), (InfoBusDataProducer)this);
        }
    }

    public Object findDataItem(String dataItemName) {
        return this.findDataItem(dataItemName, this.getDataFlavors());
    }

    public Object findDataItem(String dataItemName, DataFlavor[] flavors) {
        Object ret = null;
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            InfoBusProducerFactoryConsumer consumer = new InfoBusProducerFactoryConsumer();
            ib.addDataConsumer((InfoBusDataConsumer)consumer);
            ret = ib.findDataItem(dataItemName, flavors, (InfoBusDataConsumer)consumer);
            ib.removeDataConsumer((InfoBusDataConsumer)consumer);
        }
        return ret;
    }

    public Object[] findMultipleDataItems(String dataItemName) {
        return this.findMultipleDataItems(dataItemName, this.getDataFlavors());
    }

    public Object[] findMultipleDataItems(String dataItemName, DataFlavor[] flavors) {
        Object[] ret = new Object[]{};
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            InfoBusProducerFactoryConsumer consumer = new InfoBusProducerFactoryConsumer();
            ib.addDataConsumer((InfoBusDataConsumer)consumer);
            Object[] arr = ib.findMultipleDataItems(dataItemName, flavors, (InfoBusDataConsumer)consumer);
            ib.removeDataConsumer((InfoBusDataConsumer)consumer);
            if (arr != null && arr.length != 0) {
                FwkArray oArr = new FwkArray();
                for (int i = arr.length - 1; i >= 0; --i) {
                    if (arr[i] instanceof Object[]) {
                        Object[] tmp = (Object[])arr[i];
                        for (int j = tmp.length - 1; j >= 0; --j) {
                            oArr.add(tmp[j]);
                        }
                        continue;
                    }
                    oArr.add(arr[i]);
                }
                ret = oArr.toArray();
            }
        }
        return ret;
    }

    protected void firePatternItemAvailable(String pattern, DataFlavor[] flavor, Vector arr) {
        Object[] obj;
        if (this.isConnected() && pattern != null && (obj = this.producerList.values().toArray()) != null && obj.length > 0) {
            for (int i = obj.length - 1; i >= 0; --i) {
                FwkInfoBusProducerInterface p = (FwkInfoBusProducerInterface)obj[i];
                String ident = p.getName();
                if (!Pattern.match(ident, pattern, false)) continue;
                this.fireItemAvailable(p, flavor, arr);
            }
        }
    }

    protected void fireItemAvailable(FwkInfoBusProducerInterface p, DataFlavor[] flavor, Vector arr) {
        if (this.isConnected() && p.isConnected()) {
            boolean added = false;
            int col = flavor.length - 1;
            while (col >= 0 && !added) {
                added = this.getDataFlavors()[0].equals(flavor[col--]);
                if (!added) continue;
                arr.add(p);
            }
        }
    }

    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        DataFlavor[] dataFlavor;
        int i;
        DataFlavor[] flavor;
        if ((FwkContainer.getTraceLevel() & 4L) != 0L) {
            FwkContainer.sendTrace(this, 4L, "Item <" + ev.getDataItemName() + "> requested at " + "FwkProducerBus", FwkContainer.getLocalHost(), FwkContainer.getUserName());
        }
        if (ev.getDataItem() == null && (flavor = ev.getDataFlavors()) != null) {
            for (i = flavor.length - 1; i >= 0; --i) {
                if (flavor[i].getMimeType().compareTo(FWKMIMETYPE) != 0) continue;
                ev.setDataItem((Object)this);
                return;
            }
        }
        if (ev.getDataItem() == null && (dataFlavor = ev.getDataFlavors()) != null) {
            for (i = dataFlavor.length - 1; i >= 0; --i) {
                String key = ev.getDataItemName();
                if (key.indexOf(42) != -1 || key.indexOf(63) != -1) {
                    Vector arr = new Vector();
                    this.firePatternItemAvailable(key, dataFlavor, arr);
                    if (arr.size() == 0) continue;
                    ev.setDataItem((Object)arr.toArray());
                    continue;
                }
                Object p = this.producerList.get(key);
                if (p == null) continue;
                ev.setDataItem(p);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        this.firePropertyChange(ev);
    }

    public static String[] inspect(DataFlavor flavor) {
        return FwkInfoBusProducerFactory.getInstance().inspectImpl(flavor);
    }

    public String[] inspectImpl(DataFlavor flavor) {
        FwkSortedArray retArr = new FwkSortedArray();
        Iterator it = this.producerList.keySet().iterator();
        while (it.hasNext()) {
            FwkInfoBusProducerInterface producer = (FwkInfoBusProducerInterface)this.producerList.get(it.next());
            DataFlavor[] dfArr = producer.getDataFlavors();
            if (dfArr == null || dfArr.length == 0) continue;
            int size = dfArr.length;
            int count = 0;
            boolean stop = false;
            while (!stop && count < size) {
                stop = dfArr[count++].equals(flavor);
            }
            if (!stop) continue;
            retArr.add((Comparable)((Object)producer.getInfoBusName()));
        }
        String[] ret = new String[retArr.size()];
        ret = retArr.toArray(ret);
        return ret;
    }

    class InfoBusProducerFactoryConsumer
    extends InfoBusMemberSupport
    implements InfoBusDataConsumer {
        public void dataItemAvailable(InfoBusItemAvailableEvent event) {
        }

        public void dataItemRevoked(InfoBusItemRevokedEvent event) {
        }

        public void propertyChange(PropertyChangeEvent event) {
        }
    }
}

