/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.images;

import com.highqsoft.fwk.Fwk;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkIcon;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.interfaces.fwk.FwkInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;

public class FwkIconFile
extends Fwk
implements FwkInterface {
    public static final String version = "$Revision: 1.4 $";
    protected static HashMap iconCache = new HashMap();
    protected static HashMap iconNotFoundCache = new HashMap();
    public static final String[] HEX = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    static Class clazz = FwkIconFile.class;
    public static final String extension = ".gif";

    public String getVersion() {
        return version;
    }

    private static String getPath() {
        URL url = clazz.getClassLoader().getResource(clazz.getName().replace('.', '/') + ".class");
        if (url != null) {
            String path = url.toString();
            int index = path.lastIndexOf(47);
            return path.substring(0, index);
        }
        return null;
    }

    public static URL getURL(String path) {
        ClassLoader cl;
        URL ret = null;
        try {
            URL url = new URL(path);
            try {
                InputStream infile = url.openStream();
                infile.close();
                ret = url;
            }
            catch (Exception exception) {}
        }
        catch (Exception e1) {
            // empty catch block
        }
        if (ret == null && !path.startsWith("file:") && (cl = FwkIconFile.class.getClassLoader()) != null) {
            ret = cl.getResource(path);
        }
        if (ret == null) {
            ret = ClassLoader.getSystemResource(path);
        }
        return ret;
    }

    public static FwkIconInterface getIcon(String key) {
        FwkIconInterface ret = null;
        if (key == null) {
            return ret;
        }
        ret = (FwkIconInterface)iconCache.get(key);
        if (ret != null) {
            return ret;
        }
        if (iconNotFoundCache.get(key) != null) {
            return null;
        }
        String spec = FwkPropertyBus.getProperty(key);
        if (spec.compareTo(key) == 0) {
            block24: {
                try {
                    FileInputStream fis = new FileInputStream(spec);
                    fis.close();
                    ret = new FwkIcon(spec);
                }
                catch (Throwable t) {
                    URL url = FwkIconFile.getURL(spec);
                    if (url == null) break block24;
                    ret = new FwkIcon(url);
                }
            }
            if (ret == null) {
                String fName;
                int index = key.indexOf(46);
                if (index == -1) {
                    fName = key + extension;
                } else {
                    fName = key.substring(index + 1);
                    if (fName.indexOf(46) == -1) {
                        fName = fName + extension;
                    }
                }
                String path = FwkPropertyBus.getProperty("Icon.Path");
                URL url = null;
                if (path.compareTo("Icon.Path") == 0) {
                    path = FwkIconFile.getPath();
                    url = FwkIconFile.getURL(path + '/' + fName);
                    if (url != null) {
                        ret = new FwkIcon(url);
                    }
                } else {
                    url = FwkIconFile.getURL(path + '/' + fName);
                    if (url == null) {
                        path = FwkIconFile.getPath();
                        url = FwkIconFile.getURL(path + '/' + fName);
                        if (url != null) {
                            ret = new FwkIcon(url);
                        }
                    } else {
                        ret = new FwkIcon(url);
                    }
                }
                if (url != null) {
                    ret = new FwkIcon(url);
                }
            }
        } else {
            File file = new File(spec);
            if (file.exists()) {
                ret = new FwkIcon(spec);
            } else {
                URL url = FwkIconFile.getURL(spec);
                if (url != null) {
                    ret = new FwkIcon(url);
                }
            }
            if (ret == null) {
                return FwkIconFile.getIcon(spec);
            }
        }
        if (ret != null) {
            iconCache.put(key, ret);
        } else {
            iconNotFoundCache.put(key, key);
        }
        return ret;
    }

    public static FwkIconInterface getIcon(ClassLoader loader, String key) {
        if (loader == null) {
            loader = FwkIconFile.class.getClassLoader();
        }
        FwkIconInterface ret = null;
        ret = (FwkIconInterface)iconCache.get(key);
        if (ret != null) {
            return ret;
        }
        if (iconNotFoundCache.get(key) != null) {
            return null;
        }
        String res = FwkPropertyBus.getProperty(key);
        try {
            ret = new FwkIcon(loader.getResource(res));
            if (ret.getImage() == null) {
                ret = null;
            }
        }
        catch (Throwable t) {
            ret = null;
        }
        if (ret == null) {
            try {
                ret = new FwkIcon(new URL(res));
                if (ret.getImage() == null) {
                    ret = null;
                }
            }
            catch (Throwable t) {
                ret = null;
            }
            if (ret == null) {
                try {
                    File file = new File(res);
                    if (file.exists() && (ret = new FwkIcon(res)).getImage() == null) {
                        ret = null;
                    }
                }
                catch (Throwable t) {
                    ret = null;
                }
            }
        }
        if (ret != null) {
            iconCache.put(key, ret);
        } else {
            iconNotFoundCache.put(key, key);
        }
        return ret;
    }

    public static FwkIconInterface getIcon(byte[] arr) {
        return new FwkIcon(arr);
    }

    public static void dumpIcon(String key, String sep) {
        if (sep == null) {
            sep = "\r";
        }
        String sp = " ";
        if (sep.length() == 0) {
            sp = "";
        }
        InputStream is = null;
        String spec = FwkPropertyBus.getProperty(key);
        if (spec.compareTo(key) == 0) {
            String fName;
            int index = key.indexOf(46);
            if (index == -1) {
                fName = key + extension;
            } else {
                fName = key.substring(index + 1);
                if (fName.indexOf(46) == -1) {
                    fName = fName + extension;
                }
            }
            String path = FwkPropertyBus.getProperty("Icon.Path");
            URL url = null;
            if (path.compareTo("Icon.Path") == 0) {
                path = FwkIconFile.getPath();
                url = FwkIconFile.getURL(path + '/' + fName);
            } else {
                url = FwkIconFile.getURL(path + '/' + fName);
                if (url == null) {
                    path = FwkIconFile.getPath();
                    url = FwkIconFile.getURL(path + '/' + fName);
                }
            }
            try {
                is = url.openStream();
            }
            catch (Throwable t) {}
        } else {
            try {
                is = new FileInputStream(spec);
            }
            catch (Throwable t) {
                URL url = FwkIconFile.getURL(spec);
                try {
                    is = url.openStream();
                }
                catch (Throwable t1) {
                    // empty catch block
                }
            }
        }
        try {
            int size = is.available();
            if (size > 0) {
                byte[] data = new byte[size];
                is.read(data, 0, size);
                is.close();
                System.out.print("static byte[] " + key.toUpperCase() + "_ICON = {");
                for (int i = 0; i < size - 1; ++i) {
                    if (i % 16 == 0) {
                        System.out.print(sep);
                    }
                    byte val = data[i];
                    System.out.print(sp);
                    if (val >= 0) {
                        System.out.print(sp);
                    }
                    if (val > -100 && val < 100) {
                        System.out.print(sp);
                        if (val > -10 && val < 10) {
                            System.out.print(sp);
                        }
                    }
                    System.out.print(val + ",");
                }
                byte val = data[size - 1];
                System.out.print(sp);
                if (val >= 0) {
                    System.out.print(sp);
                }
                if (val > -100 && val < 100) {
                    System.out.print(sp);
                    if (val > -10 && val < 10) {
                        System.out.print(sp);
                    }
                }
                System.out.print(val);
                System.out.println("};");
            }
        }
        catch (Throwable t2) {
            System.out.println("unable to dump icon for key <" + key + ">");
        }
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        String key = FwkPropertyBus.getProperty("IMAGE_KEY");
        if (key.compareTo("IMAGE_KEY") == 0) {
            System.out.println("This program dumps icon files to stdout.");
            System.out.println("Use the property keyword IMAGE_KEY to specifiy the image keyword.");
            System.out.println("   Usage: java com.highqsoft.fwk.images.FwkIconFile -IMAGE_KEY AoUnit");
            System.out.println("   additional keyword:");
            System.out.println("      -ONE_LINE Dumps the icon in one single line.");
            System.out.println("      -DOS_LINE Dumps the icon with DOS line separators.");
            System.out.println("   additional keyword:");
        } else {
            String sep = "\r";
            String sepType = FwkPropertyBus.getProperty("ONE_LINE");
            if (sepType.compareTo("ONE_LINE") == 0) {
                sepType = FwkPropertyBus.getProperty("DOS_LINE");
                if (sepType.compareTo("DOS_LINE") != 0) {
                    sep = "\n";
                }
            } else {
                sep = "";
            }
            FwkIconFile.dumpIcon(key, sep);
            FwkIconFile.dumpIcon(key + "_bg", sep);
            FwkIconFile.dumpIcon(key + "_large", sep);
            FwkIconFile.dumpIcon(key + "_bg_large", sep);
        }
        System.out.println("\n--> IconFile now exiting.");
        System.exit(0);
    }
}

