/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.listener;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.listener.FwkListener;
import com.highqsoft.interfaces.fwk.FwkCommandActionInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class FwkAboutActionListener
extends FwkListener
implements FwkCommandActionInterface,
ActionListener {
    public static final String version = "$Revision: 1.4 $";
    static FwkAboutActionListener singleInstance;
    protected JDialog dialog = null;

    public String getVersion() {
        return version;
    }

    private FwkAboutActionListener() {
    }

    public static synchronized FwkListener getInstance() {
        if (singleInstance == null) {
            singleInstance = new FwkAboutActionListener();
        }
        return singleInstance;
    }

    public void actionPerformed(FwkCommandInterface cmd) {
        FwkControllerInterface fb = null;
        try {
            fb = cmd.getController();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.createDialog(fb);
    }

    public void actionPerformed(ActionEvent ev) {
        Object fb = null;
        try {
            fb = FwkContainer.getController((JComponent)ev.getSource());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.createDialog(fb);
    }

    protected void createDialog(Object fb) {
        Component parent = null;
        FwkDescriptionInterface description = null;
        if (fb != null) {
            try {
                parent = (Component)fb;
            }
            catch (Throwable cp) {
                // empty catch block
            }
            try {
                description = (FwkDescriptionInterface)fb;
            }
            catch (Throwable des) {
                // empty catch block
            }
        }
        if (description != null) {
            this.showOptionDialog(parent, description, FwkPropertyBus.getProperty("About.Text.GUI_Title"));
        } else {
            System.err.println("FwkAboutActionListener.actionPerformed Controller description of component not found.");
        }
    }

    protected void showOptionDialog(Component parentComponent, FwkDescriptionInterface description, String title) {
        Frame frame = JOptionPane.getFrameForComponent(parentComponent);
        this.dialog = new JDialog(frame, title, true);
        JPanel panel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(20);
        borderLayout.setVgap(20);
        panel.setLayout(borderLayout);
        this.dialog.getContentPane().add(panel);
        FwkIconInterface icon = description.getIcon();
        if (icon != null) {
            panel.add("West", new JLabel(icon));
        }
        JPanel labelPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(11, 1);
        gridLayout.setVgap(5);
        labelPanel.setLayout(gridLayout);
        panel.add("Center", labelPanel);
        panel.add("North", this.getLabel(description.getTitle(), 1, 18, true));
        labelPanel.add(this.getLabel(description.getDescription(), 1, 16, false));
        labelPanel.add(this.getLabel(description.getName(), 1, 16, false));
        labelPanel.add(this.getLabel(description.getCompany(), 1, 16, true));
        labelPanel.add(this.getLabel(description.getCompanyInternetAddress(), 0, 16, false));
        labelPanel.add(this.getLabel(description.getSupportEMail(), 0, 16, false));
        labelPanel.add(this.getLabel(description.getCopyright(), 0, 16, false));
        labelPanel.add(this.getLabel("Version " + description.getBuild(), 0, 16, false));
        labelPanel.add(this.getLabel(description.getCreationDate(), 0, 16, false));
        labelPanel.add(this.getLabel(description.getAuthor(), 0, 16, false));
        labelPanel.add(this.getLabel("", 0, 16, false));
        labelPanel.add(this.getLabel("Java Version " + FwkContainer.getSystemProperty("java.version", "???"), 0, 16, false));
        JButton ok = new JButton(FwkPropertyBus.getProperty("Text.Ok"));
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FwkAboutActionListener.this.dialog.dispose();
                FwkAboutActionListener.this.dialog = null;
            }
        });
        panel.add("South", ok);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parentComponent);
        this.dialog.setVisible(true);
    }

    protected JLabel getLabel(String text, int style, int size, boolean border) {
        JLabel label = new JLabel(text);
        Font f = label.getFont();
        Font font = new Font(f.getName(), style, size);
        label.setFont(font);
        Color col = label.getBackground();
        label.setHorizontalAlignment(0);
        if (border) {
            label.setBorder(BorderFactory.createBevelBorder(1, col.darker(), col.brighter()));
        }
        return label;
    }
}

