/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.listener;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.dialog.FwkColorDialogPane;
import com.highqsoft.fwk.dialog.FwkColorDialogPaneValue;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.fwk.listener.FwkListener;
import com.highqsoft.interfaces.fwk.FwkCommandActionInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.JComponent;

public class FwkColorActionListener
extends FwkListener
implements FwkCommandActionInterface,
ActionListener {
    public static final String version = "$Revision: 1.3 $";
    private static FwkColorActionListener singleInstance = null;

    public String getVersion() {
        return version;
    }

    private FwkColorActionListener() {
    }

    public static FwkColorActionListener getInstance() {
        if (singleInstance == null) {
            singleInstance = new FwkColorActionListener();
        }
        return singleInstance;
    }

    public void actionPerformed(FwkCommandInterface cmd) {
        this.selectColor(cmd.getController(), cmd.getCommandName());
    }

    public void actionPerformed(ActionEvent ev) {
        this.selectColor(FwkContainer.getController((JComponent)ev.getSource()), ev.getActionCommand());
    }

    public void selectColor(Object controller, String methodName) {
        FwkDialogPaneValueInterface val;
        Method method;
        Color initialColor = null;
        Float initialTransparency = new Float(0.0f);
        Class<?> clazz = controller.getClass();
        Object[] o = new Object[1];
        String transparencyMethod = "Transparency";
        int index = methodName.indexOf("Color");
        if (index > 0) {
            transparencyMethod = methodName.substring(0, index) + "Transparency" + methodName.substring(index + 5);
        }
        try {
            method = clazz.getMethod("get" + methodName, null);
            o[0] = method.invoke(controller, null);
            if (o[0] instanceof Color) {
                initialColor = (Color)o[0];
            }
        }
        catch (Throwable t) {
            FwkContainer.showErrorMessage(null, null, t);
        }
        try {
            method = clazz.getMethod("get" + transparencyMethod, null);
            o[0] = method.invoke(controller, null);
            if (o[0] instanceof Float) {
                initialTransparency = (Float)o[0];
            }
        }
        catch (Throwable t) {
            FwkContainer.showErrorMessage(null, null, t);
        }
        FwkColorDialogPane pane = new FwkColorDialogPane();
        if (initialColor != null) {
            FwkColorDialogPaneValue cVal = new FwkColorDialogPaneValue();
            cVal.setColor(initialColor);
            cVal.setTransparency(initialTransparency);
            pane.setSelectedValue(cVal);
        }
        if ((val = FwkDialogFactory.showDialog(null, "FwkColorActionListener.Text.DialogTitle", "", pane)) != null) {
            Method method2;
            FwkColorDialogPaneValue cVal = (FwkColorDialogPaneValue)val;
            Color color = cVal.getColor();
            Float transparency = cVal.getTransparency();
            try {
                method2 = clazz.getMethod("set" + methodName, Color.class);
                o[0] = color;
                method2.invoke(controller, o);
            }
            catch (Throwable t) {
                FwkContainer.showErrorMessage(null, null, t);
            }
            try {
                method2 = clazz.getMethod("set" + transparencyMethod, Float.TYPE);
                o[0] = transparency;
                method2.invoke(controller, o);
            }
            catch (Throwable t) {
                FwkContainer.showErrorMessage(null, null, t);
            }
        }
    }
}

