/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.listener;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.listener.FwkListener;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkCommandActionInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class FwkExitActionListener
extends FwkListener
implements FwkCommandActionInterface,
ActionListener {
    public static final String version = "$Revision: 1.4 $";
    static FwkExitActionListener singleInstance;

    public String getVersion() {
        return version;
    }

    private FwkExitActionListener() {
    }

    public static synchronized FwkListener getInstance() {
        if (singleInstance == null) {
            singleInstance = new FwkExitActionListener();
        }
        return singleInstance;
    }

    public void actionPerformed(FwkCommandInterface cmd) {
        if (cmd == null) {
            return;
        }
        FwkApplicationInterface application = (FwkApplicationInterface)cmd.getController();
        this.exitApplication(application);
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev == null) {
            return;
        }
        FwkApplicationInterface application = FwkContainer.getApplication(ev);
        this.exitApplication(application);
    }

    public void exitApplication(FwkApplicationInterface application) {
        boolean reallyExit = true;
        if (application != null) {
            if (!application.isEternal() && FwkContainer.getModifications() > 0) {
                String dialogMessage;
                String dialogTitle;
                Object[] options = new String[]{FwkPropertyBus.getProperty("Text.Yes"), FwkPropertyBus.getProperty("Text.No"), FwkPropertyBus.getProperty("Text.Cancel")};
                if (options[0] == null) {
                    options[0] = "Yes";
                }
                if (options[1] == null) {
                    options[1] = "No";
                }
                if (options[2] == null) {
                    options[2] = "Cancel";
                }
                if ((dialogTitle = FwkPropertyBus.getProperty("FwkExitActionListener.Text.DialogTitle")) == null) {
                    dialogTitle = "Save to BML file";
                }
                if ((dialogMessage = FwkPropertyBus.getProperty("FwkExitActionListener.Text.DialogMessage")) == null) {
                    dialogMessage = "Save changes ?";
                }
                JOptionPane optionPane = new JOptionPane();
                optionPane.setOptions(options);
                optionPane.setMessage(dialogMessage);
                optionPane.setMessageType(3);
                JDialog dialog = optionPane.createDialog((Component)((Object)application), dialogTitle);
                dialog.setVisible(true);
                Object result = optionPane.getValue();
                if (result != null) {
                    if (((String)options[0]).compareTo((String)result) == 0) {
                        FwkContainer.debug(5, "BML file ignored (not yet supported): " + application.getName() + ".bml");
                    } else if (((String)options[2]).compareTo((String)result) == 0) {
                        reallyExit = false;
                    }
                }
            }
            if (reallyExit) {
                application.exit();
            }
        }
    }
}

