/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.listener;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.listener.FwkListener;
import com.highqsoft.fwk.util.StringFormat;
import com.highqsoft.interfaces.fwk.FwkHelpBrokerInterface;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.help.HelpSet;
import javax.help.Map;
import javax.swing.JComponent;

public class FwkHelpIDActionListener
extends FwkListener
implements ActionListener {
    public static final String version = "$Revision: 1.3 $";
    private FwkHelpBrokerInterface hb;

    public String getVersion() {
        return version;
    }

    public FwkHelpIDActionListener(FwkHelpBrokerInterface hb) {
        if (hb == null) {
            throw new NullPointerException("hb");
        }
        this.hb = hb;
    }

    public void actionPerformed(ActionEvent e) {
        String helpID = null;
        HelpSet hs = null;
        JComponent comp = (JComponent)e.getSource();
        helpID = FwkContainer.getHelpIDString(comp);
        hs = FwkContainer.getHelpSet(comp);
        if (hs == null) {
            hs = this.hb.getHelpSet();
        }
        try {
            Map.ID id = null;
            if (helpID != null) {
                try {
                    id = Map.ID.create((String)helpID, (HelpSet)hs);
                }
                catch (Throwable tId) {
                    if (FwkContainer.getDebugLevel() > 0) {
                        System.err.println("Help id <" + helpID + "> not found in helpset.");
                        FwkContainer.showErrorMessage(FwkPropertyBus.getProperty("HelpSet.Error.Title", "HelpSet Error"), StringFormat.printf(FwkPropertyBus.getProperty("FwkHelpIDActionListener.ErrorHelpID.Text", "Cannot find HelpSet entry <%s>"), helpID), tId);
                    }
                    FwkContainer.showErrorMessage(FwkPropertyBus.getProperty("HelpSet.Error.Title", "HelpSet Error"), StringFormat.printf(FwkPropertyBus.getProperty("FwkHelpIDActionListener.ErrorHelpID.Text", "Cannot find HelpSet entry <%s>"), helpID), (Throwable)null);
                }
            }
            if (id == null) {
                id = hs.getHomeID();
            }
            this.hb.setCurrentID(id);
            this.hb.setDisplayed(true);
        }
        catch (Throwable throwable) {
            FwkContainer.showErrorMessage("FWK Error", "HelpIDActionListener could not find the following help ID:\n" + helpID, throwable);
        }
    }
}

