/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CheckList
extends JList {
    protected static Color MAROON = new Color(0.6901961f, 0.1882353f, 0.3764706f, 1.0f);
    private static final String uiClassID = "CheckListUI";
    static /* synthetic */ Class class$javax$swing$event$ListSelectionListener;

    public CheckList() {
        this.setCellRenderer(new MultiSelectionRenderer());
        this.setSelectionModel(new CheckListSelectionModel());
    }

    public CheckList(ListModel dataModel) {
        super(dataModel);
        this.setSelectionModel(new CheckListSelectionModel());
        this.setCellRenderer(new MultiSelectionRenderer());
    }

    public CheckList(Object[] listData) {
        super(listData);
        this.setSelectionModel(new CheckListSelectionModel());
        this.setCellRenderer(new MultiSelectionRenderer());
    }

    public CheckList(Vector listData) {
        super(listData);
        this.setSelectionModel(new CheckListSelectionModel());
        this.setCellRenderer(new MultiSelectionRenderer());
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void invert() {
        int[] sel = this.getSelectedIndices();
        this.setSelectionInterval(0, this.getModel().getSize() - 1);
        int size = sel.length;
        for (int i = 0; i < size; ++i) {
            this.removeSelectionInterval(sel[i], sel[i]);
        }
    }

    public void removeAll() {
        this.removeSelectionInterval(this.getMinSelectionIndex(), this.getMaxSelectionIndex());
    }

    public void selectAll() {
        this.setSelectionInterval(0, this.getModel().getSize() - 1);
    }

    public void setSelectionMode(int selectionMode) {
        if (selectionMode == 0) {
            this.setCellRenderer(new SingleSelectionRenderer());
        } else {
            this.setCellRenderer(new MultiSelectionRenderer());
        }
        super.setSelectionMode(selectionMode);
    }

    public class CheckListSelectionModel
    implements ListSelectionModel,
    Cloneable,
    Serializable {
        private static final int MIN = -1;
        private static final int MAX = Integer.MAX_VALUE;
        private int selectionMode = 2;
        private int minIndex = Integer.MAX_VALUE;
        private int maxIndex = -1;
        private int anchorIndex = -1;
        private int leadIndex = -1;
        private int firstAdjustedIndex = Integer.MAX_VALUE;
        private int lastAdjustedIndex = -1;
        private boolean isAdjusting = false;
        private int firstChangedIndex = Integer.MAX_VALUE;
        private int lastChangedIndex = -1;
        private BitSet value = new BitSet(32);
        protected EventListenerList listenerList = new EventListenerList();
        protected boolean leadAnchorNotificationEnabled = true;

        public int getMinSelectionIndex() {
            return this.isSelectionEmpty() ? -1 : this.minIndex;
        }

        public int getMaxSelectionIndex() {
            return this.maxIndex;
        }

        public boolean getValueIsAdjusting() {
            return this.isAdjusting;
        }

        public int getSelectionMode() {
            return this.selectionMode;
        }

        public void setSelectionMode(int selectionMode) {
            switch (selectionMode) {
                case 0: 
                case 1: 
                case 2: {
                    this.selectionMode = selectionMode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid selectionMode");
                }
            }
        }

        public boolean isSelectedIndex(int index) {
            return index < this.minIndex || index > this.maxIndex ? false : this.value.get(index);
        }

        public boolean isSelectionEmpty() {
            return this.minIndex > this.maxIndex;
        }

        public void addListSelectionListener(ListSelectionListener l) {
            this.listenerList.add(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = CheckList.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, l);
        }

        public void removeListSelectionListener(ListSelectionListener l) {
            this.listenerList.remove(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = CheckList.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, l);
        }

        protected void fireValueChanged(boolean isAdjusting) {
            if (this.lastChangedIndex == -1) {
                return;
            }
            int oldFirstChangedIndex = this.firstChangedIndex;
            int oldLastChangedIndex = this.lastChangedIndex;
            this.firstChangedIndex = Integer.MAX_VALUE;
            this.lastChangedIndex = -1;
            this.fireValueChanged(oldFirstChangedIndex, oldLastChangedIndex, isAdjusting);
        }

        protected void fireValueChanged(int firstIndex, int lastIndex) {
            this.fireValueChanged(firstIndex, lastIndex, this.getValueIsAdjusting());
        }

        protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
            Object[] listeners = this.listenerList.getListenerList();
            ListSelectionEvent e = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$ListSelectionListener == null ? CheckList.class$("javax.swing.event.ListSelectionListener") : class$javax$swing$event$ListSelectionListener)) continue;
                if (e == null) {
                    e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
                }
                ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
            }
        }

        private void fireValueChanged() {
            if (this.lastAdjustedIndex == -1) {
                return;
            }
            if (this.getValueIsAdjusting()) {
                this.firstChangedIndex = Math.min(this.firstChangedIndex, this.firstAdjustedIndex);
                this.lastChangedIndex = Math.max(this.lastChangedIndex, this.lastAdjustedIndex);
            }
            int oldFirstAdjustedIndex = this.firstAdjustedIndex;
            int oldLastAdjustedIndex = this.lastAdjustedIndex;
            this.firstAdjustedIndex = Integer.MAX_VALUE;
            this.lastAdjustedIndex = -1;
            this.fireValueChanged(oldFirstAdjustedIndex, oldLastAdjustedIndex);
        }

        private void markAsDirty(int r) {
            this.firstAdjustedIndex = Math.min(this.firstAdjustedIndex, r);
            this.lastAdjustedIndex = Math.max(this.lastAdjustedIndex, r);
        }

        private void set(int r) {
            if (this.value.get(r)) {
                return;
            }
            this.value.set(r);
            this.markAsDirty(r);
            this.minIndex = Math.min(this.minIndex, r);
            this.maxIndex = Math.max(this.maxIndex, r);
        }

        private void clear(int r) {
            if (!this.value.get(r)) {
                return;
            }
            this.value.clear(r);
            this.markAsDirty(r);
            if (r == this.minIndex) {
                ++this.minIndex;
                while (this.minIndex <= this.maxIndex && !this.value.get(this.minIndex)) {
                    ++this.minIndex;
                }
            }
            if (r == this.maxIndex) {
                --this.maxIndex;
                while (this.minIndex <= this.maxIndex && !this.value.get(this.maxIndex)) {
                    --this.maxIndex;
                }
            }
            if (this.isSelectionEmpty()) {
                this.minIndex = Integer.MAX_VALUE;
                this.maxIndex = -1;
            }
        }

        public void setLeadAnchorNotificationEnabled(boolean flag) {
            this.leadAnchorNotificationEnabled = flag;
        }

        public boolean isLeadAnchorNotificationEnabled() {
            return this.leadAnchorNotificationEnabled;
        }

        private void updateLeadAnchorIndices(int anchorIndex, int leadIndex) {
            if (this.leadAnchorNotificationEnabled) {
                if (this.anchorIndex != anchorIndex) {
                    if (this.anchorIndex != -1) {
                        this.markAsDirty(this.anchorIndex);
                    }
                    this.markAsDirty(anchorIndex);
                }
                if (this.leadIndex != leadIndex) {
                    if (this.leadIndex != -1) {
                        this.markAsDirty(this.leadIndex);
                    }
                    this.markAsDirty(leadIndex);
                }
            }
            this.anchorIndex = anchorIndex;
            this.leadIndex = leadIndex;
        }

        private boolean contains(int a, int b, int i) {
            return i >= a && i <= b;
        }

        private void changeSelection(int clearMin, int clearMax, int setMin, int setMax, boolean clearFirst) {
            if (this.getSelectionMode() == 0) {
                for (int i = Math.min(setMin, clearMin); i <= Math.max(setMax, clearMax); ++i) {
                    if (this.contains(clearMin, clearMax, i) && !this.contains(setMin, setMax, i)) {
                        this.clear(i);
                    }
                    if (!this.contains(setMin, setMax, i)) continue;
                    if (this.value.get(i)) {
                        this.clear(i);
                        continue;
                    }
                    this.set(i);
                }
            } else if (setMin == setMax) {
                if (!this.value.get(setMin)) {
                    this.set(setMin);
                } else {
                    this.clear(setMin);
                }
            } else if (setMin == Integer.MAX_VALUE && setMax == -1) {
                for (int i = clearMin; i <= clearMax; ++i) {
                    this.clear(i);
                }
            } else {
                for (int i = setMin; i <= setMax; ++i) {
                    this.set(i);
                }
            }
            this.fireValueChanged();
        }

        private void changeSelection(int clearMin, int clearMax, int setMin, int setMax) {
            this.changeSelection(clearMin, clearMax, setMin, setMax, true);
        }

        public void clearSelection() {
            this.removeSelectionInterval(this.minIndex, this.maxIndex);
        }

        public void setSelectionInterval(int index0, int index1) {
            if (index0 == -1 || index1 == -1) {
                return;
            }
            if (this.getSelectionMode() == 0) {
                index0 = index1;
            }
            this.updateLeadAnchorIndices(index0, index1);
            int clearMin = this.minIndex;
            int clearMax = this.maxIndex;
            int setMin = Math.min(index0, index1);
            int setMax = Math.max(index0, index1);
            this.changeSelection(clearMin, clearMax, setMin, setMax);
        }

        public void addSelectionInterval(int index0, int index1) {
            if (index0 == -1 || index1 == -1) {
                return;
            }
            if (this.getSelectionMode() != 2) {
                this.setSelectionInterval(index0, index1);
                return;
            }
            this.updateLeadAnchorIndices(index0, index1);
            int clearMin = Integer.MAX_VALUE;
            int clearMax = -1;
            int setMin = Math.min(index0, index1);
            int setMax = Math.max(index0, index1);
            this.changeSelection(clearMin, clearMax, setMin, setMax);
        }

        public void removeSelectionInterval(int index0, int index1) {
            if (index0 == -1 || index1 == -1) {
                return;
            }
            this.updateLeadAnchorIndices(index0, index1);
            int clearMin = Math.min(index0, index1);
            int clearMax = Math.max(index0, index1);
            int setMin = Integer.MAX_VALUE;
            int setMax = -1;
            this.changeSelection(clearMin, clearMax, setMin, setMax);
        }

        private void setState(int index, boolean state) {
            if (state) {
                this.set(index);
            } else {
                this.clear(index);
            }
        }

        public void insertIndexInterval(int index, int length, boolean before) {
            int insMinIndex = before ? index : index + 1;
            int insMaxIndex = insMinIndex + length - 1;
            for (int i = this.maxIndex; i >= insMinIndex; --i) {
                this.setState(i + length, this.value.get(i));
            }
            boolean setInsertedValues = this.value.get(index);
            for (int i = insMinIndex; i <= insMaxIndex; ++i) {
                this.setState(i, setInsertedValues);
            }
        }

        public void removeIndexInterval(int index0, int index1) {
            int rmMinIndex = Math.min(index0, index1);
            int rmMaxIndex = Math.max(index0, index1);
            int gapLength = rmMaxIndex - rmMinIndex + 1;
            for (int i = rmMinIndex; i <= this.maxIndex; ++i) {
                this.setState(i, this.value.get(i + gapLength));
            }
        }

        public void setValueIsAdjusting(boolean isAdjusting) {
            if (isAdjusting != this.isAdjusting) {
                this.isAdjusting = isAdjusting;
                this.fireValueChanged(isAdjusting);
            }
        }

        public String toString() {
            String s = (this.getValueIsAdjusting() ? "~" : "=") + this.value.toString();
            return this.getClass().getName() + " " + Integer.toString(this.hashCode()) + " " + s;
        }

        public Object clone() throws CloneNotSupportedException {
            CheckListSelectionModel clone = (CheckListSelectionModel)super.clone();
            clone.value = (BitSet)this.value.clone();
            clone.listenerList = new EventListenerList();
            return clone;
        }

        public int getAnchorSelectionIndex() {
            return this.anchorIndex;
        }

        public int getLeadSelectionIndex() {
            return this.leadIndex;
        }

        public void setAnchorSelectionIndex(int anchorIndex) {
            this.updateLeadAnchorIndices(anchorIndex, this.leadIndex);
            this.anchorIndex = anchorIndex;
            this.fireValueChanged();
        }

        public void setLeadSelectionIndex(int leadIndex) {
            int anchorIndex = this.anchorIndex;
            if (this.getSelectionMode() == 0) {
                anchorIndex = leadIndex;
            }
            int oldMin = Math.min(this.anchorIndex, this.leadIndex);
            int oldMax = Math.max(this.anchorIndex, this.leadIndex);
            int newMin = Math.min(anchorIndex, leadIndex);
            int newMax = Math.max(anchorIndex, leadIndex);
            if (this.value.get(this.anchorIndex)) {
                this.changeSelection(oldMin, oldMax, newMin, newMax);
            } else {
                this.changeSelection(newMin, newMax, oldMin, oldMax, false);
            }
            this.anchorIndex = anchorIndex;
            this.leadIndex = leadIndex;
        }
    }

    class SingleSelectionRenderer
    extends JRadioButton
    implements ListCellRenderer {
        SingleSelectionRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String textValue = null;
            Color foreground = list.getForeground();
            if (value instanceof FwkColumnAccessInterface) {
                FwkColumnAccessInterface col = (FwkColumnAccessInterface)value;
                textValue = col.getShortName();
                if (col.isIndependent()) {
                    foreground = MAROON;
                }
            } else if (value instanceof FwkDescriptionInterface) {
                textValue = ((FwkDescriptionInterface)value).getName();
            } else {
                Method method = null;
                try {
                    method = value.getClass().getMethod("getName", null);
                }
                catch (Throwable t1) {
                    // empty catch block
                }
                if (method != null) {
                    try {
                        textValue = (String)method.invoke(value, null);
                    }
                    catch (Throwable t3) {}
                } else {
                    try {
                        method = value.getClass().getMethod("getProperty", null);
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    if (method != null) {
                        Object[] param = new Object[]{"Name"};
                        try {
                            textValue = (String)method.invoke(value, param);
                        }
                        catch (Throwable t4) {
                            // empty catch block
                        }
                    }
                }
            }
            if (textValue == null) {
                textValue = value.toString();
            }
            this.setText(textValue);
            this.setSelected(isSelected);
            this.setBackground(list.getBackground());
            this.setForeground(foreground);
            this.setEnabled(list.isEnabled());
            return this;
        }
    }

    class MultiSelectionRenderer
    extends JCheckBox
    implements ListCellRenderer {
        MultiSelectionRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String textValue = null;
            Color foreground = list.getForeground();
            if (value instanceof FwkColumnAccessInterface) {
                FwkColumnAccessInterface col = (FwkColumnAccessInterface)value;
                textValue = col.getShortName();
                if (col.isIndependent()) {
                    foreground = MAROON;
                }
            } else if (value instanceof FwkDescriptionInterface) {
                textValue = ((FwkDescriptionInterface)value).getName();
            } else {
                Method method = null;
                try {
                    method = value.getClass().getMethod("getName", null);
                }
                catch (Throwable t1) {
                    // empty catch block
                }
                if (method != null) {
                    try {
                        textValue = (String)method.invoke(value, null);
                    }
                    catch (Throwable t3) {}
                } else {
                    try {
                        method = value.getClass().getMethod("getProperty", null);
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    if (method != null) {
                        Object[] param = new Object[]{"Name"};
                        try {
                            textValue = (String)method.invoke(value, param);
                        }
                        catch (Throwable t4) {
                            // empty catch block
                        }
                    }
                }
            }
            if (textValue == null) {
                textValue = value.toString();
            }
            this.setText(textValue);
            this.setSelected(isSelected);
            this.setBackground(list.getBackground());
            this.setForeground(foreground);
            this.setEnabled(list.isEnabled());
            return this;
        }
    }
}

