/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import com.highqsoft.fwk.FwkChangeRegistry;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDOMHandler;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkXmlInterpreter;
import com.highqsoft.fwk.command.FwkAboutCommand;
import com.highqsoft.fwk.command.FwkDumpToXMLCommand;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.fwk.listener.FwkPopupMenuUnregisterListener;
import com.highqsoft.fwk.util.CommandContainerInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDOMHandlerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.interfaces.fwk.FwkPanelInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyGroupInterface;
import com.highqsoft.interfaces.fwk.FwkXmlDtdInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class CommandContainer
extends FwkCommand
implements CommandContainerInterface {
    protected FwkControllerInterface controller = null;
    protected Color color;
    protected String toolTipTextKey = "ToolTip.CommandContainer";
    protected String toolBarPosition = "West";
    protected int toolBarAlignment = 0;
    protected boolean readingDOM = false;
    public static final String version = "$Revision: 1.4 $";
    protected String author = "";
    protected String buildnr = "?.?";
    protected String company = "HighQSoft GmbH";
    protected String copyright = "COPYRIGHT \u00a9 HighQSoft GmbH 2000-" + FwkContainer.getYear();
    protected Date creationDate = new Date();
    protected String dateFormatString = "yyyy/MM/dd HH:mm:ss";
    protected String description = "Application Description";
    protected String eMail = "support@highqsoft.de";
    protected final int iconCount = 4;
    protected FwkIconInterface[] icon = new FwkIconInterface[4];
    protected String[] iconKey = new String[4];
    protected String internetAddress = "http://www.highqsoft.com";
    protected String titleName = "A HighQSoft Application";
    protected String name = "";

    public String getVersion() {
        return version;
    }

    public CommandContainer() {
        this.color = new Color(0.7529412f, 0.7529412f, 0.7529412f);
    }

    public CommandContainer(FwkControllerInterface controller) {
        this();
        this.controller = controller;
    }

    public void setController(FwkControllerInterface controller) {
        this.controller = controller;
    }

    public FwkControllerInterface getController() {
        return this.controller;
    }

    public Object readConstructor(Document document, Element node) {
        return FwkDOMHandler.readConstructor(this, document, node);
    }

    public void readFromDOM(Document doc, Element element) {
        this.readingDOM(true);
        try {
            FwkDOMHandler.readCommandsFromDOM(this, doc, element);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.readingDOM(false);
    }

    public Element writeConstructor(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        return FwkDOMHandler.writeConstructor(this, "Object", true, document, dtd, node, classProperties, false);
    }

    public Element writeToDOM(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        Element thisNode = this.writeConstructor(document, dtd, node, classProperties);
        FwkDOMHandler.writePropertiesToDOM(this, document, dtd, thisNode, classProperties);
        FwkDOMHandler.writeCommandsToDOM(this.getCommands(), document, dtd, thisNode, null);
        return thisNode;
    }

    public boolean writeToXML(String filename, boolean validate) {
        return FwkDOMHandler.writeToXML((FwkDOMHandlerInterface)this, filename, FwkXmlInterpreter.class, validate);
    }

    public void readingDOM(boolean flag) {
        this.readingDOM = flag;
    }

    public boolean readingDOM() {
        return this.readingDOM;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color old = this.color;
        this.color = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        this.firePropertyChange("Color", old, color);
        FwkChangeRegistry.register(this, "Color");
    }

    public void setToolTipTextKey(String key) {
        String old = this.toolTipTextKey;
        this.toolTipTextKey = key;
        this.firePropertyChange("ToolTipTextKey", old, key);
        FwkChangeRegistry.register(this, "ToolTipTextKey");
    }

    public String getToolTipTextKey() {
        return this.toolTipTextKey;
    }

    public String getToolTipText() {
        return FwkPropertyBus.getProperty(this.toolTipTextKey);
    }

    public FwkCommandInterface[] getCommands() {
        FwkCommandInterface[] ret = super.getCommands();
        if (ret == null || ret.length == 0) {
            this.setDefaultCommands();
            ret = super.getCommands();
            if (ret == null || ret.length == 0) {
                ret = new FwkCommandInterface[]{new NotYetImplemented()};
                return ret;
            }
        }
        return ret;
    }

    protected FwkCommandInterface createCommand(String className) {
        FwkCommandInterface ret = null;
        if (className == null || className.length() == 0 || className.toUpperCase().equals("NULL")) {
            return null;
        }
        Class<?> clazz = null;
        ret = this.getContainerCommand(className);
        if (ret == null) {
            clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (Throwable tClass) {
                new FwkException(-1073676289, "$RCSfile: CommandContainer.java,v $", this.getVersion(), "AH 2002-02-05 10:12", "Failed to load class <" + className + ">", this, tClass);
                FwkContainer.debug(1, "Failed to load class <" + className + ">");
            }
            if (clazz != null) {
                try {
                    ret = (FwkCommandInterface)clazz.newInstance();
                }
                catch (Throwable tInstance) {
                    new FwkException(-1073676289, "$RCSfile: CommandContainer.java,v $", this.getVersion(), "AH 2002-02-05 10:12", "Failed to get an instance of class <" + className + ">", this, tInstance);
                    FwkContainer.debug(1, "Failed to get an instance of class <" + className + ">");
                }
            }
        }
        return ret;
    }

    protected FwkCommandInterface getContainerCommand(String className) {
        return null;
    }

    public void setToolBarPosition(String position) {
        String old = this.toolBarPosition;
        this.toolBarPosition = position;
        this.firePropertyChange("ToolBarPosition", old, position);
        FwkChangeRegistry.register(this, "ToolBarPosition");
    }

    public String getToolBarPosition() {
        return this.toolBarPosition;
    }

    public void setToolBarAlignment(int alignment) {
        int old = alignment;
        this.toolBarAlignment = alignment;
        this.firePropertyChange("ToolBarAlignment", old, alignment);
        FwkChangeRegistry.register(this, "ToolBarAlignment");
    }

    public int getToolBarAlignment() {
        return this.toolBarAlignment;
    }

    public JToolBar addToolBar(FwkPanelInterface panel, String position, int alignment) {
        JToolBar toolBar = FwkGUIFactory.createToolBar(new FwkCommand[]{this}, position, alignment);
        if (toolBar != null) {
            toolBar.setName(this.getToolTipText());
            toolBar.setToolTipText(this.getToolTipText());
            toolBar.setBackground(this.getColor());
            toolBar.addMouseListener(new ToolBarMouseListener());
            int nComponents = toolBar.getComponentCount();
            if (nComponents != 0) {
                for (int i = 0; i < nComponents; ++i) {
                    Component c = toolBar.getComponent(i);
                    c.setBackground(this.getColor());
                }
            }
            ((JPanel)((Object)panel)).add(position, toolBar);
        }
        return toolBar;
    }

    public JToolBar addToolBar(FwkPanelInterface panel) {
        return this.addToolBar(panel, this.toolBarPosition, this.toolBarAlignment);
    }

    public String getAuthor() {
        return this.author;
    }

    public String getBuild() {
        return this.buildnr;
    }

    public String getCompany() {
        return this.company;
    }

    public String getCompanyInternetAddress() {
        return this.internetAddress;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getCreationDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.dateFormatString);
        try {
            return simpleDateFormat.format(this.creationDate);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public String getCreationDate(String formatString) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatString);
        return simpleDateFormat.format(this.creationDate);
    }

    public String getDateFormatString() {
        return this.dateFormatString;
    }

    public String getDescription() {
        return this.description;
    }

    public FwkIconInterface getIcon() {
        return this.getIcon(0);
    }

    public FwkIconInterface getIcon(int type) {
        FwkIconInterface ret = null;
        if (type >= 0 && type < 4) {
            if (this.icon[type] == null) {
                this.icon[type] = FwkIconFile.getIcon(this.getIconKey(type));
                if (this.icon[type] == null) {
                    this.icon[type] = FwkDescription.ICON[type];
                }
            }
            ret = this.icon[type];
        }
        if (ret == null && type != 0) {
            ret = this.getIcon(0);
        }
        return ret;
    }

    public String getIconKey() {
        return this.getIconKey(0);
    }

    public String getIconKey(int type) {
        if (type >= 0 && type < 4) {
            return this.iconKey[type];
        }
        return this.iconKey[0];
    }

    public String getName() {
        return this.name.length() == 0 ? this.getClass().getName() + " [Revision: " + FwkDescription.getNiceVersion(version) + "]" : this.name;
    }

    public String getPresentationString(Locale locale) {
        return this.getClass().getName() + " [Revision: " + FwkContainer.getNiceVersion(version) + "]";
    }

    public String getPresentationString() {
        return this.getPresentationString(FwkContainer.getLocale());
    }

    public String getSupportEMail() {
        return this.eMail;
    }

    public String getTitle() {
        int pos;
        String title = FwkPropertyBus.getProperty(this.titleName);
        String name = this.getName();
        if (name != null && (pos = name.lastIndexOf("_")) > 0) {
            title = title + " (" + name.substring(pos + 1) + ")";
        }
        return title;
    }

    public String getTitleName() {
        return this.titleName;
    }

    public void setAuthor(String author) {
        String old = this.author;
        this.author = author;
        this.firePropertyChange("Author", old, author);
        FwkChangeRegistry.register(this, "Author");
    }

    public void setBuild(String buildnr) {
        String old = this.buildnr;
        if (buildnr != null && buildnr.length() > 0 && buildnr.indexOf(36) != -1) {
            this.buildnr = "0.0";
            StringTokenizer st = new StringTokenizer(buildnr, "$ ");
            while (st.hasMoreTokens()) {
                this.buildnr = st.nextToken();
            }
        } else {
            this.buildnr = buildnr;
        }
        this.firePropertyChange("Build", old, buildnr);
        FwkChangeRegistry.register(this, "Build");
    }

    public void setCompany(String company) {
        String old = this.company;
        this.company = company;
        this.firePropertyChange("Company", old, company);
        FwkChangeRegistry.register(this, "Company");
    }

    public void setCompanyInternetAddress(String address) {
        String old = this.internetAddress;
        this.internetAddress = address;
        this.firePropertyChange("CompanyInternetAddress", old, address);
        FwkChangeRegistry.register(this, "CompanyInternetAddress");
    }

    public void setCopyright(String copyright) {
        String old = this.copyright;
        this.copyright = copyright;
        this.firePropertyChange("Copyright", old, copyright);
        FwkChangeRegistry.register(this, "Copyright");
    }

    public void setCreationDate(String dateString, String formatString) {
        if (formatString == null) {
            formatString = "'$Date: 'yyyy/MM/dd HH:mm:ss '$'";
            this.dateFormatString = "yyyy/MM/dd HH:mm:ss";
        } else {
            this.dateFormatString = formatString;
        }
        ParsePosition p = new ParsePosition(0);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatString);
        Date old = this.creationDate;
        try {
            this.creationDate = simpleDateFormat.parse(dateString, p);
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.firePropertyChange("CreationDate", old, this.creationDate);
        FwkChangeRegistry.register(this, "CreationDate");
    }

    public void setCreationDate(String dateString) {
        this.setCreationDate(dateString, null);
    }

    public void setDateFormatString(String formatString) {
        String old = this.dateFormatString;
        this.dateFormatString = formatString;
        this.firePropertyChange("DateFormatString", old, formatString);
        FwkChangeRegistry.register(this, "DateFormatString");
    }

    public void setDescription(String description) {
        String old = this.description;
        this.description = description;
        this.firePropertyChange("Description", old, description);
        FwkChangeRegistry.register(this, "Description");
    }

    public void setDescriptor(FwkDescriptionInterface descriptor) throws FwkException {
        this.setAuthor(descriptor.getAuthor());
        this.setBuild(descriptor.getBuild());
        this.setCompany(descriptor.getCompany());
        this.setCompanyInternetAddress(descriptor.getCompanyInternetAddress());
        this.setCopyright(descriptor.getCopyright());
        this.setCreationDate(descriptor.getCreationDate(), descriptor.getDateFormatString());
        this.setDateFormatString(descriptor.getDateFormatString());
        this.setDescription(descriptor.getDescription());
        this.setIcon(descriptor.getIcon());
        String key = descriptor.getIconKey();
        if (key != null) {
            this.setIconKey(descriptor.getIconKey());
        }
        this.setName(descriptor.getName());
        this.setSupportEMail(descriptor.getSupportEMail());
        this.setTitleName(descriptor.getTitleName());
    }

    public void setIcon(FwkIconInterface icon) {
        this.setIcon(icon, 0);
    }

    public void setIcon(FwkIconInterface icon, int type) {
        if (type >= 0 && type < 4) {
            this.icon[type] = icon;
        }
    }

    public void setIconKey(String key) {
        this.setIconKey(key, 0);
    }

    public void setIconKey(String key, int type) {
        if (type >= 0 && type < 4) {
            String old = this.iconKey[type];
            this.iconKey[type] = key;
            FwkIconInterface i = FwkIconFile.getIcon(key);
            if (i != null) {
                this.setIcon(i, type);
            }
            if (type == 0) {
                this.setIconKey(key + "_bg", 1);
                this.setIconKey(key + "_large", 2);
                this.setIconKey(key + "_bg_large", 3);
            }
            this.firePropertyChange("IconKey", old, key);
            FwkChangeRegistry.register(this, "IconKey");
        }
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChange("Name", old, name);
        FwkChangeRegistry.register(this, "Name");
    }

    public void setSupportEMail(String eMail) {
        String old = this.eMail;
        this.eMail = eMail;
        this.firePropertyChange("SupportEMail", old, eMail);
        FwkChangeRegistry.register(this, "SupportEMail");
    }

    public void setTitleName(String titleName) {
        String old = this.titleName;
        this.titleName = titleName;
        this.firePropertyChange("TitleName", old, titleName);
        FwkChangeRegistry.register(this, "TitleName");
    }

    public String toString() {
        return "Title:         " + this.getTitle() + "\n" + "Title Name:    " + this.getTitleName() + "\n" + "Description:   " + this.getDescription() + "\n" + "Name:          " + this.getName() + "\n" + "Company:       " + this.getCompany() + "\n" + "Internet:      " + this.getCompanyInternetAddress() + "\n" + "Support:       " + this.getSupportEMail() + "\n" + "Copyright:     " + this.getCopyright() + "\n" + "Build Number:  " + this.getBuild() + "\n" + "Creation Date: " + (this.creationDate != null ? this.getCreationDate() : "") + "\n" + "Author:        " + this.getAuthor();
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] ret = new DataFlavor[]{DataFlavor.stringFlavor};
        return ret;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DataFlavor.stringFlavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return this.getPresentationString();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setDefaultCommands() {
        FwkPropertyGroupInterface group = FwkPropertyBus.getPropertyGroup(this.getPropertyGroupName());
        if (group != null) {
            Iterator it = group.keySet().iterator();
            while (it.hasNext()) {
                FwkCommandInterface cmd = this.createCommand(group.getProperty((String)it.next(), "null"));
                if (cmd == null) continue;
                cmd.setController(this.getController());
                this.addCommand(cmd);
            }
        }
    }

    public abstract String getPropertyGroupName();

    public boolean destroyController() {
        return true;
    }

    public class ToolBarMouseListener
    extends MouseAdapter {
        public void mouseReleased(MouseEvent e) {
            JPopupMenu popup;
            if (e.getClickCount() == 1 && e.getModifiers() == 4 && (popup = FwkGUIFactory.createPopupMenu(CommandContainer.this.getTitleName(), new FwkCommand[]{new FwkDumpToXMLCommand(CommandContainer.this), new FwkAboutCommand(CommandContainer.this)}, false)) != null) {
                popup.addPopupMenuListener(FwkPopupMenuUnregisterListener.getInstance());
                popup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    class NotYetImplemented
    extends FwkCommand {
        public NotYetImplemented() {
            this.setIconKey("Icon.Info");
        }

        public boolean execute(EventObject ev) {
            FwkContainer.showErrorMessage(FwkPropertyBus.getProperty("Text.NotYetImplemented"), FwkPropertyBus.getProperty("Text.NoCommands"), (String)null);
            return true;
        }
    }
}

