/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import com.highqsoft.fwk.Fwk;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class FileUtilities {
    private static Object loadedObject = new Fwk();

    protected static ClassLoader getClassLoader(Class clazz) {
        if (clazz == null) {
            clazz = loadedObject.getClass();
        }
        final Class<?> constClass = clazz;
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return constClass.getClassLoader();
            }
        });
    }

    protected static ClassLoader getClassLoader(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return FileUtilities.getClassLoader(clazz);
    }

    public static OutputStream getOutputStream(String spec) {
        return FileUtilities.getOutputStream(spec, FileUtilities.getClassLoader((Class)null));
    }

    public static OutputStream getOutputStream(String spec, String className) {
        return FileUtilities.getOutputStream(spec, FileUtilities.getClassLoader(className));
    }

    public static OutputStream getOutputStream(String spec, ClassLoader classLoader) {
        String filename;
        OutputStream ret;
        block12: {
            final String fn = spec;
            if (classLoader == null) {
                classLoader = FileUtilities.getClassLoader((Class)null);
            }
            final ClassLoader cl = classLoader;
            URL url = null;
            if (cl != null) {
                url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return cl.getResource(fn);
                    }
                });
            }
            if (url == null) {
                url = loadedObject.getClass().getResource(fn);
            }
            if (url == null) {
                try {
                    url = new URL(fn);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            ret = null;
            filename = fn;
            if (url != null) {
                try {
                    ret = url.openConnection().getOutputStream();
                }
                catch (Throwable t) {
                    if (url.getProtocol().compareToIgnoreCase("file") != 0) break block12;
                    filename = url.getPath().substring(1);
                }
            }
        }
        if (ret == null) {
            try {
                ret = new FileOutputStream(FileUtilities.getFile(filename, classLoader));
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return ret;
    }

    public static File getFile(String spec, String className) {
        return FileUtilities.getFile(spec, FileUtilities.getClassLoader(className));
    }

    public static File getFile(String spec) {
        return FileUtilities.getFile(spec, FileUtilities.getClassLoader((Class)null));
    }

    public static File getFile(String spec, ClassLoader classLoader) {
        final String fn = spec.replace('\\', '/');
        if (classLoader == null) {
            classLoader = FileUtilities.getClassLoader((Class)null);
        }
        final ClassLoader cl = classLoader;
        URL url = null;
        if (cl != null && (url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cl.getResource(fn);
            }
        })) == null) {
            url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ClassLoader.getSystemResource(fn);
                }
            });
        }
        if (url == null) {
            url = loadedObject.getClass().getResource(fn);
        }
        if (url == null) {
            try {
                url = new URL(fn);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        File ret = null;
        if (url != null && url.getProtocol().compareToIgnoreCase("file") == 0) {
            ret = new File(url.getPath().substring(1));
        }
        if (ret == null) {
            File dir;
            int index = fn.lastIndexOf(47);
            ret = index > 0 ? ((dir = new File(fn.substring(0, index))) != null || dir.isDirectory() ? new File(dir.getPath() + '/' + fn.substring(index + 1)) : new File(fn)) : new File(fn);
        }
        if (ret != null) {
            ret = new File(ret.getAbsolutePath());
        }
        return ret;
    }

    public static File locateFile(String spec) {
        File ret;
        if (spec.charAt(0) == '\"' && spec.charAt(spec.length() - 1) == '\"') {
            spec = spec.substring(1, spec.length() - 1);
        }
        if (!(ret = new File(spec)).exists() && !(ret = new File(spec = FileUtilities.replaceEnvironments(spec))).exists()) {
            ret = new File(FileUtilities.locateInPath(spec));
        }
        return ret;
    }

    public static String locateInPath(String s) {
        String path = FwkPropertyBus.getProperty("Environment.PATH", (String)null);
        if (path == null && (path = FwkPropertyBus.getProperty("Environment.Path", (String)null)) == null) {
            path = FwkPropertyBus.getProperty("Environment.path", (String)null);
        }
        String ret = s;
        if (path != null) {
            String[] arr = path.split(";");
            boolean stop = false;
            for (int i = 0; !stop && i < arr.length; ++i) {
                File test = new File(arr[i] + "/" + s);
                if (!test.exists()) continue;
                ret = arr[i] + "/" + s;
                stop = true;
            }
        }
        return ret;
    }

    public static String replaceEnvironments(String s) {
        String env;
        int idx;
        int i;
        s = s.replace('\\', '/');
        String[] arr = s.split("\\$");
        StringBuffer sBuf = new StringBuffer(arr[0]);
        for (i = 1; i < arr.length; ++i) {
            idx = arr[i].indexOf(47);
            if (idx > 0) {
                env = arr[i].substring(0, idx);
                sBuf.append(FwkPropertyBus.getProperty("Environment." + env, "$" + env));
                sBuf.append(arr[i].substring(idx, arr[i].length()));
                continue;
            }
            env = arr[i];
            sBuf.append(FwkPropertyBus.getProperty("Environment." + env, "$" + env));
        }
        arr = sBuf.toString().split("\\%");
        sBuf = new StringBuffer();
        for (i = 0; i < arr.length; ++i) {
            if (i % 2 != 0) {
                env = FwkPropertyBus.getProperty("Environment." + arr[i], (String)null);
                if (env != null) {
                    sBuf.append(env);
                    continue;
                }
                sBuf.append("%").append(arr[i]).append("%");
                continue;
            }
            sBuf.append(arr[i]);
        }
        s = sBuf.toString();
        idx = s.indexOf("${");
        while (idx >= 0) {
            int idx1 = s.indexOf(125, idx);
            if (idx1 > idx) {
                env = s.substring(idx + 2, idx1);
                env = FwkPropertyBus.getProperty("Environment." + env, (String)null);
                s = env != null ? s.substring(0, idx) + env + s.substring(idx1 + 1, s.length()) : s.substring(0, idx) + s.substring(idx + 2, s.length());
                idx = s.indexOf("${");
                continue;
            }
            idx = -1;
        }
        return s;
    }

    public static InputStream getInputStream(String spec) {
        return FileUtilities.getInputStream(spec, FileUtilities.getClassLoader((Class)null));
    }

    public static InputStream getInputStream(String spec, String className) {
        return FileUtilities.getInputStream(spec, FileUtilities.getClassLoader(className));
    }

    public static InputStream getInputStream(String spec, ClassLoader classLoader) {
        String filename;
        InputStream ret;
        block12: {
            final String fn = spec;
            if (classLoader == null) {
                classLoader = FileUtilities.getClassLoader((Class)null);
            }
            final ClassLoader cl = classLoader;
            URL url = null;
            if (cl != null && (url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return cl.getResource(fn);
                }
            })) == null) {
                url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return ClassLoader.getSystemResource(fn);
                    }
                });
            }
            if (url == null) {
                url = loadedObject.getClass().getResource(fn);
            }
            if (url == null) {
                try {
                    url = new URL(fn);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            ret = null;
            filename = fn;
            if (url != null) {
                try {
                    ret = url.openConnection().getInputStream();
                }
                catch (Throwable t) {
                    if (url.getProtocol().compareToIgnoreCase("file") != 0) break block12;
                    filename = url.getPath().substring(1);
                }
            }
        }
        if (ret == null) {
            try {
                ret = new FileInputStream(FileUtilities.getFile(filename, classLoader));
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        System.out.println(FileUtilities.locateFile("athos.dll"));
        System.out.println(FileUtilities.locateFile("${JAVA_ROOT}/jar/AsamCommander.jar"));
        System.exit(0);
    }
}

