/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkDragAndDrop;
import com.highqsoft.fwk.FwkInfoBusConsumer;
import com.highqsoft.fwk.FwkSortedArray;
import com.highqsoft.fwk.FwkStringTransfer;
import com.highqsoft.fwk.command.FwkCopyToClipboardCommand;
import com.highqsoft.fwk.command.FwkStringSaveAsCommand;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.listener.FwkPopupMenuUnregisterListener;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusImmediateAccessInterface;
import com.highqsoft.interfaces.fwk.FwkInstructionInterface;
import com.highqsoft.interfaces.fwk.FwkInterface;
import com.highqsoft.interfaces.fwk.FwkPersistenceInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyChangeListenerInterface;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.infobus.InfoBusItemAvailableEvent;
import javax.infobus.InfoBusItemRevokedEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class FwkInfoBusItemList
extends JList
implements FwkPropertyChangeListenerInterface {
    public static final String version = "$Revision: 1.5 $";
    static final String[] empty = new String[]{""};
    protected FwkSortedArray dataItemList;
    protected FwkSortedArray groupList;
    protected Hashtable dataObject;
    protected ItemListConsumer consumer;
    CellRenderer cellRenderer;
    DataFlavor[] dataFlavor;
    String filter = "*";
    dndSupport dnd;

    public String getVersion() {
        return version;
    }

    public FwkArrayInterface getFwkMimeTypes() {
        return FwkContainer.getFwkMimeTypes(FwkInterface.class);
    }

    public FwkInfoBusItemList() {
        this.initialize();
    }

    public FwkInfoBusItemList(ListModel dataModel) {
        super(dataModel);
        this.initialize();
    }

    public FwkInfoBusItemList(Object[] listData) {
        super(listData);
        this.initialize();
    }

    public FwkInfoBusItemList(Vector listData) {
        super(listData);
        this.initialize();
    }

    public void release() {
    }

    protected void initialize() {
        this.setToolTipText("junk");
        FwkContainer.getClipboard().addPropertyChangeListener(this);
        this.cellRenderer = new CellRenderer();
        this.setCellRenderer(this.cellRenderer);
        this.consumer = new ItemListConsumer("DataManager.ItemListConsumer@" + FwkDataBus.BUSNAME, FwkContainer.getMimeTypes(FwkColumnAccessInterface.class));
        this.dataItemList = new FwkSortedArray();
        this.groupList = new FwkSortedArray();
        this.dataObject = new Hashtable();
        this.addMouseListener(new ItemListMouseListener());
        this.dnd = new dndSupport();
        this.dnd.setInfoBusName(this.consumer.getInfoBusName());
    }

    public void setFilter(String filter) {
        if (filter != null) {
            this.filter = filter;
        }
        this.update();
    }

    public void setFlavor(DataFlavor[] flavor) {
        if (this.dataFlavor != null) {
            this.dataFlavor = flavor;
        }
        this.update();
    }

    public void setMimeType(String mimeType) {
        if (mimeType != null) {
            try {
                DataFlavor[] df = new DataFlavor[]{new DataFlavor(mimeType)};
                this.dataFlavor = df;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.update();
    }

    public void setInfoBusParams(String infoBusName, String filter, DataFlavor[] flavor) {
        if (filter != null) {
            this.filter = filter;
        }
        if (flavor != null) {
            this.dataFlavor = flavor;
        }
        this.consumer.setInfoBusName(infoBusName);
        this.dnd.setInfoBusName(infoBusName);
        this.update();
    }

    public String getInfoBusName() {
        return this.consumer.getInfoBusName();
    }

    protected void addInfoBusItem(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Object[]) {
            Object[] arr = (Object[])obj;
            for (int i = arr.length - 1; i >= 0; --i) {
                this.addInfoBusItem(arr[i]);
            }
            return;
        }
        String textValue = null;
        boolean isGroup = false;
        if (obj instanceof FwkInfoBusImmediateAccessInterface) {
            isGroup = ((FwkInfoBusImmediateAccessInterface)obj).isGroup();
        }
        if (obj instanceof FwkColumnAccessInterface) {
            textValue = ((FwkColumnAccessInterface)obj).getShortName().trim();
            if (!(textValue != null && textValue.length() != 0 || (textValue = ((FwkColumnAccessInterface)obj).getColumnName().trim()) != null && textValue.length() != 0)) {
                textValue = ((FwkColumnAccessInterface)obj).getName().trim();
            }
        } else if (obj instanceof FwkDescriptionInterface) {
            textValue = ((FwkDescriptionInterface)obj).getName();
        } else {
            Method method = null;
            try {
                method = obj.getClass().getMethod("getName", null);
            }
            catch (Throwable t1) {
                // empty catch block
            }
            if (method != null) {
                try {
                    textValue = (String)method.invoke(obj, null);
                }
                catch (Throwable t3) {}
            } else {
                try {
                    method = obj.getClass().getMethod("getProperty", null);
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                if (method != null) {
                    Object[] param = new Object[]{"Name"};
                    try {
                        textValue = (String)method.invoke(obj, param);
                    }
                    catch (Throwable t4) {
                        // empty catch block
                    }
                }
            }
        }
        if (textValue == null) {
            textValue = obj.toString();
        }
        if (isGroup) {
            this.groupList.add((Comparable)((Object)textValue));
        } else {
            this.dataItemList.add((Comparable)((Object)textValue));
        }
        this.dataObject.put(textValue, obj);
    }

    protected void update() {
        this.dataItemList.clear();
        this.groupList.clear();
        this.dataObject.clear();
        this.loadItems();
        if (this.dataItemList.size() != 0 && this.groupList.size() != 0) {
            Object[] arr = new Object[this.groupList.size() + this.dataItemList.size()];
            System.arraycopy(this.groupList.toArray(), 0, arr, 0, this.groupList.size());
            System.arraycopy(this.dataItemList.toArray(), 0, arr, this.groupList.size(), this.dataItemList.size());
            this.setListData(arr);
        } else if (this.dataItemList.size() != 0) {
            this.setListData(this.dataItemList.toArray());
        } else if (this.groupList.size() != 0) {
            this.setListData(this.groupList.toArray());
        } else {
            this.setListData(empty);
        }
        this.repaint();
    }

    protected void loadItems() {
        Object[] obj = this.consumer.findMultipleDataItems(this.filter, this.dataFlavor);
        if (obj != null) {
            for (int i = obj.length - 1; i >= 0; --i) {
                this.addInfoBusItem(obj);
            }
        }
    }

    public String getToolTipText(MouseEvent e) {
        int index = this.locationToIndex(e.getPoint());
        try {
            return this.getSelectedItem(index).toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public FwkInfoBusImmediateAccessInterface getSelectedItem(int index) {
        FwkInfoBusImmediateAccessInterface ret = null;
        if (index >= 0 && index < this.groupList.size()) {
            ret = (FwkInfoBusImmediateAccessInterface)this.dataObject.get(this.groupList.get(index));
        } else if (index >= this.groupList.size() && index < this.groupList.size() + this.dataItemList.size()) {
            ret = (FwkInfoBusImmediateAccessInterface)this.dataObject.get(this.dataItemList.get(index - this.groupList.size()));
        }
        return ret;
    }

    public FwkInfoBusImmediateAccessInterface[] getSelectedItems() {
        int size;
        FwkInfoBusImmediateAccessInterface[] ret = null;
        int[] sel = this.getSelectedIndices();
        if (sel != null && sel.length != 0 && (size = sel.length) > 0) {
            ret = new FwkInfoBusImmediateAccessInterface[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = this.getSelectedItem(sel[i]);
            }
        }
        return ret;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        System.out.println(this.getClass().getName() + ".propertyChange ev=" + ev);
    }

    class dndSupport
    extends FwkDragAndDrop {
        public dndSupport() {
            super(FwkInfoBusItemList.this);
        }

        public Transferable getTransferData() {
            FwkStringTransfer ret = null;
            Object obj = FwkInfoBusItemList.this.dataObject.get(FwkInfoBusItemList.this.getSelectedValue());
            if (obj != null) {
                ret = obj instanceof FwkDescriptionInterface ? new FwkStringTransfer(((FwkDescriptionInterface)obj).getPresentationString()) : new FwkStringTransfer(obj.toString());
            }
            return ret;
        }
    }

    class CellRenderer
    extends DefaultListCellRenderer
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Icon icon = null;
            Object obj = FwkInfoBusItemList.this.dataObject.get(value);
            if (obj instanceof FwkDescriptionInterface) {
                icon = ((FwkDescriptionInterface)obj).getIcon();
            } else {
                Method method = null;
                try {
                    method = obj.getClass().getMethod("getIcon", null);
                }
                catch (Throwable t1) {
                    // empty catch block
                }
                if (method == null) {
                    try {
                        method = obj.getClass().getMethod("getImageIcon", null);
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                }
                if (method != null) {
                    try {
                        icon = (Icon)method.invoke(obj, null);
                    }
                    catch (Throwable t3) {
                        // empty catch block
                    }
                }
            }
            this.setIcon(icon);
            return this;
        }
    }

    class ItemListMouseListener
    extends MouseAdapter {
        ItemListMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 1 && e.getModifiers() == 4) {
                int index = FwkInfoBusItemList.this.locationToIndex(e.getPoint());
                FwkInfoBusItemList.this.setSelectedIndex(index);
                if (FwkInfoBusItemList.this.dataObject != null && FwkInfoBusItemList.this.getSelectedValue() != null) {
                    Object obj = FwkInfoBusItemList.this.dataObject.get(FwkInfoBusItemList.this.getSelectedValue());
                    JPopupMenu popup = null;
                    FwkCommandInterface[] arr = null;
                    if (obj instanceof FwkPersistenceInterface) {
                        FwkPersistenceInterface per = (FwkPersistenceInterface)obj;
                        arr = per.getCommands(per);
                    } else if (obj instanceof FwkInstructionInterface) {
                        FwkInstructionInterface in = (FwkInstructionInterface)obj;
                        arr = in.getCommands();
                    }
                    FwkArray parr = arr == null ? new FwkArray() : new FwkArray(Arrays.asList(arr));
                    FwkControllerInterface controller = null;
                    if (obj instanceof FwkControllerInterface) {
                        controller = (FwkControllerInterface)obj;
                    }
                    FwkCommand cmd = new FwkCopyToClipboardCommand(controller);
                    parr.add(cmd);
                    cmd = new FwkStringSaveAsCommand(controller);
                    parr.add(cmd);
                    popup = FwkGUIFactory.createPopupMenu(parr.toArray(arr));
                    if (popup != null) {
                        popup.addPopupMenuListener(FwkPopupMenuUnregisterListener.getInstance());
                        popup.show((Component)e.getSource(), e.getX(), e.getY());
                    }
                }
            }
        }
    }

    public class ItemListConsumer
    extends FwkInfoBusConsumer {
        public ItemListConsumer(String memberName, FwkArrayInterface mimeType) {
            super(memberName, mimeType);
            FwkInfoBusItemList.this.dataFlavor = FwkContainer.getDataFlavors(mimeType);
        }

        public DataFlavor[] getDataFlavors() {
            return FwkInfoBusItemList.this.dataFlavor;
        }

        public synchronized void dataItemRevoked(InfoBusItemRevokedEvent ev) {
            super.dataItemRevoked(ev);
            FwkInfoBusItemList.this.update();
        }

        public void propertyChange(PropertyChangeEvent ev) {
        }

        public synchronized void dataItemAvailable(InfoBusItemAvailableEvent ev) {
            super.dataItemAvailable(ev);
            if (this.isAssignable(ev.getDataFlavors())) {
                FwkInfoBusItemList.this.update();
            }
        }
    }
}

