/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import com.highqsoft.fwk.FwkColumnAccess;
import com.highqsoft.fwk.FwkColumnAccessProducer;
import com.highqsoft.fwk.FwkColumnDataObserverInt;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataItemConsumer;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import java.util.Arrays;

public class FwkMath {
    public static final String version = "$Revision: 1.4 $";

    public static String getVersion() {
        return version;
    }

    private FwkMath() {
    }

    public static FwkColumnAccessInterface generate(String name, int len, double offset, String unit) {
        double[] ret = null;
        if (len > 0) {
            ret = new double[len];
            Arrays.fill(ret, offset);
        }
        if (ret != null) {
            return new FwkColumnAccess(name, name, unit, null, ret);
        }
        return null;
    }

    public static FwkColumnAccessInterface generate(String name, int len, double offset, double delta, String unit) {
        double[] ret = null;
        if (len > 0) {
            ret = new double[len];
            ret[0] = offset;
            for (int i = 1; i < len; ++i) {
                ret[i] = ret[i - 1] + delta;
            }
        }
        if (ret != null) {
            return new FwkColumnAccess(name, name, unit, null, ret);
        }
        return null;
    }

    public static FwkColumnAccessInterface generate(String name, int len, double offset, double delta, double max, String unit) {
        double[] ret = null;
        if (len > 0) {
            ret = new double[len];
            ret[0] = offset;
            for (int i = 1; i < len; ++i) {
                ret[i] = ret[i - 1] + delta;
                if (!(ret[i] > max)) continue;
                ret[i] = offset;
            }
        }
        if (ret != null) {
            return new FwkColumnAccess(name, name, unit, null, ret);
        }
        return null;
    }

    protected static double[] shorten(FwkColumnAccessInterface col, int newLen) {
        int len = col.getCount();
        double[] ret = null;
        if (newLen > 0) {
            ret = new double[newLen];
            float fac = 1.0f * (float)len / (float)newLen;
            double[] data = col.getValues();
            for (int i = 0; i < newLen; ++i) {
                ret[i] = data[Math.round((float)i * fac)];
            }
        }
        return ret;
    }

    public static FwkColumnAccessInterface congrid(FwkColumnAccessInterface col, int newLen) {
        int len = col.getCount();
        double[] ret = null;
        if (len < newLen) {
            ret = new double[newLen];
            double[] data = col.getValues();
            float fac = 1.0f * (float)len / (float)newLen;
            for (int i = 0; i < newLen; ++i) {
                int index = Math.round((float)i * fac);
                if (index >= len) {
                    index = len - 1;
                }
                ret[i] = data[index];
            }
        } else {
            ret = FwkMath.shorten(col, newLen);
        }
        String name1 = "congrid(";
        String name2 = "," + newLen + ")";
        return new FwkColumnAccess(name1 + col.getName() + name2, name1 + col.getColumnName() + name2, col.getUnitString(), null, ret);
    }

    public static FwkColumnAccessInterface rebin(FwkColumnAccessInterface col, int newLen) {
        int len = col.getCount();
        double[] ret = null;
        if (len < newLen) {
            ret = new double[newLen];
            double[] data = col.getValues();
            float fac = 1.0f * (float)len / (float)newLen;
            int idx0 = 0;
            int idx1 = 1;
            double m = (data[idx1] - data[idx0]) / (double)(idx1 - idx0);
            double n = data[idx1] - m * (double)idx1;
            for (int i = 0; i < newLen; ++i) {
                int index = Math.round((float)i * fac);
                if (index >= len) {
                    index = len - 1;
                }
                if (index > idx1) {
                    idx0 = idx1++;
                    m = (data[idx1] - data[idx0]) / (double)(idx1 - idx0);
                    n = data[idx1] - m * (double)idx1;
                }
                ret[i] = m * (double)i * (double)fac + n;
            }
        } else {
            ret = FwkMath.shorten(col, newLen);
        }
        String name1 = "rebin(";
        String name2 = "," + newLen + ")";
        return new FwkColumnAccess(name1 + col.getName() + name2, name1 + col.getColumnName() + name2, col.getUnitString(), null, ret);
    }

    public static FwkColumnAccessInterface qrebin(FwkColumnAccessInterface col, int newLen) {
        int len = col.getCount();
        double[] ret = null;
        if (len < newLen) {
            ret = new double[newLen];
            double[] data = col.getValues();
            float fac = 1.0f * (float)len / (float)newLen;
            int idx0 = 0;
            int idx1 = 1;
            int idx2 = 2;
            double a = ((data[idx2] - data[idx1]) / (double)(idx2 - idx1) - (data[idx0] - data[idx1]) / (double)(idx0 - idx1)) / (double)(idx2 - idx0);
            double b = (data[idx0] - data[idx1]) / (double)(idx0 - idx1) - a * (double)(idx0 + idx1);
            double c = data[idx0] - a * (double)idx0 * (double)idx0 - b * (double)idx0;
            for (int i = 0; i < newLen; ++i) {
                int index = Math.round((float)i * fac);
                if (index >= len) {
                    index = len - 1;
                }
                if (index > idx1) {
                    idx0 = idx1++;
                    a = ((data[idx2] - data[idx1]) / (double)(idx2 - idx1) - (data[idx0] - data[idx1]) / (double)(idx0 - idx1)) / (double)(idx2 - idx0);
                    b = (data[idx0] - data[idx1]) / (double)(idx0 - idx1) - a * (double)(idx0 + idx1);
                    c = data[idx0] - a * (double)idx0 * (double)idx0 - b * (double)idx0;
                }
                ret[i] = a * (double)i * (double)i * (double)fac * (double)fac + b * (double)i * (double)fac + c;
                if (!Double.isNaN(ret[i])) continue;
                ret[i] = (data[idx1] - data[idx0]) / (double)(idx1 - idx0) * (double)i * (double)fac + data[idx1] - (data[idx1] - data[idx0]) / (double)(idx1 - idx0) * (double)idx1;
            }
        } else {
            ret = FwkMath.shorten(col, newLen);
        }
        String name1 = "qrebin(";
        String name2 = "," + newLen + ")";
        return new FwkColumnAccess(name1 + col.getName() + name2, name1 + col.getColumnName() + name2, col.getUnitString(), null, ret);
    }

    public static FwkColumnAccessInterface convol(FwkColumnAccessInterface col, int convolLen) {
        int j;
        double tmp;
        int i;
        int len = col.getCount();
        double[] data = col.getValues();
        int cvLen = Math.abs(convolLen);
        if (cvLen > len) {
            cvLen = len / 2;
        }
        if (cvLen < 2) {
            cvLen = 5;
        }
        if (cvLen > len) {
            return null;
        }
        double[] ret = new double[len];
        int half = cvLen / 2;
        cvLen = half * 2 + 1;
        for (i = 0; i < half && i < len; ++i) {
            tmp = 0.0;
            for (j = 0; j < cvLen && (i + j) % (half + 1 + i) < len; ++j) {
                tmp += data[(i + j) % (half + 1 + i)];
            }
            ret[i] = tmp / (double)cvLen;
        }
        while (i < len - half) {
            tmp = 0.0;
            for (j = i - half; j < i + half + 1; ++j) {
                tmp += data[j];
            }
            ret[i] = tmp / (double)cvLen;
            ++i;
        }
        while (i < len) {
            tmp = 0.0;
            for (j = 0; j < cvLen; ++j) {
                if (i + j - half < len) {
                    tmp += data[i + j - half];
                    continue;
                }
                tmp += data[len - 1 - (i + j - half) % len];
            }
            ret[i] = tmp / (double)cvLen;
            ++i;
        }
        String name1 = "convol(";
        String name2 = "," + cvLen + ")";
        return new FwkColumnAccess(name1 + col.getName() + name2, name1 + col.getColumnName() + name2, col.getUnitString(), null, ret);
    }

    public static FwkColumnAccessInterface deviation(FwkColumnAccessInterface col) {
        int len = col.getCount();
        double[] data = col.getValues();
        double[] ret = new double[len];
        ret[0] = 0.0;
        for (int i = 1; i < len; ++i) {
            ret[i] = data[i] - data[i - 1];
        }
        if (len > 2) {
            double m = (ret[2] - ret[1]) / 1.0;
            double n = ret[2] - m * 1.0;
            ret[0] = m + n;
        }
        String name = "deviation(";
        return new FwkColumnAccess(name + col.getName() + ")", name + col.getColumnName() + ")", col.getUnitString() + "/1", null, ret);
    }

    public static FwkColumnAccessInterface integration(FwkColumnAccessInterface col) {
        int len = col.getCount();
        double[] data = col.getValues();
        double[] ret = new double[len];
        ret[0] = 0.0;
        for (int i = 1; i < len; ++i) {
            ret[i] = ret[i - 1] + (data[i] + data[i - 1]) / 2.0;
        }
        String name = "integration(";
        return new FwkColumnAccess(name + col.getName() + ")", name + col.getColumnName() + ")", col.getUnitString() + "*1", null, ret);
    }

    public static FwkColumnAccessInterface deviation(FwkColumnAccessInterface xCol, FwkColumnAccessInterface yCol) {
        int len = xCol.getCount();
        if (len != yCol.getCount()) {
            return null;
        }
        double[] xData = xCol.getValues();
        double[] yData = yCol.getValues();
        double[] ret = new double[len];
        short[] flags = new short[len];
        ret[0] = 0.0;
        for (int i = 1; i < len; ++i) {
            try {
                ret[i] = (yData[i] - yData[i - 1]) / (xData[i] - xData[i - 1]);
                flags[i] = 15;
                continue;
            }
            catch (Throwable t) {
                flags[i] = 0;
                if (yData[i] - yData[i - 1] > 0.0) {
                    if (xData[i] - xData[i - 1] > 0.0) {
                        ret[i] = Double.MAX_VALUE;
                        continue;
                    }
                    ret[i] = -1.7976931348623157E308;
                    continue;
                }
                ret[i] = xData[i] - xData[i - 1] > 0.0 ? -1.7976931348623157E308 : Double.MAX_VALUE;
            }
        }
        if (len > 2) {
            double m = (ret[2] - ret[1]) / 1.0;
            double n = ret[2] - m * 1.0;
            ret[0] = m + n;
        }
        String name = "deviation(";
        return new FwkColumnAccess(name + xCol.getName() + "," + yCol.getName() + ")", name + xCol.getColumnName() + "," + yCol.getColumnName() + ")", yCol.getUnitString() + "/" + xCol.getUnitString(), flags, ret);
    }

    public static FwkColumnAccessInterface integration(FwkColumnAccessInterface xCol, FwkColumnAccessInterface yCol) {
        int len = xCol.getCount();
        if (len != yCol.getCount()) {
            return null;
        }
        double[] xData = xCol.getValues();
        double[] yData = yCol.getValues();
        double[] ret = new double[len];
        ret[0] = 0.0;
        for (int i = 1; i < len; ++i) {
            ret[i] = ret[0] + (yData[i] + yData[i - 1]) / 2.0 * (xData[i] - xData[i - 1]);
        }
        String name = "integration(";
        return new FwkColumnAccess(name + xCol.getName() + "," + yCol.getName() + ")", name + xCol.getColumnName() + "," + yCol.getColumnName() + ")", yCol.getUnitString() + "*" + xCol.getUnitString(), null, ret);
    }

    public static FwkColumnAccessInterface abs(FwkColumnAccessInterface col) {
        int len = col.getCount();
        double[] data = col.getValues();
        double[] ret = new double[len];
        for (int i = 1; i < len; ++i) {
            ret[i] = Math.abs(data[i]);
        }
        String name = "abs(";
        return new FwkColumnAccess(name + col.getName() + ")", name + col.getColumnName() + ")", col.getUnitString(), null, ret);
    }

    public static FwkColumnAccessInterface add(FwkColumnAccessInterface xCol, FwkColumnAccessInterface yCol) {
        int i;
        int len = Math.max(xCol.getCount(), yCol.getCount());
        int subLen = Math.min(xCol.getCount(), yCol.getCount());
        double[] xData = xCol.getValues();
        double[] yData = yCol.getValues();
        double[] ret = new double[len];
        ret[0] = 0.0;
        for (i = 0; i < subLen; ++i) {
            ret[i] = xData[i] + yData[i];
        }
        if (subLen != len) {
            if (xCol.getCount() < yCol.getCount()) {
                for (i = subLen; i < len; ++i) {
                    ret[i] = yData[i];
                }
            } else {
                for (i = subLen; i < len; ++i) {
                    ret[i] = xData[i];
                }
            }
        }
        String name = "add(";
        return new FwkColumnAccess(name + xCol.getName() + "," + yCol.getName() + ")", name + xCol.getColumnName() + "," + yCol.getColumnName() + ")", xCol.getUnitString(), null, ret);
    }

    public static FwkColumnAccessInterface add(FwkColumnAccessInterface xCol, double val) {
        int len = xCol.getCount();
        double[] xData = xCol.getValues();
        double[] ret = new double[len];
        ret[0] = 0.0;
        for (int i = 0; i < len; ++i) {
            ret[i] = xData[i] + val;
        }
        String name = "add(";
        return new FwkColumnAccess(name + xCol.getName() + "," + val + ")", name + xCol.getColumnName() + "," + val + ")", xCol.getUnitString(), null, ret);
    }

    public static FwkColumnAccessInterface sub(FwkColumnAccessInterface xCol, FwkColumnAccessInterface yCol) {
        int i;
        int len = Math.max(xCol.getCount(), yCol.getCount());
        int subLen = Math.min(xCol.getCount(), yCol.getCount());
        double[] xData = xCol.getValues();
        double[] yData = yCol.getValues();
        double[] ret = new double[len];
        ret[0] = 0.0;
        for (i = 0; i < subLen; ++i) {
            ret[i] = xData[i] - yData[i];
        }
        if (subLen != len) {
            if (xCol.getCount() < yCol.getCount()) {
                for (i = subLen; i < len; ++i) {
                    ret[i] = yData[i];
                }
            } else {
                for (i = subLen; i < len; ++i) {
                    ret[i] = -xData[i];
                }
            }
        }
        String name = "sub(";
        return new FwkColumnAccess(name + xCol.getName() + "," + yCol.getName() + ")", name + xCol.getColumnName() + "," + yCol.getColumnName() + ")", xCol.getUnitString(), null, ret);
    }

    public static FwkColumnAccessInterface sub(FwkColumnAccessInterface xCol, double val) {
        int len = xCol.getCount();
        double[] xData = xCol.getValues();
        double[] ret = new double[len];
        ret[0] = 0.0;
        for (int i = 0; i < len; ++i) {
            ret[i] = xData[i] - val;
        }
        String name = "sub(";
        return new FwkColumnAccess(name + xCol.getName() + "," + val + ")", name + xCol.getColumnName() + "," + val + ")", xCol.getUnitString(), null, ret);
    }

    public static FwkColumnAccessInterface mul(FwkColumnAccessInterface xCol, FwkColumnAccessInterface yCol) {
        int i;
        int len = Math.max(xCol.getCount(), yCol.getCount());
        int subLen = Math.min(xCol.getCount(), yCol.getCount());
        double[] xData = xCol.getValues();
        double[] yData = yCol.getValues();
        double[] ret = new double[len];
        ret[0] = 0.0;
        for (i = 0; i < subLen; ++i) {
            ret[i] = xData[i] * yData[i];
        }
        if (subLen != len) {
            for (i = subLen; i < len; ++i) {
                ret[i] = 0.0;
            }
        }
        String name = "mul(";
        return new FwkColumnAccess(name + xCol.getName() + "," + yCol.getName() + ")", name + xCol.getColumnName() + "," + yCol.getColumnName() + ")", xCol.getUnitString() + "*" + yCol.getUnitString(), null, ret);
    }

    public static FwkColumnAccessInterface mul(FwkColumnAccessInterface xCol, double val) {
        int len = xCol.getCount();
        double[] xData = xCol.getValues();
        double[] ret = new double[len];
        ret[0] = 0.0;
        for (int i = 0; i < len; ++i) {
            ret[i] = xData[i] * val;
        }
        String name = "mul(";
        return new FwkColumnAccess(name + xCol.getName() + "," + val + ")", name + xCol.getColumnName() + "," + val + ")", xCol.getUnitString(), null, ret);
    }

    public static FwkColumnAccessInterface div(FwkColumnAccessInterface xCol, FwkColumnAccessInterface yCol) {
        int i;
        int len = Math.max(xCol.getCount(), yCol.getCount());
        int subLen = Math.min(xCol.getCount(), yCol.getCount());
        double[] xData = xCol.getValues();
        double[] yData = yCol.getValues();
        double[] ret = new double[len];
        short[] flags = new short[len];
        for (i = 0; i < subLen; ++i) {
            try {
                ret[i] = xData[i] / yData[i];
                flags[i] = 15;
                continue;
            }
            catch (Throwable t) {
                flags[i] = 0;
                if (yData[i] > 0.0) {
                    if (xData[i] > 0.0) {
                        ret[i] = Double.MAX_VALUE;
                        continue;
                    }
                    ret[i] = -1.7976931348623157E308;
                    continue;
                }
                ret[i] = xData[i] > 0.0 ? -1.7976931348623157E308 : Double.MAX_VALUE;
            }
        }
        if (subLen != len) {
            for (i = subLen; i < len; ++i) {
                ret[i] = 0.0;
            }
        }
        String name = "div(";
        return new FwkColumnAccess(name + xCol.getName() + "," + yCol.getName() + ")", name + xCol.getColumnName() + "," + yCol.getColumnName() + ")", xCol.getUnitString() + "/" + yCol.getUnitString(), flags, ret);
    }

    public static FwkColumnAccessInterface div(FwkColumnAccessInterface xCol, double val) {
        int len = xCol.getCount();
        double[] xData = xCol.getValues();
        double[] ret = new double[len];
        short[] flags = new short[len];
        for (int i = 0; i < len; ++i) {
            try {
                ret[i] = xData[i] / val;
                flags[i] = 15;
                continue;
            }
            catch (Throwable t) {
                flags[i] = 0;
                if (val > 0.0) {
                    if (xData[i] > 0.0) {
                        ret[i] = Double.MAX_VALUE;
                        continue;
                    }
                    ret[i] = -1.7976931348623157E308;
                    continue;
                }
                ret[i] = xData[i] > 0.0 ? -1.7976931348623157E308 : Double.MAX_VALUE;
            }
        }
        String name = "div(";
        return new FwkColumnAccess(name + xCol.getName() + "," + val + ")", name + xCol.getColumnName() + "," + val + ")", xCol.getUnitString(), flags, ret);
    }

    public static FwkColumnAccessInterface hist(FwkColumnAccessInterface xCol, int tot) {
        int len = xCol.getCount();
        double max = xCol.getMaximum();
        double min = xCol.getMinimum();
        double fac = (double)tot / (max - min);
        double[] xData = xCol.getValues();
        int[] ret = new int[tot];
        Arrays.fill(ret, 0);
        short[] flags = new short[tot];
        Arrays.fill(flags, (short)15);
        for (int i = 0; i < len; ++i) {
            int idx = (int)Math.ceil(fac * (xData[i] - min));
            if (idx > 0) {
                int n = idx - 1;
                ret[n] = ret[n] + 1;
                continue;
            }
            int n = idx;
            ret[n] = ret[n] + 1;
        }
        String name = "hist(";
        return new FwkColumnAccess(name + xCol.getName() + "," + tot + ")", name + xCol.getColumnName() + "," + tot + ")", xCol.getUnitString(), new FwkColumnDataObserverInt(ret, flags));
    }

    public static void main(String[] args) {
        String[] as = new String[args.length + 1];
        System.arraycopy(args, 0, as, 0, args.length);
        as[as.length - 1] = "-TestDataProducer";
        FwkContainer.initialize(as);
        try {
            FwkColumnAccessInterface[] cols = new FwkColumnAccessInterface[]{(FwkColumnAccessInterface)FwkDataItemConsumer.getInstance().findDataItem("COS", FwkContainer.getDataFlavor(FwkColumnAccessInterface.class)), (FwkColumnAccessInterface)FwkDataItemConsumer.getInstance().findDataItem("EXP", FwkContainer.getDataFlavor(FwkColumnAccessInterface.class))};
            FwkColumnAccessInterface cCol = FwkMath.congrid(cols[1], 100);
            FwkColumnAccessProducer.add(cCol);
            FwkColumnAccessInterface reb = FwkMath.rebin(cCol, 600);
            FwkColumnAccessProducer.add(reb);
            FwkColumnAccessInterface qreb = FwkMath.qrebin(cCol, 600);
            FwkColumnAccessProducer.add(qreb);
            FwkColumnAccessInterface cong = FwkMath.congrid(cCol, 600);
            FwkColumnAccessProducer.add(cong);
            FwkColumnAccessProducer.add(FwkMath.sub(qreb, reb));
            FwkColumnAccessInterface noise = (FwkColumnAccessInterface)FwkDataItemConsumer.getInstance().findDataItem("NOISE+SIN(X)/EXP(X/10)", FwkContainer.getDataFlavor(FwkColumnAccessInterface.class));
            long time = System.currentTimeMillis();
            FwkColumnAccessProducer.add(FwkMath.hist(noise, 100));
            time = System.currentTimeMillis() - time;
            System.out.println(time);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        FwkContainer.openFrame("com.highqsoft.med.MED");
    }
}

