/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import com.highqsoft.fwk.FwkColumnAccess;
import com.highqsoft.fwk.FwkColumnDataObserverDouble;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkFileFilter;
import com.highqsoft.fwk.FwkMessageEvent;
import com.highqsoft.fwk.FwkMessageListener;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkMessageEventInterface;
import com.highqsoft.interfaces.fwk.FwkReadColumnsFromStreamInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class FwkSimpleASCIIColumnsReader
extends FwkFileFilter
implements FwkReadColumnsFromStreamInterface {
    public static final String EXTENSION = FwkPropertyBus.getProperty("FwkContainer.Text.ASCIIExtension", "*");
    public static final String COLUMNNAME = FwkPropertyBus.getProperty("FwkContainer.Text.ColumnName", "Column");
    public static final int INCREMENT = 10;
    public static final int DATAINCREMENT = 4096;
    protected static final int COLUMNNAMES = 0;
    protected static final int UNITNAMES = 1;
    protected static final int VALUES = 2;
    protected static final double INVALID_AVL = 1.0E10;
    protected static final double INVALID_VALUE = 0.0;
    protected double invalidValue = 0.0;
    protected HashMap messageListener = new HashMap();
    protected String[] colNames;
    protected int colCounter = 0;
    protected String[] units;
    protected DataObserver[] observers;

    public void setAsInvalid(double val) {
        this.invalidValue = val;
    }

    public void addFwkMessageListener(FwkMessageListener fwkMessageListener) {
        if (fwkMessageListener != null) {
            this.messageListener.put(fwkMessageListener, fwkMessageListener);
        }
    }

    public void removeFwkMessageListener(FwkMessageListener fwkMessageListener) {
        if (fwkMessageListener != null) {
            this.messageListener.remove(fwkMessageListener);
        }
    }

    public FwkMessageListener[] getFwkMessageListeners() {
        return this.messageListener.values().toArray(new FwkMessageListener[this.messageListener.size()]);
    }

    protected void fireMessage(int lineNo, String message) {
        if (this.messageListener.size() > 0) {
            FwkMessageEvent ev = new FwkMessageEvent(this, Integer.toString(lineNo), message);
            Iterator it = this.messageListener.keySet().iterator();
            while (it.hasNext()) {
                FwkMessageListener l = (FwkMessageListener)it.next();
                l.messageOccured(ev);
            }
        }
    }

    protected void resetColumnNames() {
        this.colCounter = 0;
    }

    protected String addColumnName(String name) {
        if (this.colCounter <= 0) {
            this.colNames = new String[10];
            this.units = new String[10];
            this.observers = new DataObserver[10];
        }
        ++this.colCounter;
        if (this.colCounter >= this.colNames.length) {
            String[] tmp = new String[this.colNames.length + 10];
            System.arraycopy(this.colNames, 0, tmp, 0, this.colNames.length);
            this.colNames = tmp;
            tmp = new String[this.units.length + 10];
            System.arraycopy(this.units, 0, tmp, 0, this.units.length);
            this.units = tmp;
            DataObserver[] to = new DataObserver[this.observers.length + 10];
            System.arraycopy(this.observers, 0, to, 0, this.observers.length);
            this.observers = to;
        }
        this.colNames[this.colCounter - 1] = name;
        this.units[this.colCounter - 1] = "1";
        this.observers[this.colCounter - 1] = new DataObserver();
        return this.colNames[this.colCounter - 1];
    }

    protected String addUnit(int colNo, String unit) {
        if (colNo > 0 && colNo < this.units.length) {
            this.units[colNo] = unit;
        } else if (colNo >= this.units.length) {
            this.addColumnName(COLUMNNAME + "_" + colNo);
            this.units[colNo] = unit;
        }
        return this.units[colNo];
    }

    protected void addValue(int colno, double value) {
        if (colno >= 0 && colno < this.colCounter) {
            this.observers[colno].addValue(value);
        } else if (colno == this.colCounter) {
            this.addColumnName(COLUMNNAME + "_" + (this.colCounter + 1));
            this.observers[colno].addValue(value);
        }
    }

    protected int getCount(int colno) {
        return this.observers[colno].getCount();
    }

    public int getSize() {
        return this.colCounter;
    }

    public boolean accept(File f) {
        return true;
    }

    public String getDescription() {
        return FwkPropertyBus.getProperty("FwkContainer.Description.ColumnASCIIFile") + " (*." + EXTENSION + ")";
    }

    public FwkColumnAccessInterface[] read(String ref, InputStream is) throws FwkException {
        FwkColumnAccessInterface[] ret = null;
        Properties properties = new Properties();
        int lineNo = 0;
        try {
            int i;
            int i2;
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            if (r.markSupported()) {
                r.mark(1024);
                int startupLine = 0;
                boolean stop = false;
                while (!stop && (line = r.readLine()) != null) {
                    ++lineNo;
                    if (!line.matches(".*[:=].*")) {
                        stop = true;
                        r.reset();
                        --lineNo;
                        continue;
                    }
                    String[] arr = line.split("[:=]");
                    if (arr.length == 2) {
                        properties.put(arr[0].trim(), arr[1].trim());
                    } else if (arr.length > 2) {
                        int idx = line.indexOf(58);
                        if (idx < 0) {
                            idx = line.indexOf(61);
                        } else {
                            int idx2 = line.indexOf(61);
                            if (idx2 < idx) {
                                idx = idx2;
                            }
                        }
                        properties.put(line.substring(0, idx).trim(), line.substring(idx + 1, line.length()).trim());
                    }
                    ++startupLine;
                    r.mark(1024);
                }
                ++lineNo;
            }
            line = r.readLine();
            ++lineNo;
            if (line != null) {
                while (line != null && line.trim().length() == 0) {
                    line = r.readLine();
                    ++lineNo;
                }
            } else {
                return ret;
            }
            String[] arr = line.split(";");
            int semicolonCount = arr.length - 1;
            arr = line.split("\\t");
            int tabCount = arr.length - 1;
            arr = line.split("\\s");
            StreamTokenizer st = new StreamTokenizer(r);
            st.resetSyntax();
            if (semicolonCount == 0 && tabCount == 0) {
                st.wordChars(33, 126);
                st.whitespaceChars(0, 33);
                st.whitespaceChars(44, 44);
                st.whitespaceChars(59, 59);
            } else {
                st.wordChars(32, 126);
                st.whitespaceChars(0, 32);
                st.whitespaceChars(44, 44);
                st.whitespaceChars(59, 59);
                arr = tabCount > semicolonCount ? line.split("\\t") : line.split(";");
            }
            for (int i3 = 0; i3 < arr.length; ++i3) {
                if (arr[i3].trim().length() <= 0) continue;
                this.addColumnName(arr[i3].trim());
            }
            this.fireMessage(lineNo, this.colCounter + " columns found.");
            st.commentChar(35);
            st.commentChar(59);
            st.quoteChar(34);
            st.quoteChar(39);
            st.eolIsSignificant(true);
            int state = 1;
            int colNo = -1;
            Vector<String> vec = new Vector<String>();
            Vector<InvalidValue> invalid = new Vector<InvalidValue>();
            while (st.nextToken() != -1) {
                ++colNo;
                if (st.ttype == -3) {
                    vec.add(st.sval);
                    continue;
                }
                if (st.ttype == -2) {
                    vec.add(Double.toString(st.nval));
                    continue;
                }
                if (st.ttype != 10) continue;
                if (state == 0) {
                    if (this.colCounter > 0) {
                        state = 1;
                    }
                } else if (state == 1) {
                    if (vec.size() != this.colCounter) {
                        this.fireMessage(lineNo, "Error in Unit specification!");
                    } else {
                        double[] darr = new double[this.colCounter];
                        try {
                            int i4;
                            for (i4 = 0; i4 < this.colCounter; ++i4) {
                                darr[i4] = Double.parseDouble(vec.get(i4).toString());
                            }
                            for (i4 = 0; i4 < this.colCounter; ++i4) {
                                this.addValue(i4, darr[i4]);
                            }
                        }
                        catch (Throwable t) {
                            for (i2 = 0; i2 < this.colCounter; ++i2) {
                                this.addUnit(i2, vec.get(i2).toString());
                            }
                        }
                    }
                    state = 2;
                } else {
                    int count = vec.size();
                    if (count < this.colCounter) {
                        this.fireMessage(lineNo, "Undefined values count:" + count + " colCount:" + this.colCounter + "!");
                    } else {
                        double val = this.invalidValue;
                        int col = 0;
                        for (int i5 = 0; i5 < count; ++i5) {
                            String s = vec.get(i5).toString();
                            try {
                                val = Double.parseDouble(s);
                            }
                            catch (Throwable t) {
                                if (s.matches(".*E|.*e")) {
                                    s = s + vec.get(++i5).toString();
                                    try {
                                        val = Double.parseDouble(s);
                                    }
                                    catch (Throwable ti) {
                                        this.fireMessage(lineNo, "Invalid value found.");
                                        --i5;
                                        val = this.invalidValue;
                                        invalid.add(new InvalidValue(col, this.getCount(col)));
                                    }
                                }
                                if (this.isInvalid(s)) {
                                    this.fireMessage(lineNo, "Signature for invalid value found.");
                                } else {
                                    this.fireMessage(lineNo, "Invalid value found.");
                                }
                                invalid.add(new InvalidValue(col, this.getCount(col)));
                                val = this.invalidValue;
                            }
                            this.addValue(col++, val);
                        }
                    }
                }
                colNo = -1;
                ++lineNo;
                vec.clear();
            }
            ret = new FwkColumnAccessInterface[this.colCounter];
            for (i = 0; i < this.colCounter; ++i) {
                ret[i] = new FwkColumnAccess(this.colNames[i], this.colNames[i], this.units[i], this.observers[i]);
            }
            if (invalid.size() > 0) {
                for (i = 0; i < this.colCounter; ++i) {
                    ret[i].setFlagAt(ret[i].getCount() - 1, (short)15);
                }
                int size = invalid.size();
                for (i2 = 0; i2 < size; ++i2) {
                    InvalidValue invalidValue = (InvalidValue)invalid.get(i2);
                    ret[invalidValue.atCol].setFlagAt(invalidValue.atRow, (short)0);
                }
            }
        }
        catch (Throwable t) {
            this.fireMessage(lineNo, t.getClass().getName() + " " + t.getMessage());
            throw new FwkException(-1073676289, "$RCSfile: FwkSimpleASCIIColumnsReader.java,v $", "$Revision", "AH 2001-10-29 11:38", FwkPropertyBus.getProperty("FwkContainer.Text.Error_ReadFile"), this, t);
        }
        this.colCounter = 0;
        return ret;
    }

    protected boolean isInvalid(String s) {
        try {
            Double.parseDouble(s);
            return false;
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static void main(String[] args) {
        String filename = "c:/tmp/eric/Part 1.6";
        FwkSimpleASCIIColumnsReader reader = new FwkSimpleASCIIColumnsReader();
        reader.addFwkMessageListener(new MessagePrinter());
        reader.setAsInvalid(1.0E10);
        long time = System.currentTimeMillis();
        try {
            FileInputStream fis = new FileInputStream(filename);
            FwkColumnAccessInterface[] result = reader.read(filename, fis);
            System.out.println(result.length + " columns with " + result[1].getCount() + " values read.");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("elapsed time: " + (System.currentTimeMillis() - time) + "ms");
    }

    public static class MessagePrinter
    extends FwkMessageListener {
        public void messageOccured(FwkMessageEventInterface ev) {
            System.out.println("[" + ev.getID() + "] " + ev.getMessage());
        }
    }

    protected class InvalidValue {
        public int atRow;
        public int atCol;

        public InvalidValue(int atCol, int atRow) {
            this.atCol = atCol;
            this.atRow = atRow;
        }
    }

    public class DataObserver
    extends FwkColumnDataObserverDouble {
        int counter = 0;

        public void addValue(double v) {
            if (this.counter <= 0) {
                this.values = new double[4096];
                this.flags = new short[4096];
                Arrays.fill(this.flags, (short)0);
            }
            ++this.counter;
            while (this.counter >= this.values.length) {
                double[] tmp = new double[this.values.length + 4096];
                System.arraycopy(this.values, 0, tmp, 0, this.values.length);
                this.values = tmp;
                short[] tFlags = new short[this.flags.length + 4096];
                System.arraycopy(this.flags, 0, tFlags, 0, this.flags.length);
                this.flags = tFlags;
                Arrays.fill(this.flags, this.counter, this.flags.length - 1, (short)0);
            }
            this.values[this.counter - 1] = v;
            this.flags[this.counter - 1] = 15;
        }

        public int getCount() {
            return this.counter;
        }
    }
}

