/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataItemConsumer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkFileFilter;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkWriteColumnsToStreamInterface;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class FwkSimpleASCIIColumnsWriter
extends FwkFileFilter
implements FwkWriteColumnsToStreamInterface {
    public static final String EXTENSION = FwkPropertyBus.getProperty("FwkContainer.Text.ASCIIExtension", "asc");

    public void write(String ref, OutputStream os, FwkColumnAccessInterface[] cols) throws FwkException {
        try {
            int i;
            int size = cols.length;
            int[] len = new int[size];
            int max = 0;
            BufferedOutputStream ps = new BufferedOutputStream(os);
            StringBuffer header = new StringBuffer(1024);
            StringBuffer sb = new StringBuffer(1024);
            for (i = 0; i < size; ++i) {
                if (cols[i] == null) continue;
                len[i] = cols[i].getCount();
                max = Math.max(max, len[i]);
                header.append(cols[i].getColumnName() + "\t");
                sb.append(cols[i].getUnitString() + "\t");
            }
            header.append("\n");
            sb.append("\n");
            ps.write(header.toString().getBytes(), 0, header.length());
            ps.write(sb.toString().getBytes(), 0, sb.length());
            header.delete(0, header.length());
            sb.delete(0, sb.length());
            for (i = 0; i < max; ++i) {
                for (int count = 0; count < size; ++count) {
                    if (cols[count] == null) continue;
                    if (i < len[count] && cols[count].getFlagAt(i) == 15) {
                        sb.append("" + cols[count].getValueAt(i) + "\t");
                        continue;
                    }
                    sb.append("undefined\t");
                }
                if (sb.length() == 0) continue;
                sb.append("\n");
                ps.write(sb.toString().getBytes(), 0, sb.length());
                sb.delete(0, sb.length());
            }
            ps.flush();
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: FwkSimpleASCIIColumnsWriter.java,v $", "$Revision", "AH 2001-10-29 11:38", FwkPropertyBus.getProperty("FwkContainer.Text.Error_ReadFile"), this, t);
        }
    }

    public boolean accept(File f) {
        boolean ret = false;
        if (f != null && !(ret = f.isDirectory())) {
            ret = EXTENSION.compareTo(this.getExtension(f)) == 0;
        }
        return ret;
    }

    public String getDescription() {
        return FwkPropertyBus.getProperty("FwkContainer.Description.ColumnASCIIFile") + " (*." + EXTENSION + ")";
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkSimpleASCIIColumnsWriter writer = new FwkSimpleASCIIColumnsWriter();
        try {
            Object[] obj = FwkDataItemConsumer.getInstance().findMultipleDataItems("*");
            if (obj != null && obj.length != 0) {
                FwkColumnAccessInterface[] arr = new FwkColumnAccessInterface[obj.length];
                for (int i = 0; i < obj.length; ++i) {
                    arr[i] = (FwkColumnAccessInterface)obj[i];
                }
                long time = System.currentTimeMillis();
                writer.write("c:/temp/junk.asc", new FileOutputStream("c:/temp/junk.asc"), arr);
                System.out.println("elapsed time " + (System.currentTimeMillis() - time));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(0);
    }
}

