/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import com.highqsoft.interfaces.fwk.FwkExecuteStateEventInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateListenerInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class FwkStatusLabel
extends JLabel
implements AncestorListener,
WindowListener,
ComponentListener,
FwkExecuteStateListenerInterface {
    public static final String version = "$Revision: 1.4 $";
    protected final int STEPSIZE = 5;
    protected Container ancestor;
    protected Image busyImage = null;
    protected Object imageLock = new Object();
    protected HashMap map;
    protected int busyCounter = 0;
    protected int busyPos = 0;
    protected int busyWidth = 0;
    protected boolean forward;
    protected Color stripColor;
    protected String initialText;
    protected Thread thread;
    protected int lightCounter = 0;

    public String getVersion() {
        return version;
    }

    public FwkStatusLabel() {
        this.setForeground(Color.red.darker());
        this.setText("");
        this.setStripColor(Color.blue);
        this.thread = null;
        this.ancestor = null;
        this.forward = true;
        this.map = new HashMap();
        this.addComponentListener(this);
    }

    public void release() {
    }

    public void setStripColor(Color color) {
        Color old = this.stripColor;
        this.stripColor = color;
        this.firePropertyChange("StripColor", old, color);
    }

    public Color getStriColor() {
        return this.stripColor;
    }

    public void setText(String text) {
        this.initialText = text;
        super.setText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createBusyImage() {
        Object object = this.imageLock;
        synchronized (object) {
            Dimension dim = this.getSize();
            if (dim.height > 0 && dim.width > 0) {
                this.busyWidth = Math.min(dim.width / 2, 100);
                this.busyImage = this.createImage(this.busyWidth, dim.height);
                if (this.busyImage != null) {
                    Color bg = this.getBackground();
                    Graphics g = this.busyImage.getGraphics();
                    int half = this.busyWidth / 2;
                    int rb = bg.getRed();
                    int gb = bg.getGreen();
                    int bb = bg.getBlue();
                    float rf = (float)(this.stripColor.getRed() - rb) / (float)half;
                    float gf = (float)(this.stripColor.getGreen() - gb) / (float)half;
                    float bf = (float)(this.stripColor.getBlue() - bb) / (float)half;
                    ++half;
                    for (int i = 0; i < half; ++i) {
                        g.setColor(new Color((int)((float)rb + rf * (float)i), (int)((float)gb + gf * (float)i), (int)((float)bb + bf * (float)i)));
                        g.drawLine(i, 0, i, dim.height);
                        g.drawLine(this.busyWidth - i, 0, this.busyWidth - i, dim.height);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBusyImage(long time) {
        Object object = this.imageLock;
        synchronized (object) {
            if (this.busyImage != null) {
                Dimension dim = this.getSize();
                if (dim.width != 0 && dim.height != 0) {
                    Image offscreen = this.createImage(dim.width, dim.height);
                    Graphics gos = offscreen.getGraphics();
                    gos.setColor(this.getBackground());
                    gos.fillRect(0, 0, dim.width, dim.height);
                    gos.drawImage(this.busyImage, this.busyPos, 0, this);
                    this.lightCounter %= 20;
                    if (this.lightCounter < 15) {
                        int lightPos = this.busyPos + this.busyWidth / 2;
                        gos.setColor(Color.cyan.darker().darker());
                        gos.fillRect(lightPos - 5, 0, 10, dim.height);
                        gos.setColor(Color.cyan.darker());
                        gos.fillRect(lightPos - 4, 0, 8, dim.height);
                        gos.setColor(Color.cyan);
                        gos.fillRect(lightPos - 3, 0, 6, dim.height);
                    }
                    ++this.lightCounter;
                    gos.setColor(new Color(1.0f, 0.5f, 0.5f));
                    Font font = this.getFont();
                    font = new Font(font.getName(), 1, (int)((double)dim.height * 0.75));
                    FontRenderContext frc = ((Graphics2D)gos).getFontRenderContext();
                    TextLayout layout = new TextLayout("" + time / 1000L + ":" + time % 1000L * 60L / 1000L, font, frc);
                    layout.draw((Graphics2D)gos, (int)((double)this.busyPos + ((double)this.busyWidth - layout.getBounds().getWidth()) / 2.0), 3 * dim.height / 4);
                    this.paint(gos);
                    gos = this.getGraphics();
                    gos.drawImage(offscreen, 0, 0, this);
                    if (this.forward) {
                        if (this.busyPos + 5 + this.busyWidth > dim.width) {
                            this.forward = false;
                            this.busyPos -= 5;
                        } else {
                            this.busyPos += 5;
                        }
                    } else if (this.busyPos > 5) {
                        this.busyPos -= 5;
                    } else {
                        this.forward = true;
                        this.busyPos += 5;
                    }
                }
            }
        }
    }

    public boolean getBusy() {
        return this.busyCounter > 0;
    }

    public void setBusy(boolean flag) {
        boolean old = this.getBusy();
        if (flag) {
            ++this.busyCounter;
            if (!old) {
                this.createBusyImage();
                this.startThread();
            }
        } else if (old) {
            --this.busyCounter;
            if (!this.getBusy()) {
                this.stopThread();
                this.map.clear();
                super.setText(this.initialText);
                this.busyPos = 0;
            }
        }
        if (old != this.getBusy()) {
            this.firePropertyChange("Busy", old, flag);
        }
    }

    protected void stopThread() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    protected void startThread() {
        if (this.getBusy() && this.busyImage != null && this.thread == null) {
            BusyThread thread = new BusyThread();
            thread.start();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.stopThread();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
        this.startThread();
    }

    public void windowIconified(WindowEvent e) {
        this.stopThread();
    }

    public void windowOpened(WindowEvent e) {
        this.startThread();
    }

    public void componentHidden(ComponentEvent e) {
        this.stopThread();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.stopThread();
        this.createBusyImage();
        this.startThread();
    }

    public void componentShown(ComponentEvent e) {
        this.startThread();
    }

    public void ancestorAdded(AncestorEvent event) {
        if (this.ancestor == null) {
            this.ancestor = this.getTopLevelAncestor();
            if (this.ancestor != null && this.ancestor instanceof Window) {
                ((Window)this.ancestor).addWindowListener(this);
            }
        }
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void ancestorRemoved(AncestorEvent event) {
        if (this.ancestor != null) {
            ((Window)this.ancestor).removeWindowListener(this);
        }
    }

    public void executeStateChanged(FwkExecuteStateEventInterface ev) {
        String msg = ev.getMessage().trim();
        switch (ev.getState()) {
            case 2: {
                this.setBusy(true);
                if (msg.length() == 0) break;
                this.map.put(ev.getSource(), msg);
                break;
            }
            case 5: {
                this.setBusy(false);
                if (msg.length() == 0) break;
                this.map.put(ev.getSource(), msg);
                break;
            }
            case 0: 
            case 4: {
                this.setBusy(false);
                this.map.remove(ev.getSource());
                break;
            }
        }
        if (this.getBusy()) {
            String text;
            if (this.map.size() != 0) {
                Iterator it = this.map.keySet().iterator();
                text = "";
                try {
                    while (it.hasNext()) {
                        text = text + "[" + this.map.get(it.next()) + "]";
                    }
                }
                catch (ConcurrentModificationException e) {
                    return;
                }
            } else {
                text = this.initialText;
            }
            super.setText(text);
        }
        this.repaint();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        JPanel panel = new JPanel(new BorderLayout());
        FwkStatusLabel label = new FwkStatusLabel();
        panel.add("Center", label);
        panel.setSize(new Dimension(400, 30));
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add("Center", panel);
        frame.setSize(new Dimension(400, 50));
        label.setText("Das ist ein Status");
        label.setBusy(true);
        frame.setVisible(true);
    }

    protected class BusyThread
    extends Thread {
        public BusyThread() {
            this.setPriority(10);
        }

        public void run() {
            long time = System.currentTimeMillis();
            try {
                while (FwkStatusLabel.this.getBusy()) {
                    FwkStatusLabel.this.updateBusyImage(System.currentTimeMillis() - time);
                    BusyThread.sleep(50L);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

