/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import com.highqsoft.fwk.util.StringUtilities;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.text.View;

public class FwkToolTipUI
extends BasicToolTipUI {
    static FwkToolTipUI sharedInstance = new FwkToolTipUI();

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    protected String[] getTextArray(JComponent c) {
        String tipText = ((JToolTip)c).getTipText();
        String[] ret = tipText != null && tipText.length() > 0 ? StringUtilities.split(tipText.replace('\t', ' '), 10, false) : new String[]{""};
        return ret;
    }

    public void paint(Graphics g, JComponent c) {
        Font font = c.getFont();
        FontRenderContext frc = new FontRenderContext(null, true, true);
        Dimension size = c.getSize();
        g.setColor(c.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(c.getForeground());
        g.setFont(font);
        View v = (View)c.getClientProperty("html");
        String[] text = this.getTextArray(c);
        int len = text.length;
        for (int i = 0; i < len; ++i) {
            if (v != null) {
                Rectangle paintTextR = c.getBounds();
                Insets insets = c.getInsets();
                paintTextR.x += insets.left;
                paintTextR.y += insets.top;
                paintTextR.width -= insets.left + insets.right;
                paintTextR.height -= insets.top + insets.bottom;
                v.paint(g, paintTextR);
                continue;
            }
            LineMetrics lm = font.getLineMetrics(text[i], frc);
            g.drawString(text[i], 3, (int)Math.ceil(lm.getAscent() + lm.getHeight() * (float)i));
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        View v;
        Font font = c.getFont();
        FontRenderContext frc = new FontRenderContext(null, true, true);
        Insets insets = c.getInsets();
        Dimension prefSize = new Dimension(insets.left + insets.right, insets.top + insets.bottom + 4);
        String[] text = this.getTextArray(c);
        int size = text.length;
        View view = v = c != null ? (View)c.getClientProperty("html") : null;
        if (v != null) {
            prefSize.width += (int)v.getPreferredSpan(0);
            prefSize.height += (int)v.getPreferredSpan(1);
        } else {
            for (int i = 0; i < size; ++i) {
                TextLayout tl = text[i].length() > 0 ? new TextLayout(text[i], font, frc) : new TextLayout(" ", font, frc);
                Rectangle2D rect = tl.getBounds();
                prefSize.width = (int)Math.ceil(Math.max((double)prefSize.width, rect.getWidth() + 6.0));
                prefSize.height = (int)((double)prefSize.height + (rect.getHeight() + rect.getX() + 1.0));
            }
            ++prefSize.height;
        }
        return prefSize;
    }
}

