/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.plaf.PanelUI;

public class HQSPanel
extends JPanel {
    public static final int TYPE_RGB = 0;
    public static final int TYPE_GBR = 1;
    public static final int TYPE_BRG = 2;
    public static final int TYPE_GRB = 3;
    public static final int TYPE_RBG = 4;
    public static final int TYPE_BGR = 5;
    public static final int TYPE_QUESTION = 10;
    public static final int TYPE_INFO = 11;
    public static final int TYPE_ERROR = 12;
    public static final int TYPE_FATAL = 13;
    public static final int TYPE_MESSAGE = 14;
    public static final int TYPE_WARNING = 15;
    public static final int TYPE_CONFIG = 16;
    protected static BufferedImage rgbImage;
    protected static BufferedImage gbrImage;
    protected static BufferedImage brgImage;
    protected static BufferedImage grbImage;
    protected static BufferedImage rbgImage;
    protected static BufferedImage bgrImage;
    protected static String PACKAGE_PATH;
    public static final String ICON_INFO;
    public static final String ICON_ERROR;
    public static final String ICON_FATAL;
    public static final String ICON_MESSAGE;
    public static final String ICON_WARNING;
    public static final String ICON_CONFIG;
    public static final String ICON_QUESTION;
    int type = 0;
    int lineDistance = 2;
    int lineHeight = 4;
    ImageIcon icon = null;
    BufferedImage buffer = null;
    String text;
    Font font;

    public HQSPanel() {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setFont(new Font("Helvetica", 1, 20));
        this.setUI(new HQSPanelUI());
    }

    public HQSPanel(int type) {
        this();
        if (type >= 10) {
            if (type < 16) {
                this.type = type - 10;
            }
            switch (type) {
                case 11: {
                    this.setIcon(PACKAGE_PATH + "/info.gif");
                    break;
                }
                case 12: {
                    this.setIcon(PACKAGE_PATH + "/attention.gif");
                    break;
                }
                case 13: {
                    this.setIcon(PACKAGE_PATH + "/bomb.gif");
                    break;
                }
                case 14: {
                    this.setIcon(PACKAGE_PATH + "/hawk.gif");
                    break;
                }
                case 15: {
                    this.setIcon(PACKAGE_PATH + "/x.gif");
                    break;
                }
                case 16: {
                    this.setIcon(PACKAGE_PATH + "/gear.gif");
                    this.type = 1;
                    break;
                }
                default: {
                    this.setIcon(PACKAGE_PATH + "/question.gif");
                    break;
                }
            }
        } else {
            this.type = type;
        }
    }

    public Dimension getPreferredSize() {
        if (rgbImage != null) {
            return new Dimension(rgbImage.getWidth(), rgbImage.getHeight());
        }
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setLineHeight(int height) {
        this.lineHeight = height;
    }

    public void setLineDistance(int distance) {
        this.lineDistance = distance;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public BufferedImage getImage() {
        return this.getImage(this.type);
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public void setIcon(String resource) {
        try {
            URL url = HQSPanel.class.getClassLoader().getResource(resource);
            if (url == null) {
                url = HQSPanel.class.getClassLoader().getResource(PACKAGE_PATH + "/" + resource);
            }
            if (url != null) {
                this.setIcon(new ImageIcon(ImageIO.read(url)));
            } else {
                this.setIcon((ImageIcon)null);
            }
        }
        catch (Throwable t) {
            this.icon = null;
        }
    }

    public BufferedImage getImage(int type) {
        int w = rgbImage.getWidth();
        int h = rgbImage.getHeight();
        switch (type) {
            case 1: {
                if (gbrImage == null) {
                    gbrImage = new BufferedImage(w, h, 5);
                    for (int x = 0; x < w; ++x) {
                        for (int y = 0; y < h; ++y) {
                            int rgb = rgbImage.getRGB(x, y);
                            gbrImage.setRGB(x, y, rgb & 0xFF000000 | (rgb & 0xFF0000) >> 16 | (rgb & 0xFF) << 8 | (rgb & 0xFF00) << 8);
                        }
                    }
                }
                return gbrImage;
            }
            case 2: {
                if (brgImage == null) {
                    brgImage = new BufferedImage(w, h, 5);
                    for (int x = 0; x < w; ++x) {
                        for (int y = 0; y < h; ++y) {
                            int rgb = rgbImage.getRGB(x, y);
                            brgImage.setRGB(x, y, rgb & 0xFF000000 | (rgb & 0xFF0000) >> 8 | (rgb & 0xFF) << 16 | (rgb & 0xFF00) >> 8);
                        }
                    }
                }
                return brgImage;
            }
            case 3: {
                if (grbImage == null) {
                    grbImage = new BufferedImage(w, h, 5);
                    for (int x = 0; x < w; ++x) {
                        for (int y = 0; y < h; ++y) {
                            int rgb = rgbImage.getRGB(x, y);
                            grbImage.setRGB(x, y, rgb & 0xFF000000 | rgb & 0xFF | (rgb & 0xFF00) << 8 | (rgb & 0xFF0000) >> 8);
                        }
                    }
                }
                return grbImage;
            }
            case 4: {
                if (rbgImage == null) {
                    rbgImage = new BufferedImage(w, h, 5);
                    for (int x = 0; x < w; ++x) {
                        for (int y = 0; y < h; ++y) {
                            int rgb = rgbImage.getRGB(x, y);
                            rbgImage.setRGB(x, y, rgb & 0xFF000000 | rgb & 0xFF0000 | (rgb & 0xFF) << 8 | (rgb & 0xFF00) >> 8);
                        }
                    }
                }
                return rbgImage;
            }
            case 5: {
                if (bgrImage == null) {
                    bgrImage = new BufferedImage(w, h, 5);
                    for (int x = 0; x < w; ++x) {
                        for (int y = 0; y < h; ++y) {
                            int rgb = rgbImage.getRGB(x, y);
                            bgrImage.setRGB(x, y, rgb & 0xFF000000 | rgb & 0xFF00 | (rgb & 0xFF) << 16 | (rgb & 0xFF0000) >> 16);
                        }
                    }
                }
                return bgrImage;
            }
        }
        return rgbImage;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        System.out.println(HQSPanel.class.getPackage().getName() + " " + HQSPanel.class.getName().replace('.', '/') + ".jpg");
        HQSPanel gt = new HQSPanel(14);
        gt.setText("Message");
        panel.add((Component)gt, gbc);
        ++gbc.gridy;
        gt = new HQSPanel(13);
        gt.setText("Fatal");
        panel.add((Component)gt, gbc);
        ++gbc.gridy;
        gt = new HQSPanel(12);
        gt.setText("Error");
        panel.add((Component)gt, gbc);
        ++gbc.gridy;
        gt = new HQSPanel(11);
        gt.setText("Info");
        panel.add((Component)gt, gbc);
        ++gbc.gridy;
        gt = new HQSPanel(10);
        gt.setText("Question\nAndy");
        panel.add((Component)gt, gbc);
        ++gbc.gridy;
        gt = new HQSPanel(15);
        gt.setText("Warning");
        panel.add((Component)gt, gbc);
        ++gbc.gridy;
        gt = new HQSPanel(16);
        gt.setText("Konfiguration");
        panel.add((Component)gt, gbc);
        ++gbc.gridy;
        gt = new HQSPanel();
        gt.setIcon(ICON_CONFIG);
        panel.add((Component)gt, gbc);
        ++gbc.gridy;
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
    }

    static {
        PACKAGE_PATH = HQSPanel.class.getPackage().getName().replace('.', '/');
        try {
            rgbImage = ImageIO.read(HQSPanel.class.getClassLoader().getResource(PACKAGE_PATH + "/HQSPanel.jpg"));
            gbrImage = null;
            brgImage = null;
            grbImage = null;
            rbgImage = null;
            bgrImage = null;
        }
        catch (Throwable t) {
            rgbImage = new BufferedImage(512, 100, 5);
            int w = rgbImage.getWidth();
            int h = rgbImage.getHeight();
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    int rgb = (512 - x) / 2;
                    rgbImage.setRGB(x, y, 0xFF000000 | rgb << 16 | rgb << 8 | rgb);
                }
            }
        }
        ICON_INFO = PACKAGE_PATH + "/info.gif";
        ICON_ERROR = PACKAGE_PATH + "/attention.gif";
        ICON_FATAL = PACKAGE_PATH + "/bomb.gif";
        ICON_MESSAGE = PACKAGE_PATH + "/hawk.gif";
        ICON_WARNING = PACKAGE_PATH + "/x.gif";
        ICON_CONFIG = PACKAGE_PATH + "/gear.gif";
        ICON_QUESTION = PACKAGE_PATH + "/question.gif";
    }

    protected class HQSPanelUI
    extends PanelUI {
        protected HQSPanelUI() {
        }

        public void paint(Graphics gr, JComponent c) {
            super.paint(gr, c);
            if (HQSPanel.this.buffer == null) {
                Dimension dim = c.getPreferredSize();
                HQSPanel.this.buffer = new BufferedImage(dim.width, dim.height, 5);
                Graphics2D g = HQSPanel.this.buffer.createGraphics();
                BufferedImage image = HQSPanel.this.getImage();
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int ih = image.getHeight();
                int iw = image.getWidth();
                int delta = HQSPanel.this.lineDistance;
                int lh = HQSPanel.this.lineHeight;
                int n = (ih - delta) / (delta + lh);
                int startY = (ih - delta - n * (delta + lh)) / 2 + delta;
                int startX = 0;
                g.drawImage((Image)image, 0, 0, null);
                Color endColor = new Color(255, 255, 255, 0);
                Color startColor = c.getBackground();
                GradientPaint gradient = new GradientPaint(startX, 0.0f, startColor, iw, 0.0f, endColor);
                g.setPaint(gradient);
                for (int i = 0; i < n; ++i) {
                    g.fillRect(startX, startY + i * (lh + delta), dim.width, lh);
                }
                int textOffset = 10;
                if (HQSPanel.this.icon != null) {
                    try {
                        int y;
                        int x = y = (ih - HQSPanel.this.icon.getIconHeight()) / 2;
                        g.drawImage(HQSPanel.this.icon.getImage(), x, y, null);
                        textOffset += x + HQSPanel.this.icon.getIconWidth();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (HQSPanel.this.text != null) {
                    g.setPaint(HQSPanel.this.getForeground());
                    TextLayout layout = null;
                    float ali = 0.0f;
                    FontRenderContext frc = new FontRenderContext(null, true, true);
                    int wrappingWidth = dim.width - textOffset - 10;
                    if (wrappingWidth > 0) {
                        AttributedString str;
                        int i;
                        int yOffset;
                        String[] arr = HQSPanel.this.text.split("\n");
                        int nLines = 0;
                        float ascent = 0.0f;
                        for (int i2 = 0; i2 < arr.length; ++i2) {
                            if (arr[i2].trim().length() > 0) {
                                AttributedString str2 = new AttributedString(arr[i2]);
                                str2.addAttribute(TextAttribute.FONT, HQSPanel.this.getFont());
                                AttributedCharacterIterator iter = str2.getIterator();
                                LineBreakMeasurer measurer = new LineBreakMeasurer(iter, frc);
                                while (measurer.getPosition() < iter.getEndIndex()) {
                                    layout = measurer.nextLayout(wrappingWidth);
                                    ++nLines;
                                    ascent = layout.getAscent() + layout.getDescent() + layout.getLeading();
                                }
                                continue;
                            }
                            ++nLines;
                        }
                        int yPos = yOffset = (dim.height - Math.round((float)nLines * ascent - ascent * 1.5f)) / 2;
                        int xPos = textOffset;
                        for (i = 0; i < arr.length; ++i) {
                            if (arr[i].trim().length() > 0) {
                                str = new AttributedString(arr[i]);
                                str.addAttribute(TextAttribute.FONT, HQSPanel.this.getFont());
                                AttributedCharacterIterator iter = str.getIterator();
                                LineBreakMeasurer measurer = new LineBreakMeasurer(iter, frc);
                                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                while (measurer.getPosition() < iter.getEndIndex()) {
                                    layout = measurer.nextLayout(wrappingWidth);
                                    layout.draw(g, (float)xPos + ali * ((float)wrappingWidth - layout.getAdvance()), yPos);
                                    yPos = (int)((float)yPos + (layout.getAscent() + layout.getDescent() + layout.getLeading()));
                                }
                                continue;
                            }
                            if (layout == null) continue;
                            yPos = (int)((float)yPos + (layout.getAscent() + layout.getDescent() + layout.getLeading()));
                        }
                        g.setPaint(new Color(0, 0, 0, 128));
                        yPos = yOffset + 1;
                        xPos = textOffset + 1;
                        for (i = 0; i < arr.length; ++i) {
                            str = new AttributedString(arr[i]);
                            str.addAttribute(TextAttribute.FONT, HQSPanel.this.getFont());
                            AttributedCharacterIterator iter = str.getIterator();
                            LineBreakMeasurer measurer = new LineBreakMeasurer(iter, frc);
                            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            while (measurer.getPosition() < iter.getEndIndex()) {
                                layout = measurer.nextLayout(wrappingWidth);
                                layout.draw(g, (float)xPos + ali * ((float)wrappingWidth - layout.getAdvance()), yPos);
                                yPos = (int)((float)yPos + (layout.getAscent() + layout.getDescent() + layout.getLeading()));
                            }
                        }
                    }
                }
                g.dispose();
            }
            Graphics2D g = (Graphics2D)gr.create();
            g.drawImage((Image)HQSPanel.this.buffer, 0, 0, null);
            g.dispose();
        }
    }
}

