/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.util.IniFileSection;
import com.highqsoft.fwk.util.IniFileSectionEntry;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;

public class IniFile {
    public static final String version = "$Revision: 1.3 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    public static final int EMPTY = 0;
    public static final int COMMENT = 1;
    public static final int HEADER = 2;
    public static final int ENTRY = 3;
    protected ArrayList sectionList = new ArrayList();
    protected Hashtable sectionHash = new Hashtable();
    protected IniFileSection currentSection;
    protected File iniFile;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    public IniFile() {
    }

    public IniFile(String filename) {
        this();
        this.read(filename);
    }

    public IniFile(URL url) {
        this();
        this.read(url);
    }

    public int getSectionCount() {
        return this.sectionList.size();
    }

    public File getFile() {
        return this.iniFile;
    }

    public ArrayList listSections(String pattern) {
        ArrayList<String> sectionNames = new ArrayList<String>();
        int sectionCount = this.sectionList.size();
        boolean noCompare = pattern == null || pattern.length() == 0 || pattern.compareTo("*") == 0;
        for (int i = 0; i < sectionCount; ++i) {
            IniFileSection section = (IniFileSection)this.sectionList.get(i);
            if (section == null) continue;
            String sectionName = section.getSectionName();
            if (noCompare) {
                sectionNames.add(sectionName);
                continue;
            }
            if (!Pattern.match(sectionName, pattern, true)) continue;
            sectionNames.add(sectionName);
        }
        return sectionNames;
    }

    public void read(String filename) {
        this.iniFile = new File(filename);
        if (this.iniFile.exists() && this.iniFile.canRead()) {
            try {
                this.read(new FileReader(this.iniFile));
            }
            catch (IOException ioex) {
                System.err.println(ioex.toString());
            }
        }
    }

    public void read(URL url) {
        try {
            this.read(new InputStreamReader(url.openStream()));
        }
        catch (IOException ioex) {
            System.err.println(ioex.toString());
        }
    }

    public void read(InputStreamReader fileReader) {
        try {
            String line;
            this.currentSection = new IniFileSection();
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                this.parseToSection(line.trim());
            }
            fileReader.close();
        }
        catch (IOException ioex) {
            System.err.println(ioex.toString());
        }
    }

    public void write(String filename) {
        this.iniFile = new File(filename);
        if (!this.iniFile.exists() || this.iniFile.canWrite()) {
            try {
                FileOutputStream fos = new FileOutputStream(this.iniFile);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                PrintWriter printWriter = new PrintWriter(bos);
                for (int j = 0; j < this.sectionList.size(); ++j) {
                    this.currentSection = (IniFileSection)this.sectionList.get(j);
                    this.currentSection.sortSectionEntries(true);
                    int entryCount = this.currentSection.getSectionEntryCount();
                    boolean headerDone = false;
                    int maxLength = this.currentSection.getMaximumSectionEntryNameLength();
                    for (int i = 0; i < entryCount; ++i) {
                        int n;
                        IniFileSectionEntry se = this.currentSection.getSectionEntry(i);
                        String comment = se.getComment();
                        String entryName = se.getName();
                        String entryValue = se.getValue();
                        int type = se.getType();
                        if (type != 2 && !headerDone) {
                            printWriter.println("[" + this.currentSection.getSectionName() + "]");
                            headerDone = true;
                        }
                        if (comment != null) {
                            if (entryName != null) {
                                printWriter.print(entryName);
                                for (n = maxLength - entryName.length(); n > 0; --n) {
                                    printWriter.print(" ");
                                }
                                printWriter.println("= \"" + entryValue + "\" " + comment);
                                continue;
                            }
                            printWriter.println(comment);
                            continue;
                        }
                        if (entryName != null) {
                            printWriter.print(entryName);
                            for (n = maxLength - entryName.length(); n > 0; --n) {
                                printWriter.print(" ");
                            }
                            printWriter.println(" = \"" + entryValue + "\"");
                            continue;
                        }
                        printWriter.println("");
                    }
                }
                printWriter.close();
            }
            catch (IOException ioex) {
                System.err.println(ioex.toString());
            }
        }
    }

    protected void parseToSection(String line) {
        int pos;
        int i;
        boolean inComment = false;
        boolean inString = false;
        for (i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == ';' && !inString) {
                inComment = true;
                break;
            }
            if (c != '\"') continue;
            inString = !inString;
        }
        IniFileSectionEntry sectionEntry = null;
        if (inComment) {
            sectionEntry = this.currentSection.setSectionComment(line.substring(i));
            if ((line = line.substring(0, i).trim()).length() == 0) {
                return;
            }
        }
        if (line.length() > 0 && line.charAt(0) == '[' && (pos = line.indexOf(93)) > 0) {
            String sectionName;
            if (this.currentSection.getSectionName() != null) {
                IniFileSection newSection = new IniFileSection();
                int count = this.currentSection.getSectionEntryCount();
                if (count > 0) {
                    int type;
                    int k = count;
                    for (k = count - 1; k >= 0 && ((type = this.currentSection.getSectionEntry(k).getType()) == 0 || type == 1); --k) {
                    }
                    int ksave = ++k;
                    while (k < count) {
                        IniFileSectionEntry moveEntry = this.currentSection.getSectionEntry(k);
                        moveEntry.setType(2);
                        newSection.setSectionEntry(moveEntry);
                        ++k;
                    }
                    for (k = count - 1; k >= ksave; --k) {
                        this.currentSection.removeSectionEntry(k);
                    }
                }
                this.currentSection = newSection;
            }
            if ((sectionName = line.substring(1, pos)).length() > 0) {
                this.currentSection.setSectionName(sectionName);
                if (this.sectionHash.get(sectionName) == null) {
                    this.sectionList.add(this.currentSection);
                }
                this.sectionHash.put(sectionName, this.currentSection);
            }
            return;
        }
        pos = line.indexOf(61);
        if (line.length() > 0 && pos > 0) {
            String entryName = line.substring(0, pos).trim();
            String entryValue = line.substring(pos + 1).trim();
            if (entryValue.startsWith("\"")) {
                entryValue = entryValue.substring(1);
            }
            if (entryValue.endsWith("\"")) {
                entryValue = entryValue.substring(0, entryValue.length() - 1);
            }
            if (sectionEntry == null) {
                sectionEntry = this.currentSection.setSectionEntry(entryName, entryValue);
            } else {
                sectionEntry.setName(entryName);
                sectionEntry.setValue(entryValue);
            }
            sectionEntry.setType(3);
        } else {
            this.currentSection.setSectionComment(line);
        }
    }

    public static void main(String[] args) {
        IniFile iniFile = new IniFile();
        iniFile.read("Avalon.ini");
        iniFile.write("Otto.ini");
    }

    static {
        descriptor.setAuthor("Hans-Joachim Bothe");
        descriptor.setBuild(version);
        descriptor.setDescription("Initialization File Handler");
        descriptor.setTitleName("");
        descriptor.setName(IniFile.class.getName());
        descriptor.setCreationDate("$Date: 2005/01/04 08:10:21 $", null);
    }
}

