/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.util.IniFileSectionEntry;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;

public class IniFileSection {
    public static final String version = "$Revision: 1.3 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    protected ArrayList sectionEntryList = new ArrayList();
    protected Hashtable sectionEntryHash = new Hashtable();
    protected String sectionName = null;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    public int getMaximumSectionEntryNameLength() {
        int maxLength = 0;
        for (int i = 0; i < this.sectionEntryList.size(); ++i) {
            int nameLength;
            String sectionEntryName;
            IniFileSectionEntry sectionEntry = (IniFileSectionEntry)this.sectionEntryList.get(i);
            if (sectionEntry.getType() != 3 || (sectionEntryName = sectionEntry.getName()) == null || maxLength >= (nameLength = sectionEntryName.length())) continue;
            maxLength = nameLength;
        }
        return maxLength;
    }

    public IniFileSectionEntry getSectionEntry(String name) {
        return (IniFileSectionEntry)this.sectionEntryHash.get(name);
    }

    public IniFileSectionEntry getSectionEntry(int sectionEntryPosition) {
        if (sectionEntryPosition >= 0 && sectionEntryPosition < this.sectionEntryList.size()) {
            return (IniFileSectionEntry)this.sectionEntryList.get(sectionEntryPosition);
        }
        return null;
    }

    public int getSectionEntryCount() {
        return this.sectionEntryList.size();
    }

    public int getSectionEntryPosition(String name) {
        IniFileSectionEntry sectionEntry;
        int sectionEntryPosition = -1;
        if (name != null && name.length() > 0 && (sectionEntry = (IniFileSectionEntry)this.sectionEntryHash.get(name)) != null) {
            sectionEntryPosition = this.sectionEntryList.indexOf(sectionEntry);
        }
        return sectionEntryPosition;
    }

    public int getSectionEntryPosition(IniFileSectionEntry sectionEntry) {
        int sectionEntryPosition = -1;
        if (sectionEntry != null) {
            sectionEntryPosition = this.getSectionEntryPosition(sectionEntry.getName());
        }
        return sectionEntryPosition;
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public void removeSectionEntry(String name) {
        int sectionEntryPosition = this.getSectionEntryPosition(name);
        if (sectionEntryPosition != -1) {
            this.sectionEntryList.remove(sectionEntryPosition);
            this.sectionEntryHash.remove(name);
        }
    }

    public void removeSectionEntry(int sectionEntryPosition) {
        if (sectionEntryPosition >= 0 && sectionEntryPosition < this.sectionEntryList.size()) {
            IniFileSectionEntry sectionEntry = (IniFileSectionEntry)this.sectionEntryList.get(sectionEntryPosition);
            this.sectionEntryList.remove(sectionEntryPosition);
            String sectionName = sectionEntry.getName();
            if (sectionName != null) {
                this.sectionEntryHash.remove(sectionName);
            }
        }
    }

    public void removeSectionEntry(IniFileSectionEntry sectionEntry) {
        this.removeSectionEntry(sectionEntry.getName());
    }

    public void renameSectionEntry(String oldName, String newName) {
        IniFileSectionEntry sectionEntry = (IniFileSectionEntry)this.sectionEntryHash.get(oldName);
        if (sectionEntry != null) {
            sectionEntry.setName(newName);
        }
    }

    public IniFileSectionEntry setSectionComment(String comment) {
        IniFileSectionEntry sectionEntry = new IniFileSectionEntry();
        if (comment != null && comment.length() > 0) {
            sectionEntry.setComment(comment);
            sectionEntry.setType(1);
        } else {
            sectionEntry.setType(0);
        }
        if (this.sectionName == null) {
            sectionEntry.setType(2);
        }
        this.setSectionEntry(sectionEntry);
        return sectionEntry;
    }

    public IniFileSectionEntry setSectionEntry(String name, String value) {
        IniFileSectionEntry sectionEntry = null;
        if (name != null && name.length() > 0) {
            sectionEntry = (IniFileSectionEntry)this.sectionEntryHash.get(name);
            if (sectionEntry == null) {
                sectionEntry = new IniFileSectionEntry();
                sectionEntry.setName(name);
                sectionEntry.setValue(value);
                this.sectionEntryHash.put(name, sectionEntry);
                this.sectionEntryList.add(sectionEntry);
            } else {
                sectionEntry.setValue(value);
            }
        }
        return sectionEntry;
    }

    public void setSectionEntry(IniFileSectionEntry sectionEntry) {
        if (sectionEntry != null) {
            String name = sectionEntry.getName();
            IniFileSectionEntry oldSectionEntry = null;
            if (name != null) {
                oldSectionEntry = (IniFileSectionEntry)this.sectionEntryHash.get(name);
            }
            if (oldSectionEntry == null) {
                this.sectionEntryList.add(sectionEntry);
            } else {
                int sectionEntryPosition = this.sectionEntryList.indexOf(oldSectionEntry);
                if (sectionEntryPosition != -1) {
                    this.sectionEntryList.set(sectionEntryPosition, sectionEntry);
                } else {
                    this.sectionEntryList.add(sectionEntry);
                }
            }
            if (name != null) {
                this.sectionEntryHash.put(name, sectionEntry);
            }
        }
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public void sortSectionEntries(boolean ascending) {
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i = 0; i < this.sectionEntryList.size(); ++i) {
            IniFileSectionEntry sectionEntry = (IniFileSectionEntry)this.sectionEntryList.get(i);
            if (sectionEntry.getType() != 3) continue;
            nameList.add(sectionEntry.getName());
            indexList.add(new Integer(i));
        }
        Object[] nameArray = nameList.toArray(new String[0]);
        Arrays.sort(nameArray);
        int nameCount = nameList.size();
        for (int i = 0; i < nameCount; ++i) {
            int entryPosition = ascending ? ((Integer)indexList.get(i)).intValue() : ((Integer)indexList.get(nameCount - i - 1)).intValue();
            IniFileSectionEntry sectionEntry = (IniFileSectionEntry)this.sectionEntryHash.get(nameArray[i]);
            this.sectionEntryList.set(entryPosition, sectionEntry);
        }
    }

    static {
        descriptor.setAuthor("Hans-Joachim Bothe");
        descriptor.setBuild(version);
        descriptor.setDescription("Initialization File Section Entry");
        descriptor.setTitleName("");
        descriptor.setName(IniFileSection.class.getName());
        descriptor.setCreationDate("$Date: 2005/01/04 08:10:21 $", null);
    }
}

