/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import com.highqsoft.fwk.Fwk;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.plaf.PanelUI;

public class MessageGUIFactory
extends Fwk {
    public static final String version = "$Revision: 1.4 $";
    protected static Image busyImage = null;

    public String getVersion() {
        return version;
    }

    private MessageGUIFactory() {
    }

    public static void createProgressFrame(String message) {
        message = FwkPropertyBus.getProperty(message, message);
        JFrame frame = new JFrame();
        JPanel panel = new JPanel();
        panel.setUI(new ImagePanelUI());
        panel.setPreferredSize(new Dimension(200, 20));
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setLocation(100, 100);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        MessageGUIFactory.createProgressFrame("junk");
    }

    protected static class ImagePanelUI
    extends PanelUI {
        Image busyImage = null;
        int counter = 0;
        int stepSize = 5;
        Thread thread = null;
        JComponent component;

        protected ImagePanelUI() {
        }

        public void setStepSize(int size) {
            this.stepSize = size;
        }

        public void createImage(Dimension dim) {
            if (this.busyImage == null || dim.width + dim.height != this.busyImage.getWidth(null) || dim.height != this.busyImage.getHeight(null)) {
                if (dim.width * dim.height == 0) {
                    return;
                }
                int busyWidth = dim.width + 2 * dim.height;
                int busyHeight = dim.height;
                this.busyImage = new BufferedImage(busyWidth, busyHeight, 1);
                Graphics2D g = (Graphics2D)this.busyImage.getGraphics();
                g.setColor(Color.red);
                int i = 0;
                while (i * busyHeight < busyWidth) {
                    GeneralPath path = new GeneralPath();
                    path.moveTo(i * busyHeight, 0.0f);
                    path.lineTo((i + 1) * busyHeight, 0.0f);
                    path.lineTo((i + 2) * busyHeight, busyHeight);
                    path.lineTo((i + 1) * busyHeight, busyHeight);
                    path.closePath();
                    g.fill(path);
                    i += 2;
                }
            }
        }

        public void paint(Graphics g, JComponent c) {
            Dimension size = c.getSize();
            this.createImage(size);
            if (this.busyImage != null) {
                g.drawImage(this.busyImage, 0, 0, size.width, size.height, this.counter, 0, size.width + this.counter, size.height, null);
                this.counter = this.counter + this.stepSize >= 2 * size.height ? 0 : (this.counter += this.stepSize);
            }
            this.component = c;
            if (this.thread == null) {
                this.thread = new Thread(new Runnable(){

                    public void run() {
                        boolean running = true;
                        while (running) {
                            ImagePanelUI.this.component.repaint();
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Throwable t) {
                                running = false;
                            }
                        }
                    }
                });
                this.thread.start();
            }
        }
    }
}

