/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import com.highqsoft.fwk.FwkContainer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.plaf.PanelUI;

public class StatusBarrel
extends JPanel {
    public static final int STEPSIZE = 2;
    public static final int SLEEPINGTIME = 50;
    Image busyImage = null;
    PanelUI idleUI = null;

    public StatusBarrel() {
        this.setForeground(new Color(0.19140625f, 0.38671875f, 0.609375f));
        this.idleUI = this.getUI();
        this.busy();
    }

    public void setSize(Dimension size) {
        super.setSize(size);
        this.busyImage = null;
    }

    public void busy() {
        PanelUI current = this.getUI();
        if (!(current instanceof ImagePanelUI)) {
            this.setUI(new ImagePanelUI());
        }
    }

    public void idle() {
        PanelUI current = this.getUI();
        if (current instanceof ImagePanelUI) {
            ImagePanelUI ui = (ImagePanelUI)current;
            ui.threadStopped = true;
            ui.thread = null;
            this.setUI(this.idleUI);
        }
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        JFrame frame = new JFrame();
        StatusBarrel pane = new StatusBarrel();
        frame.getContentPane().add(pane);
        frame.pack();
        frame.setVisible(true);
        try {
            Thread.sleep(5000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        pane.idle();
    }

    protected class ImagePanelUI
    extends PanelUI {
        int counter = 0;
        int stepSize = 2;
        Thread thread = null;
        boolean threadStopped = false;
        JComponent component;

        protected ImagePanelUI() {
        }

        public void setStepSize(int size) {
            this.stepSize = size;
        }

        protected void createImage(Dimension dim) {
            if (StatusBarrel.this.busyImage == null || dim.width + dim.height != StatusBarrel.this.busyImage.getWidth(null) || dim.height != StatusBarrel.this.busyImage.getHeight(null)) {
                if (dim.width * dim.height == 0) {
                    return;
                }
                int busyWidth = dim.width + 2 * dim.height;
                int busyHeight = dim.height;
                StatusBarrel.this.busyImage = new BufferedImage(busyWidth, busyHeight, 1);
                Graphics2D g = (Graphics2D)StatusBarrel.this.busyImage.getGraphics();
                g.setColor(StatusBarrel.this.getForeground());
                g.fillRect(0, 0, busyWidth, busyHeight);
                g.setColor(StatusBarrel.this.getBackground());
                int i = 0;
                while (i * busyHeight < busyWidth) {
                    GeneralPath path = new GeneralPath();
                    path.moveTo(i * busyHeight, 0.0f);
                    path.lineTo((i + 1) * busyHeight, 0.0f);
                    path.lineTo((i + 2) * busyHeight, busyHeight);
                    path.lineTo((i + 1) * busyHeight, busyHeight);
                    path.closePath();
                    g.fill(path);
                    i += 2;
                }
            }
        }

        public void paint(Graphics g, JComponent c) {
            Dimension size = c.getSize();
            this.createImage(size);
            if (StatusBarrel.this.busyImage != null) {
                g.drawImage(StatusBarrel.this.busyImage, 0, 0, size.width, size.height, this.counter, 0, size.width + this.counter, size.height, null);
                this.counter = this.counter + this.stepSize >= 2 * size.height ? 0 : (this.counter += this.stepSize);
            }
            this.component = c;
            if (this.thread == null) {
                this.thread = new Thread(new Runnable(){

                    public void run() {
                        Container container = ImagePanelUI.this.component.getTopLevelAncestor();
                        Window w = null;
                        if (container instanceof Window) {
                            // empty if block
                        }
                        while (!ImagePanelUI.this.threadStopped) {
                            ImagePanelUI.this.component.repaint();
                            if (w != null) {
                                w.toFront();
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Throwable t) {
                                ImagePanelUI.this.threadStopped = true;
                            }
                        }
                    }
                });
                this.thread.setPriority(10);
                this.thread.start();
            }
        }
    }
}

