/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

public class StringUtilities {
    public static Properties toProperties(String theString, Properties props) {
        if (props == null) {
            props = new Properties();
        }
        if (theString != null && theString.length() > 0) {
            StringBuffer strbuf = new StringBuffer(theString);
            int start = 0;
            String identifier = null;
            String value = null;
            int strlen = theString.length();
            for (int i = 0; i < strlen; ++i) {
                char c = strbuf.charAt(i);
                if (identifier == null) {
                    if (c != '=') continue;
                    identifier = strbuf.substring(start, i).trim();
                    continue;
                }
                start = i;
                while (value == null && ++i < strlen) {
                    c = strbuf.charAt(i);
                    if (c == '\"') {
                        start = i;
                        while (++i < strlen && strbuf.charAt(i) != '\"') {
                        }
                        value = strbuf.substring(start + 1, i);
                        ++i;
                    }
                    if (c >= ' ' && c != ',') continue;
                    value = strbuf.substring(start, i).trim();
                }
                if (value == null) {
                    value = strbuf.substring(start, i).trim();
                }
                props.put(identifier, value);
                identifier = null;
                value = null;
                start = i + 1;
            }
        }
        return props;
    }

    public static String[] split(String s, int sep, boolean trim) {
        if (s != null && sep != 0) {
            Vector<String> v = new Vector<String>();
            int fromIndex = 0;
            int toIndex = 0;
            if (!trim) {
                while ((toIndex = s.indexOf(sep, fromIndex)) != -1) {
                    v.add(s.substring(fromIndex, toIndex));
                    fromIndex = toIndex + 1;
                }
                v.add(s.substring(fromIndex));
            } else {
                while ((toIndex = s.indexOf(sep, fromIndex)) != -1) {
                    v.add(s.substring(fromIndex, toIndex).trim());
                    fromIndex = toIndex + 1;
                }
                v.add(s.substring(fromIndex).trim());
            }
            String[] ret = new String[v.size()];
            Object[] arr = v.toArray();
            System.arraycopy(arr, 0, ret, 0, v.size());
            return ret;
        }
        return new String[1];
    }

    public static String[] split(String s, String sep, boolean trim) {
        if (s != null && sep != null) {
            Vector<String> v = new Vector<String>();
            int fromIndex = 0;
            int toIndex = 0;
            if (!trim) {
                while ((toIndex = s.indexOf(sep, fromIndex)) != -1) {
                    v.add(s.substring(fromIndex, toIndex));
                    fromIndex = toIndex + sep.length();
                }
                v.add(s.substring(fromIndex));
            } else {
                while ((toIndex = s.indexOf(sep, fromIndex)) != -1) {
                    v.add(s.substring(fromIndex, toIndex).trim());
                    fromIndex = toIndex + sep.length();
                }
                v.add(s.substring(fromIndex).trim());
            }
            String[] ret = new String[v.size()];
            Object[] arr = v.toArray();
            System.arraycopy(arr, 0, ret, 0, v.size());
            return ret;
        }
        return new String[1];
    }

    public static Vector vectorSplit(String s, String sep, boolean trim) {
        Vector ret = new Vector();
        ret.copyInto(StringUtilities.split(s, sep, trim));
        return ret;
    }

    public static String substring(String s, String sep, int number, boolean trim) {
        if (s == null) {
            return null;
        }
        if (number == 0) {
            return s;
        }
        String ret = null;
        if (number > 0) {
            int count;
            int index = s.indexOf(sep);
            for (count = 1; index >= 0 && count < number; ++count) {
                index = s.indexOf(sep, index + 1);
            }
            if (index >= 0 && count == number) {
                ret = trim ? s.substring(index + sep.length(), s.length()).trim() : s.substring(index + sep.length(), s.length());
            }
        } else {
            int count;
            number *= -1;
            int index = s.lastIndexOf(sep);
            for (count = 1; index >= 0 && count < number; ++count) {
                index = s.lastIndexOf(sep, index - 1);
            }
            if (index >= 0 && count == number) {
                ret = trim ? s.substring(0, index).trim() : s.substring(0, index);
            }
        }
        return ret;
    }

    public static String substring(String s, char sep, int number, boolean trim) {
        if (s == null) {
            return null;
        }
        if (number == 0) {
            return s;
        }
        return StringUtilities.substring(s, "" + sep, number, trim);
    }

    public static String substring(String s, char sep, int number) {
        return StringUtilities.substring(s, sep, number, false);
    }

    public static String substring(String s, String sep, int number) {
        return StringUtilities.substring(s, sep, number, false);
    }

    public static Vector vectorSplit(String s, int sep, boolean trim) {
        Vector<String> ret = new Vector<String>();
        String[] arr = StringUtilities.split(s, sep, trim);
        int size = arr.length;
        for (int i = 0; i < size; ++i) {
            ret.add(arr[i]);
        }
        return ret;
    }

    public static String concatenate(Collection s, String sep, boolean trim) {
        if (s != null && s.size() != 0) {
            String[] arr = new String[s.size()];
            System.arraycopy(s.toArray(), 0, arr, 0, s.size());
            return StringUtilities.concatenate(arr, sep, trim);
        }
        return "";
    }

    public static String concatenate(String[] s, String sep, boolean trim) {
        if (s != null && s.length != 0) {
            StringBuffer buf = new StringBuffer();
            int size = s.length;
            if (!trim) {
                if (size > 0) {
                    buf.append(s[0]);
                }
                if (sep == null) {
                    for (int i = 1; i < size; ++i) {
                        buf.append(s[i]);
                    }
                } else {
                    for (int i = 1; i < size; ++i) {
                        buf.append(sep + s[i]);
                    }
                }
            } else {
                if (size > 0) {
                    buf.append(s[0].trim());
                }
                if (sep == null) {
                    for (int i = 1; i < size; ++i) {
                        buf.append(s[i].trim());
                    }
                } else {
                    for (int i = 1; i < size; ++i) {
                        buf.append(sep + s[i].trim());
                    }
                }
            }
            return buf.toString();
        }
        return "";
    }

    public static LevenstheinDistance[] levenstheinDistToIgnoreCase(String s, String[] arr) {
        Object[] ret = new LevenstheinDistance[arr.length];
        String su = s.toUpperCase();
        for (int i = 0; i < arr.length; ++i) {
            ret[i] = new LevenstheinDistance(StringUtilities.levensthein(su, arr[i].toUpperCase()), arr[i], s, true);
        }
        Arrays.sort(ret);
        return ret;
    }

    public static LevenstheinDistance[] levenstheinDist(String s, String[] arr) {
        Object[] ret = new LevenstheinDistance[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            ret[i] = new LevenstheinDistance(StringUtilities.levensthein(s, arr[i]), arr[i], s, false);
        }
        Arrays.sort(ret);
        return ret;
    }

    public static String levenstheinFindToIgnoreCase(String s, String[] arr) {
        int dist = Integer.MAX_VALUE;
        int idx = -1;
        String su = s.toUpperCase();
        for (int i = 0; dist > 0 && i < arr.length; ++i) {
            int d = StringUtilities.levensthein(su, arr[i].toUpperCase());
            if (d >= dist) continue;
            idx = i;
            dist = d;
        }
        return arr[idx];
    }

    public static String levenstheinFind(String s, String[] arr) {
        int dist = Integer.MAX_VALUE;
        int idx = -1;
        for (int i = 0; dist > 0 && i < arr.length; ++i) {
            int d = StringUtilities.levensthein(s, arr[i]);
            if (d >= dist) continue;
            idx = i;
            dist = d;
        }
        return arr[idx];
    }

    public static int levenstheinToIgnoreCase(String s1, String s2) {
        return StringUtilities.levensthein(s1.toLowerCase(), s2.toLowerCase());
    }

    public static int levensthein(String s1, String s2) {
        int i;
        if (s1.compareTo(s2) == 0) {
            return 0;
        }
        int slen1 = s1.length();
        int slen2 = s2.length();
        int m1 = slen1 + 1;
        int m2 = slen2 + 1;
        int[][] matrix = new int[m1][m2];
        for (i = 0; i < m1; ++i) {
            matrix[i][0] = i;
        }
        for (int j = 1; j < m2; ++j) {
            matrix[0][j] = j;
        }
        for (i = 1; i < m1; ++i) {
            for (int j = 1; j < m2; ++j) {
                matrix[i][j] = Math.min(matrix[i - 1][j - 1] + (s1.charAt(i - 1) == s2.charAt(j - 1) ? 0 : 1), Math.min(matrix[i - 1][j] + 1, matrix[i][j - 1] + 1));
            }
        }
        return matrix[slen1][slen2];
    }

    public static void main(String[] args) {
        long time = System.currentTimeMillis();
        int i = StringUtilities.levensthein("CARDINALITY", "CARDINALITY");
        System.out.println(System.currentTimeMillis() - time);
        System.out.println(StringUtilities.levenstheinToIgnoreCase("CARDINALITY", "Cardinality"));
        System.out.println(StringUtilities.levensthein("CARDINALITY", "Cardinality"));
        System.out.println(StringUtilities.levenstheinFindToIgnoreCase("nady", new String[]{"karst", "hans", "heidi", "ANDY"}));
        System.exit(i);
    }

    public static class LevenstheinDistance
    implements Comparable {
        protected int dist;
        protected String dest;
        protected String val;
        protected boolean ignoreCase;

        public LevenstheinDistance(int dist, String val, String dest, boolean ignoreCase) {
            this.dist = dist;
            this.val = val;
            this.ignoreCase = ignoreCase;
            this.dest = dest;
        }

        public int getDistance() {
            return this.dist;
        }

        public String getValue() {
            return this.val;
        }

        public String toString() {
            return "[" + this.dist + "]<" + this.val + ">";
        }

        public int compareTo(Object o) {
            int ret = this.dist - ((LevenstheinDistance)o).dist;
            if (ret == 0) {
                int dlen = Math.min(this.dest.length(), this.val.length());
                if ((dlen = Math.min(dlen, ((LevenstheinDistance)o).val.length())) > 0) {
                    String d = this.dest.substring(0, dlen);
                    ret = this.ignoreCase ? d.compareToIgnoreCase(this.val.substring(0, dlen)) - d.compareToIgnoreCase(((LevenstheinDistance)o).val.substring(0, dlen)) : d.compareTo(this.val.substring(0, dlen)) - d.compareTo(((LevenstheinDistance)o).val.substring(0, dlen));
                }
            }
            return ret;
        }
    }
}

