/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLWriter {
    PrintStream ps;
    boolean prologCreated;
    boolean lineNumbering;
    int lineNumber;

    public XMLWriter(PrintStream printStream) {
        this.ps = printStream;
        this.prologCreated = false;
        this.lineNumbering = false;
        this.lineNumber = 1;
    }

    public void lineNumbering(boolean flag) {
        this.lineNumbering = flag;
    }

    protected void createProlog() {
        if (!this.prologCreated) {
            this.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            this.println();
            this.prologCreated = true;
        }
    }

    public void writeDOM(Document dom) throws IOException {
        this.writeDOM("", dom);
    }

    public void writeDOM(String prefix, Document doc) throws IOException {
        this.createProlog();
        this.writeNode(prefix, doc.getDocumentElement());
    }

    public void writeNode(String prefix, Node node) {
        Node aNode;
        String name = node.getNodeName();
        NamedNodeMap attr = node.getAttributes();
        NodeList children = node.getChildNodes();
        int attrCount = 0;
        if (attr != null) {
            attrCount = attr.getLength();
        }
        int childCount = 0;
        if (children != null) {
            childCount = children.getLength();
        }
        if (attrCount > 0) {
            StringBuffer sBuf = new StringBuffer();
            sBuf.append(prefix).append("<").append(name);
            for (int i = 0; i < attrCount - 1; ++i) {
                Node aNode2 = attr.item(i);
                sBuf.append(" ").append(aNode2.getNodeName()).append("=\"").append(aNode2.getNodeValue()).append("\"");
            }
            aNode = attr.item(attrCount - 1);
            sBuf.append(" ").append(aNode.getNodeName()).append("=\"").append(aNode.getNodeValue());
            if (childCount == 0) {
                sBuf.append("\"/>");
            } else {
                sBuf.append("\">");
            }
            this.println(sBuf.toString());
        } else if (childCount == 0) {
            this.println(prefix + "<" + name + "/>");
        } else {
            this.println(prefix + "<" + name + ">");
        }
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                aNode = children.item(i);
                if (aNode.getNodeType() == 3) continue;
                this.writeNode(prefix + "   ", aNode);
            }
            this.println(prefix + "</" + name + ">");
        }
    }

    protected void print(String s) {
        this.ps.print(s);
    }

    protected void println() {
        this.println("");
    }

    protected void println(String s) {
        if (this.lineNumbering) {
            this.ps.print(this.lineNumber + ": ");
        }
        this.ps.println(s);
        ++this.lineNumber;
    }

    public static void main(String[] args) {
        XMLWriter writer = new XMLWriter(System.out);
        try {
            FileInputStream in = new FileInputStream(new File("d:/Java/athos_ini.xml"));
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setValidating(false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(in);
            in.close();
            writer.lineNumbering(true);
            writer.writeDOM(doc);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

