/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.ods.corba;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyBus;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;

public class Tools {
    public static final String DEFAULT_NAME_SERVICE_NAME = "NameService";
    public static final String DEFAULT_NAME_SERVICE_PORT = "900";
    public static final String DEFAULT_CORBA_IMPLEMENTATION = "SunORB";

    public static ORB orbInit(String[] args, Properties props) {
        StringBuffer orbMessage = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            orbMessage.append(args[i] + (i % 2 == 0 ? "=" : ""));
        }
        ORB orb = null;
        orb = ORB.init((String[])args, (Properties)props);
        new FwkException(1073763829, "$RCSfile: Tools.java,v $", "$Revision: 1.7 $", "HJB 2001-07-19 15:35", orbMessage.toString(), null, null);
        return orb;
    }

    public static String[] getOrbArguments(Properties properties) {
        Vector<String> argv = new Vector<String>();
        String corbaImpl = properties.getProperty("CorbaImplementation");
        if (corbaImpl == null || corbaImpl.length() == 0) {
            corbaImpl = FwkPropertyBus.getProperty("CorbaImplementation", DEFAULT_CORBA_IMPLEMENTATION);
        }
        if (corbaImpl.compareToIgnoreCase(DEFAULT_CORBA_IMPLEMENTATION) == 0) {
            String nameServiceRef;
            String nameServicePort;
            String nameServiceHost = properties.getProperty("NameServiceHost");
            if (nameServiceHost == null || nameServiceHost.length() == 0) {
                nameServiceHost = FwkPropertyBus.getProperty("NameServiceHost", System.getProperty("NameServiceHost", FwkContainer.getLocalHost()));
            }
            if ((nameServicePort = properties.getProperty("NameServicePort")) == null || nameServicePort.length() == 0) {
                nameServicePort = FwkPropertyBus.getProperty("NameServicePort", System.getProperty("NameServicePort", DEFAULT_NAME_SERVICE_PORT));
            }
            if ((nameServiceRef = FwkPropertyBus.getProperty("ORBArguments", System.getProperty("ORBArguments"))) == null || nameServiceRef.length() == 0) {
                argv.add("-ORBInitialHost");
                argv.add(nameServiceHost);
                argv.add("-ORBInitialPort");
                argv.add(nameServicePort);
            } else {
                String[] arr = nameServiceRef.split("\\s+");
                for (int i = 0; i < arr.length; ++i) {
                    if (arr[i].length() == 0) continue;
                    argv.add(arr[i]);
                }
            }
        } else if (corbaImpl.compareToIgnoreCase("JacORB") == 0) {
            System.err.println("ERRROR: " + Tools.class.getName() + ".getOrbArguments() JacORB not yet implemented.");
        } else if (corbaImpl.compareToIgnoreCase("OpenORB") == 0) {
            System.err.println("ERRROR: " + Tools.class.getName() + ".getOrbArguments() OpenORB not yet implemented.");
        } else if (corbaImpl.compareToIgnoreCase("Orbix") == 0) {
            System.err.println("ERRROR: " + Tools.class.getName() + ".getOrbArguments() Orbix not yet implemented.");
        } else {
            System.err.println("ERRROR: " + Tools.class.getName() + ".getOrbArguments() unknown CORBA implementation<" + corbaImpl + ">.");
        }
        String[] args = null;
        if (argv.size() > 0) {
            args = argv.toArray(new String[1]);
        }
        return args;
    }

    public static Properties getOrbProperties(Properties properties) {
        Properties props = new Properties();
        String corbaImpl = FwkPropertyBus.getProperty("CorbaImplementation", DEFAULT_CORBA_IMPLEMENTATION);
        if (corbaImpl.compareToIgnoreCase(DEFAULT_CORBA_IMPLEMENTATION) != 0) {
            if (corbaImpl.compareToIgnoreCase("JacORB") == 0) {
                props.put("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
                props.put("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
                props.put("jacorb.retries", "0");
                props.put("jacorb.retry_interval", "0");
                props.put("jacorb.hashtable_class", "java.util.Hashtable");
                props.put("jacorb.poa.monitoring", "off");
                props.put("jacorb.verbosity", "0");
            } else if (corbaImpl.compareToIgnoreCase("OpenORB") == 0) {
                props.put("org.omg.CORBA.ORBClass", "org.openorb.CORBA.ORB");
                props.put("org.omg.CORBA.ORBSingletonClass", "org.openorb.CORBA.ORBSingleton");
            } else if (corbaImpl.compareToIgnoreCase("Orbix") == 0) {
                // empty if block
            }
        }
        if (props.size() == 0) {
            props = null;
        }
        return props;
    }

    public static String toString(String[] args, Properties props) {
        StringBuffer ret = new StringBuffer();
        if (args != null) {
            ret.append("arguments:\n");
            ret.append(args[0]);
            for (int i = 1; i < args.length; ++i) {
                ret.append(", ").append(args[i]);
            }
        } else {
            ret.append("no arguments");
        }
        ret.append("\n");
        if (props != null && props.size() > 0) {
            ret.append("properties:\n");
            Iterator<Object> it = props.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                ret.append(key).append(": ").append(props.getProperty(key)).append("\n");
            }
        } else {
            ret.append("no properties");
        }
        return ret.toString();
    }

    public static String describe(SystemException e) {
        return Tools.describe(e, null, null);
    }

    public static String describe(SystemException e, String[] args, Properties props) {
        String clazz = ((Object)((Object)e)).getClass().getName();
        int minorcode = e.minor & 0xFFFF;
        StringBuffer ret = new StringBuffer("\n");
        ret.append(clazz);
        ret.append("\nMinor Code: ").append(minorcode).append("\n");
        if (clazz.endsWith("COMM_FAILURE")) {
            switch (minorcode) {
                case 201: {
                    ret.append("CONNECT_FAILURE: This may be caused by a java.net.SocketException, usually one of BindException, ConnectException, or NoRouteToHostException.");
                    ret.append("\n\nSome things to verify are:");
                    ret.append("\n1.) Is a naming service running? If not, start the ORBD naming service as described in the document Starting and Stopping ORBD.");
                    ret.append("\n2.) Are the -ORBInitialHost and -ORBInitialPort values being set correctly for the naming service? If you are uncertain about what the settings should be, read the document Starting and Stopping ORBD.");
                    ret.append("\n3.) Are the client and server applications aware of the port number (and machine name, if applicable) where the Naming Service is running? Read Starting and Stopping ORBD for more information on how to do this.");
                    ret.append("\n4.) Is the port usable or may be the firewall blocks the port?");
                    break;
                }
                case 208: {
                    ret.append("CONNECTION ABORT, which generally means the connection has been dropped.");
                    break;
                }
                case 209: {
                    ret.append("CREATE_LISTENER_FAILED: Unable to create the listener thread on the specific port. Either the post is taken or there was an error creating the daemon thread. This generally indicates that the port on which you are trying to run the naming service is in use by another process. If you are running on Solaris, you could discover whether or not something is running on this port using the following terminal prompt command:");
                    ret.append("\n\nnetstat | grep port_number");
                    break;
                }
            }
        } else if (clazz.endsWith("OBJECT_NOT_EXIST")) {
            switch (minorcode) {
                case 204: {
                    ret.append("Literally means SERVANT_NOT_FOUND. It is only thrown in one place: corba.INSSubcontract.getINSReference.");
                    break;
                }
            }
        } else if (clazz.endsWith("MARSHAL")) {
            switch (minorcode) {
                case 202: {
                    ret.append("The program is attempting to marshal an object that derives from org.omg.CORBA.Object, but that particular instance has never been connected to an ORB.\n");
                    ret.append("When using the POA, you need to register the object with the POA first. If you need more information on how to register an object with the POA.");
                    break;
                }
                case 217: {
                    ret.append("The client tried to send either a wchar or wstring  in GIOP 1.0, which is not legal in the spec.");
                    break;
                }
            }
        } else if (clazz.endsWith("BAD_PARAM")) {
            switch (minorcode) {
                case 201: {
                    ret.append("NULL Param\nThis exception often occurs because a Java null was given to a write method such as write_string, write_octet_array, etc. You cannot return a Java null as the result of a Java method. ");
                    break;
                }
            }
        } else if (clazz.endsWith("INTERNAL")) {
            switch (minorcode) {
                case 208: {
                    ret.append("Unable to determine local hostname using InetAddress.getLocalHost().getHostName().");
                    break;
                }
            }
        }
        if (args != null || props != null) {
            ret.append("\n### ORB arguments and properties ###");
            ret.append(Tools.toString(args, props));
        }
        ret.append("\n");
        return ret.toString();
    }
}

